/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import de.justsoftware.drive.business.document.ByteSourceWithFilename;
import de.justsoftware.drive.rest.util.FileItemByteSource;
import de.justsoftware.drive.rest.util.MultipartFileByteSource;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.mail.internet.MimeUtility;
import org.apache.commons.fileupload.FileItem;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public final class MultipartUtil {
    public static final Function<MultipartFile, ByteSourceWithFilename> MULTIPART_FILE_TO_BYTESOURCE = new /* Unavailable Anonymous Inner Class!! */;

    private MultipartUtil() {
    }

    @Nonnull
    @VisibleForTesting
    static String cleanFilename(String filename) {
        int lastSlash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
        if (lastSlash == -1) {
            return filename;
        }
        return filename.substring(lastSlash + 1);
    }

    @Nonnull
    public static ByteSourceWithFilename multipartFileToByteSource(MultipartFile input) {
        return new ByteSourceWithFilename((ByteSource)new MultipartFileByteSource(input), MultipartUtil.cleanFilename((String)MultipartUtil.decodeString((String)((String)Preconditions.checkNotNull((Object)input.getOriginalFilename())))), Optional.fromNullable((Object)input.getContentType()));
    }

    @Nonnull
    public static ByteSourceWithFilename fileItemToByteSource(FileItem fileItem) {
        return new ByteSourceWithFilename((ByteSource)new FileItemByteSource(fileItem), MultipartUtil.cleanFilename((String)MultipartUtil.decodeString((String)((String)Preconditions.checkNotNull((Object)fileItem.getName())))), Optional.fromNullable((Object)fileItem.getContentType()));
    }

    @Nonnull
    private static String decodeString(String text) {
        try {
            return MimeUtility.decodeText((String)text);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee);
        }
    }
}

