/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.document;

import com.google.common.base.Preconditions;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.person.model.PersonId;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class DocumentVersionCreateModel<D extends DocumentVersionCreateModel<D>> {
    final DocumentVersionId _id;
    DocumentVersionId _changeId;
    DocumentId _documentId;
    int _version = 1;
    String _name;
    DocumentVersionId _firstPublishedChangeId;
    PersonId _owner;
    Instant _changeDate;

    protected DocumentVersionCreateModel(DocumentVersionId id) {
        this._id = id;
    }

    @Nonnull
    public DocumentVersionId getId() {
        return this._id;
    }

    @Nonnull
    public DocumentId getDocumentId() {
        return (DocumentId)Preconditions.checkNotNull((Object)this._documentId);
    }

    @Nonnull
    public String getName() {
        return (String)Preconditions.checkNotNull((Object)this._name);
    }

    @Nonnull
    public D setDocumentId(DocumentId documentId) {
        this._documentId = documentId;
        return (D)this.self();
    }

    @Nonnull
    public D setVersion(int version) {
        this._version = version;
        return (D)this.self();
    }

    @Nonnull
    public D setNextVersionOf(DocumentVersionBO bo) {
        return (D)this.setVersion(bo.getVersion() + 1);
    }

    public int getVersion() {
        return this._version;
    }

    @Nonnull
    public D setChangeId(DocumentVersionId changeId) {
        this._changeId = changeId;
        return (D)this.self();
    }

    @Nonnull
    public D setFirstPublishedChangeId(@Nullable DocumentVersionId firstPublishedChangeId) {
        this._firstPublishedChangeId = firstPublishedChangeId;
        return (D)this.self();
    }

    @Nonnull
    public D setName(String name) {
        this._name = name;
        return (D)this.self();
    }

    @Nonnull
    public D setChangeDate(Instant changeDate) {
        this._changeDate = changeDate;
        return (D)this.self();
    }

    @Nonnull
    public D setOwner(PersonId owner) {
        this._owner = owner;
        return (D)this.self();
    }

    @Nonnull
    protected final D newVersionOf(DocumentVersionBO businessObject) {
        return (D)this.setDocumentId(businessObject.getDocumentId()).setName(businessObject.getName()).setNextVersionOf(businessObject);
    }

    @Nonnull
    protected abstract D self();

    public boolean isRoot() {
        return Objects.equals(this._id, this._changeId);
    }
}

