/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.server.business;

import com.google.common.base.Optional;
import de.justsoftware.drive.business.server.business.DriveVersionUpdateProcessInfo;
import de.justsoftware.drive.business.server.business.UpdateBehaviour;
import de.justsoftware.drive.common.versionupdate.model.ComparableVersion;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionUpdateProcessBO;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class ApplyOnceUpdateBehaviour
implements UpdateBehaviour {
    private static final Logger LOG = LoggerFactory.getLogger(ApplyOnceUpdateBehaviour.class);
    private final String _minVersionToApplyFor;
    private final DriveVersionUpdateProcessInfo _process;

    ApplyOnceUpdateBehaviour(DriveVersionUpdateProcessInfo process, String minVersionToApplyFor) {
        this._process = process;
        this._minVersionToApplyFor = minVersionToApplyFor;
    }

    public boolean applyForNewVersion(String currentVersion, UpdateBehaviour.UpdateProcessInformationProvider infoProvider) {
        boolean applyForNewVersion;
        Optional lastExecution = infoProvider.getLastExecution(this._process.getProcessorType());
        boolean bl = applyForNewVersion = (!lastExecution.isPresent() || ((DriveVersionUpdateProcessBO)lastExecution.get()).getProcessorVersion() < this._process.getProcessorVersion()) && new ComparableVersion(this._minVersionToApplyFor).compareTo(new ComparableVersion(currentVersion)) <= 0;
        if (applyForNewVersion) {
            LOG.info("Update process {} was not executed yet and will be applied for version {}.", (Object)this._process.asVersionString(), (Object)currentVersion);
        }
        return applyForNewVersion;
    }
}

