/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.PermissionService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.UserGroup;
import de.justsoftware.chat.business.model.UserGroupMember;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ProfileDeletedEvent;
import de.justsoftware.chat.business.model.event.UserGroupDeletedEvent;
import de.justsoftware.chat.business.model.event.UserGroupMembersAddedEvent;
import de.justsoftware.chat.business.model.event.UserGroupMembersRemovedEvent;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatType;
import de.justsoftware.chat.model.Diff;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.PermissionType;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.persistence.ChatParticipantRepository;
import de.justsoftware.chat.persistence.ChatRepository;
import de.justsoftware.chat.persistence.RemovedParticipantProfileForSyncRepository;
import de.justsoftware.chat.persistence.model.DbChat;
import de.justsoftware.chat.persistence.model.DbChatParticipant;
import de.justsoftware.chat.persistence.model.DbChatParticipantDto;
import de.justsoftware.chat.persistence.model.DbRemovedParticipantProfileForSync;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 o2\u00020\u0001:\u0001oBU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0012J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00182\u0006\u0010!\u001a\u00020\"H\u0016J(\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00180$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0&H\u0016J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0012J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0012J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0012J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0016J\u001e\u00102\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u00104\u001a\u00020)H\u0016J$\u00105\u001a\b\u0012\u0004\u0012\u00020)0\u001d2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u00100\u001a\u000201H\u0016J$\u00106\u001a\b\u0012\u0004\u0012\u00020+0\u001d2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u00100\u001a\u000201H\u0016J(\u00107\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u0002080\u00180$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0016J*\u00109\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002080$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010:\u001a\u00020)H\u0016J\u001a\u0010;\u001a\u0004\u0018\u00010\"2\u0006\u0010<\u001a\u00020)2\u0006\u0010=\u001a\u00020)H\u0016J*\u0010>\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\"0$2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020)0\u001d2\u0006\u0010=\u001a\u00020)H\u0016J*\u0010@\u001a\b\u0012\u0004\u0012\u00020 0A2\u0006\u0010!\u001a\u00020\"2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020C0$H\u0017J.\u0010D\u001a\u001a\u0012\u0004\u0012\u00020\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020C0$0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0&H\u0016J\"\u0010E\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u001d0$2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010F\u001a\u00020G2\u0006\u0010!\u001a\u00020\"2\u0006\u0010H\u001a\u00020)H\u0017J\u0018\u0010I\u001a\u00020G2\u0006\u0010!\u001a\u00020\"2\u0006\u0010J\u001a\u00020)H\u0017J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020 0\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010L\u001a\u00020)H\u0017J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010N\u001a\u00020OH\u0017J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010Q\u001a\u00020RH\u0017J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010T\u001a\u00020UH\u0017J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010T\u001a\u00020WH\u0017J8\u0010X\u001a\u00020G2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020 0A2\u0006\u0010!\u001a\u00020\"2\u0006\u0010Z\u001a\u00020)2\u0006\u0010[\u001a\u00020\\2\b\b\u0002\u0010]\u001a\u00020\\H\u0012J!\u0010^\u001a\b\u0012\u0004\u0012\u00020)0\u001d2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020 0_H\u0013\u00a2\u0006\u0002\b`J!\u0010^\u001a\b\u0012\u0004\u0012\u00020)0\u001d2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0_H\u0013\u00a2\u0006\u0002\baJ$\u0010b\u001a\u00020G2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020)0\u001d2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0012J6\u0010d\u001a\u00020G2\u0006\u0010!\u001a\u00020\"2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020C0$2\u0006\u0010H\u001a\u00020)2\b\b\u0002\u0010]\u001a\u00020\\H\u0017J&\u0010e\u001a\u00020G2\u0006\u0010f\u001a\u00020g2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020 0A2\u0006\u0010H\u001a\u00020)H\u0012J.\u0010h\u001a\u00020G2\u0006\u0010!\u001a\u00020\"2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020 0A2\u0006\u0010H\u001a\u00020)2\u0006\u0010]\u001a\u00020\\H\u0012J&\u0010i\u001a\u00020G2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020 0\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010H\u001a\u00020)H\u0012J\u001e\u0010j\u001a\u00020G2\u0006\u0010k\u001a\u00020l2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020 0AH\u0012J\u0018\u0010m\u001a\u00020n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010]\u001a\u00020\\H\u0012R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006p"}, d2={"Lde/justsoftware/chat/business/ChatParticipantService;", "", "userGroupService", "Lde/justsoftware/chat/business/UserGroupService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "authorizationService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "permissionService", "Lde/justsoftware/chat/business/PermissionService;", "chatParticipantRepository", "Lde/justsoftware/chat/persistence/ChatParticipantRepository;", "chatRepository", "Lde/justsoftware/chat/persistence/ChatRepository;", "removedParticipantProfileRepository", "Lde/justsoftware/chat/persistence/RemovedParticipantProfileForSyncRepository;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/business/UserGroupService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/authorization/AuthorizationService;Lde/justsoftware/chat/business/PermissionService;Lde/justsoftware/chat/persistence/ChatParticipantRepository;Lde/justsoftware/chat/persistence/ChatRepository;Lde/justsoftware/chat/persistence/RemovedParticipantProfileForSyncRepository;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/chat/util/TransactionUtils;Ljava/time/Clock;)V", "deleteParticipant", "", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "participantId", "Lde/justsoftware/chat/model/ParticipantId;", "deletedUserGroupMembers", "", "Lde/justsoftware/chat/business/model/UserGroupMember;", "findByChatId", "Lde/justsoftware/chat/business/model/ChatParticipant;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "findByChatIds", "", "chatIds", "", "findChatsOfProfileWithoutGroup", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "groupId", "Lde/justsoftware/chat/model/UserGroupId;", "findChatsWithParticipant", "findChatsWithParticipants", "participantIds", "findChatsWithProfileAdded", "since", "Ljava/time/Instant;", "findChatsWithProfileRemoved", "findOneOnOneChatIdsByProfileId", "id", "findUpdatedDirectParticipants", "findUpdatedGroupParticipants", "getDirectChatPartners", "Lde/justsoftware/chat/business/model/Profile;", "getDirectChatPartnersForProfile", "currentProfileId", "getOneOnOneChatIdByChatPartnerId", "chatPartnerId", "userId", "getOneOnOneChatIdByChatPartnerIds", "chatPartnerIds", "getParticipantChanges", "Lde/justsoftware/chat/model/Diff;", "participants", "Lde/justsoftware/chat/model/PermissionType;", "getParticipantPermissionsByChatIds", "getProfileIdsOfParticipants", "leaveChat", "", "currentUserId", "moveParticipantsFromDeleted", "restoredBy", "moveParticipantsToDeleted", "deletedBy", "onProfileDeleted", "profileDeletedEvent", "Lde/justsoftware/chat/business/model/event/ProfileDeletedEvent;", "onUserGroupDeleted", "userGroupDeletedEvent", "Lde/justsoftware/chat/business/model/event/UserGroupDeletedEvent;", "onUserGroupMembersAdded", "event", "Lde/justsoftware/chat/business/model/event/UserGroupMembersAddedEvent;", "onUserGroupMembersRemoved", "Lde/justsoftware/chat/business/model/event/UserGroupMembersRemovedEvent;", "participantsChanged", "diff", "updater", "withSystemMessage", "", "isNewChat", "resolveProfileIds", "", "resolveProfileIdsOfParticipants", "resolveProfileIdsOfParticipantIds", "saveRemovedParticipantProfilesForSync", "profileIds", "setParticipants", "validateAddedParticipants", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "validateParticipantChanges", "validateParticipantsForLeaveChat", "validateResultingParticipants", "chatType", "Lde/justsoftware/chat/model/ChatType;", "validatedChatForParticipantChange", "Lde/justsoftware/chat/persistence/model/DbChat;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatParticipantService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatParticipantService.kt\nde/justsoftware/chat/business/ChatParticipantService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ChatParticipant.kt\nde/justsoftware/chat/business/model/ChatParticipant$Companion\n*L\n1#1,545:1\n1549#2:546\n1620#2,3:547\n1549#2:550\n1620#2,3:551\n1620#2,3:555\n1620#2,3:559\n1620#2,3:563\n766#2:567\n857#2,2:568\n1179#2,2:570\n1253#2,4:572\n1549#2:576\n1620#2,3:577\n1179#2,2:580\n1253#2,2:582\n1549#2:584\n1620#2,3:585\n1256#2:588\n1549#2:589\n1620#2,3:590\n809#2,2:594\n1271#2,2:596\n1285#2,4:598\n1238#2,2:604\n1179#2,2:606\n1253#2,4:608\n1241#2:612\n1549#2:613\n1620#2,3:614\n1179#2,2:617\n1253#2,4:619\n1620#2,3:624\n1603#2,9:629\n1855#2:638\n288#2,2:639\n1856#2:642\n1612#2:643\n1179#2,2:645\n1253#2,4:647\n1238#2,2:653\n1549#2:656\n1620#2,3:657\n809#2,2:662\n1241#2:664\n1446#2,5:666\n1271#2,2:671\n1285#2,2:673\n1603#2,9:675\n1855#2:684\n1856#2:686\n1612#2:687\n1288#2:688\n1620#2,3:690\n1549#2:693\n1620#2,3:694\n1620#2,3:698\n1549#2:701\n1620#2,3:702\n1620#2,3:706\n1549#2:709\n1620#2,3:710\n1620#2,3:714\n1360#2:717\n1446#2,2:718\n1549#2:720\n1620#2,3:721\n1448#2,3:724\n1360#2:727\n1446#2,2:728\n1549#2:730\n1620#2,3:731\n1448#2,3:734\n1620#2,3:738\n1620#2,3:742\n1549#2:745\n1620#2,2:746\n1620#2,3:749\n1622#2:752\n1360#2:754\n1446#2,2:755\n1549#2:757\n1620#2,3:758\n1448#2,3:761\n766#2:764\n857#2,2:765\n1620#2,3:768\n809#2,2:779\n1855#2,2:781\n809#2,2:784\n1855#2,2:786\n288#2,2:788\n288#2,2:790\n1549#2:792\n1620#2,3:793\n1620#2,3:797\n1620#2,3:801\n809#2,2:805\n809#2,2:808\n7#3:554\n7#3:558\n7#3:562\n22#3:593\n7#3:623\n80#3,2:627\n82#3:644\n22#3:661\n13#3:665\n7#3:689\n7#3:697\n7#3:705\n7#3:713\n7#3:737\n7#3:741\n7#3:748\n121#3:753\n7#3:767\n22#3:778\n22#3:783\n7#3:796\n7#3:800\n22#3:804\n22#3:807\n1#4:566\n1#4:641\n1#4:685\n453#5:602\n403#5:603\n453#5:651\n403#5:652\n494#5,7:771\n41#6:655\n42#6:660\n*S KotlinDebug\n*F\n+ 1 ChatParticipantService.kt\nde/justsoftware/chat/business/ChatParticipantService\n*L\n73#1:546\n73#1:547,3\n76#1:550\n76#1:551,3\n123#1:555,3\n127#1:559,3\n131#1:563,3\n211#1:567\n211#1:568,2\n212#1:570,2\n212#1:572,4\n218#1:576\n218#1:577,3\n220#1:580,2\n220#1:582,2\n221#1:584\n221#1:585,3\n220#1:588\n231#1:589\n231#1:590,3\n232#1:594,2\n235#1:596,2\n235#1:598,4\n245#1:604,2\n246#1:606,2\n246#1:608,4\n245#1:612\n255#1:613\n255#1:614,3\n259#1:617,2\n259#1:619,4\n271#1:624,3\n278#1:629,9\n278#1:638\n278#1:639,2\n278#1:642\n278#1:643\n278#1:645,2\n278#1:647,4\n282#1:653,2\n283#1:656\n283#1:657,3\n283#1:662,2\n282#1:664\n285#1:666,5\n287#1:671,2\n287#1:673,2\n290#1:675,9\n290#1:684\n290#1:686\n290#1:687\n287#1:688\n298#1:690,3\n304#1:693\n304#1:694,3\n305#1:698,3\n310#1:701\n310#1:702,3\n313#1:706,3\n318#1:709\n318#1:710,3\n321#1:714,3\n325#1:717\n325#1:718,2\n329#1:720\n329#1:721,3\n325#1:724,3\n343#1:727\n343#1:728,2\n352#1:730\n352#1:731,3\n343#1:734,3\n385#1:738,3\n390#1:742,3\n396#1:745\n396#1:746,2\n398#1:749,3\n396#1:752\n414#1:754\n414#1:755,2\n414#1:757\n414#1:758,3\n414#1:761,3\n446#1:764\n446#1:765,2\n466#1:768,3\n476#1:779,2\n477#1:781,2\n483#1:784,2\n485#1:786,2\n501#1:788,2\n506#1:790,2\n521#1:792\n521#1:793,3\n522#1:797,3\n527#1:801,3\n532#1:805,2\n533#1:808,2\n123#1:554\n127#1:558\n131#1:562\n232#1:593\n271#1:623\n278#1:627,2\n278#1:644\n283#1:661\n285#1:665\n298#1:689\n305#1:697\n313#1:705\n321#1:713\n385#1:737\n390#1:741\n398#1:748\n414#1:753\n466#1:767\n476#1:778\n483#1:783\n522#1:796\n527#1:800\n532#1:804\n533#1:807\n278#1:641\n290#1:685\n245#1:602\n245#1:603\n282#1:651\n282#1:652\n470#1:771,7\n283#1:655\n283#1:660\n*E\n"})
public class ChatParticipantService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ChatParticipantRepository chatParticipantRepository;
    @NotNull
    private final ChatRepository chatRepository;
    @NotNull
    private final RemovedParticipantProfileForSyncRepository removedParticipantProfileRepository;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final Clock clock;

    public ChatParticipantService(@NotNull UserGroupService userGroupService, @NotNull ProfileService profileService, @NotNull AuthorizationService authorizationService, @NotNull PermissionService permissionService, @NotNull ChatParticipantRepository chatParticipantRepository, @NotNull ChatRepository chatRepository, @NotNull RemovedParticipantProfileForSyncRepository removedParticipantProfileRepository, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull TransactionUtils transactionUtils, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantRepository, (String)"chatParticipantRepository");
        Intrinsics.checkNotNullParameter((Object)chatRepository, (String)"chatRepository");
        Intrinsics.checkNotNullParameter((Object)removedParticipantProfileRepository, (String)"removedParticipantProfileRepository");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.userGroupService = userGroupService;
        this.profileService = profileService;
        this.authorizationService = authorizationService;
        this.permissionService = permissionService;
        this.chatParticipantRepository = chatParticipantRepository;
        this.chatRepository = chatRepository;
        this.removedParticipantProfileRepository = removedParticipantProfileRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.transactionUtils = transactionUtils;
        this.clock = clock;
    }

    @Transactional
    public void setParticipants(@NotNull ChatId chatId, @NotNull Map<ParticipantId, ? extends PermissionType> participants, @NotNull ProfileId currentUserId, boolean isNewChat) throws ValidationException {
        ChatParticipant it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        Diff diff2 = this.getParticipantChanges(chatId, participants);
        if (!diff2.getHasChanges()) {
            return;
        }
        this.validateParticipantChanges(chatId, diff2, currentUserId, isNewChat);
        Iterable iterable = CollectionsKt.plus((Collection)diff2.getModified(), (Iterable)diff2.getAdded());
        ChatParticipantRepository chatParticipantRepository = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbChatParticipant.Companion.toDbChatParticipant(it));
        }
        chatParticipantRepository.saveAll((Iterable)((List)destination$iv$iv));
        $this$map$iv = diff2.getRemoved();
        chatParticipantRepository = this.chatParticipantRepository;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ChatParticipant)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbChatParticipant.Companion.toDbChatParticipant(it));
        }
        chatParticipantRepository.deleteAll((Iterable)((List)destination$iv$iv));
        iterable = SetsKt.setOf((Object)chatId);
        Set set = this.resolveProfileIdsOfParticipants(diff2.getRemoved());
        this.saveRemovedParticipantProfilesForSync(set, (Set)iterable);
        if (!isNewChat) {
            Set set2 = SetsKt.setOf((Object)chatId.getValue());
            Instant instant = this.clock.instant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
            this.chatRepository.updateSyncDateByChatIds(set2, instant);
        }
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static /* synthetic */ void setParticipants$default(ChatParticipantService chatParticipantService, ChatId chatId, Map map, ProfileId profileId, boolean bl, int n, Object object) throws ValidationException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setParticipants");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        chatParticipantService.setParticipants(chatId, map, profileId, bl);
    }

    @Transactional
    @NotNull
    public Diff<ChatParticipant> getParticipantChanges(@NotNull ChatId chatId, @NotNull Map<ParticipantId, ? extends PermissionType> participants) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        return new Diff((Collection)this.findByChatId(chatId), (Collection)ChatParticipant.Companion.toChatParticipants(participants, chatId, this.clock), (Function1)getParticipantChanges.1.INSTANCE, (Function1)getParticipantChanges.2.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private void participantsChanged(Diff<ChatParticipant> diff2, ChatId chatId, ProfileId updater, boolean withSystemMessage, boolean isNewChat) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        this.permissionService.replaceRolePermissionsForChat(chatId);
        Iterable $this$mapToSet$iv = diff2.getAdded();
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Iterator p0;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getParticipantId());
        }
        Set addedParticipants = (Set)destination$iv$iv;
        Set effectiveProfileIdsAdded = SetsKt.minus((Set)this.resolveProfileIdsOfParticipantIds((Collection)addedParticipants), (Iterable)this.resolveProfileIdsOfParticipants(diff2.getFrom()));
        Iterable $this$mapToSet$iv2 = diff2.getRemoved();
        boolean $i$f$mapToSet2 = false;
        Iterable $i$f$mapTo22 = $this$mapToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo32 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(p0.getParticipantId());
        }
        Set removedParticipants = (Set)destination$iv$iv2;
        Set effectiveProfileIdsRemoved = SetsKt.minus((Set)this.resolveProfileIdsOfParticipantIds((Collection)removedParticipants), (Iterable)this.resolveProfileIdsOfParticipants(diff2.getTo()));
        Iterable $this$mapToSet$iv3 = diff2.getModified();
        boolean $i$f$mapToSet3 = false;
        Iterable $i$f$mapTo32 = $this$mapToSet$iv3;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv3));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(p0.getParticipantId());
        }
        Set updatedParticipants = (Set)destination$iv$iv3;
        Set effectiveProfileIdsUpdated = this.resolveProfileIdsOfParticipants(diff2.getModified());
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ChatParticipantsChangedEvent((Object)this, chatId, isNewChat, addedParticipants, effectiveProfileIdsAdded, removedParticipants, effectiveProfileIdsRemoved, updatedParticipants, effectiveProfileIdsUpdated, withSystemMessage, updater));
    }

    static /* synthetic */ void participantsChanged$default(ChatParticipantService chatParticipantService, Diff diff2, ChatId chatId, ProfileId profileId, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: participantsChanged");
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        chatParticipantService.participantsChanged(diff2, chatId, profileId, bl, bl2);
    }

    @Transactional
    @NotNull
    public List<ChatParticipant> moveParticipantsToDeleted(@NotNull ChatId chatId, @NotNull ProfileId deletedBy) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)deletedBy, (String)"deletedBy");
        List participantsBeforeDeletion = this.findByChatId(chatId);
        this.chatParticipantRepository.copyParticipantsToDeleted(chatId.getValue());
        this.chatParticipantRepository.deleteByChatId(chatId.getValue());
        Set set = SetsKt.setOf((Object)chatId);
        Set set2 = this.resolveProfileIdsOfParticipants((Collection)participantsBeforeDeletion);
        this.saveRemovedParticipantProfilesForSync(set2, set);
        Diff diff2 = new Diff((Collection)participantsBeforeDeletion, (Collection)SetsKt.emptySet(), (Function1)moveParticipantsToDeleted.diff.1.INSTANCE, (Function1)moveParticipantsToDeleted.diff.2.INSTANCE);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return participantsBeforeDeletion;
    }

    @Transactional
    public void moveParticipantsFromDeleted(@NotNull ChatId chatId, @NotNull ProfileId restoredBy) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)restoredBy, (String)"restoredBy");
        UUID uUID = chatId.getValue();
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        this.chatParticipantRepository.copyParticipantFromDeleted(uUID, instant);
        this.chatParticipantRepository.deleteParticipantFromDeleted(chatId.getValue());
        List participantsAfterRestoration = this.findByChatId(chatId);
        Diff diff2 = new Diff((Collection)SetsKt.emptySet(), (Collection)participantsAfterRestoration, (Function1)moveParticipantsFromDeleted.diff.1.INSTANCE, (Function1)moveParticipantsFromDeleted.diff.2.INSTANCE);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void leaveChat(@NotNull ChatId chatId, @NotNull ProfileId currentUserId) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void it;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        List list = iterable = this.findByChatId(chatId);
        ChatId chatId2 = chatId;
        ChatParticipantService chatParticipantService = this;
        boolean $i$a$-also-ChatParticipantService$leaveChat$22 = false;
        this.validateParticipantsForLeaveChat((List)it, chatId, currentUserId);
        Object object = Unit.INSTANCE;
        iterable = iterable;
        boolean $i$f$filter = false;
        void $i$a$-also-ChatParticipantService$leaveChat$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatParticipant it2 = (ChatParticipant)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it2.getParticipantId(), (Object)currentUserId))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = (List)destination$iv$iv;
        $this$filter$iv = (Iterable)object;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            ChatParticipant it3 = (ChatParticipant)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it3.getParticipantId(), (Object)it3.getPermissionType());
            map.put(pair.getFirst(), pair.getSecond());
        }
        object = destination$iv$iv2;
        ChatParticipantService.setParticipants$default((ChatParticipantService)chatParticipantService, (ChatId)chatId2, (Map)object, (ProfileId)currentUserId, (boolean)false, (int)8, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, List<ChatParticipant>> findByChatIds(@NotNull Iterable<ChatId> chatIds2) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Iterable<ChatId> iterable = chatIds2;
        ChatParticipantRepository chatParticipantRepository = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        Iterable $this$associate$iv = chatParticipantRepository.findDtoByChatIds((Iterable)((List)destination$iv$iv)).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            UUID chatId = (UUID)entry.getKey();
            List participants = (List)entry.getValue();
            Iterable iterable2 = participants;
            ChatId chatId2 = new ChatId(chatId);
            boolean $i$f$map2 = false;
            void var18_24 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DbChatParticipantDto dbChatParticipantDto = (DbChatParticipantDto)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(DbChatParticipantDto.Companion.toChatParticipant((DbChatParticipantDto)it));
            }
            entry = TuplesKt.to((Object)chatId2, (Object)((List)destination$iv$iv3));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    @NotNull
    public List<ChatParticipant> findByChatId(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        return this.findByChatIds((Iterable)SetsKt.setOf((Object)chatId)).getOrDefault(chatId, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatParticipant, Set<ProfileId>> getProfileIdsOfParticipants(@NotNull ChatId chatId) {
        void $this$filterIsInstanceTo$iv$iv;
        Set $this$filterIsInstanceToSet$iv;
        ChatParticipant p0;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        List participants = this.findByChatId(chatId);
        Iterable iterable = participants;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(p0.getParticipantId());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstanceToSet22 = false;
        $this$mapTo$iv$iv = $this$filterIsInstanceToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstanceToSet$iv = (Set)destination$iv$iv;
        UserGroupService $i$f$filterIsInstanceToSet22 = this.userGroupService;
        Set p02 = $this$filterIsInstanceToSet$iv;
        boolean bl = false;
        Map memberProfileIds = $i$f$filterIsInstanceToSet22.getMemberProfileIds(p02);
        Iterable $this$associateWith$iv = participants;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Set set;
            void participant;
            p0 = (ChatParticipant)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl2 = false;
            ParticipantId id = participant.getParticipantId();
            if (id instanceof ProfileId) {
                set = SetsKt.setOf((Object)id);
            } else if (id instanceof UserGroupId) {
                set = memberProfileIds.getOrDefault(id, SetsKt.emptySet());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Set set2 = set;
            object.put(t, set2);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, Map<ParticipantId, PermissionType>> getParticipantPermissionsByChatIds(@NotNull Iterable<ChatId> chatIds2) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Map $this$mapValues$iv = this.findByChatIds(chatIds2);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$associateTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            List participants = (List)entry2.getValue();
            Iterable $this$associate$iv = participants;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map4 = destination$iv$iv2;
                ChatParticipant it = (ChatParticipant)element$iv$iv;
                boolean bl3 = false;
                Pair pair = TuplesKt.to((Object)it.getParticipantId(), (Object)it.getPermissionType());
                map4.put(pair.getFirst(), pair.getSecond());
            }
            Map map5 = destination$iv$iv2;
            map3.put(k, map5);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, ChatId> getOneOnOneChatIdByChatPartnerIds(@NotNull Set<ProfileId> chatPartnerIds, @NotNull ProfileId userId) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(chatPartnerIds, (String)"chatPartnerIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Iterable iterable = chatPartnerIds;
        ChatParticipantRepository chatParticipantRepository = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$associate$iv = chatParticipantRepository.findOneOnOneChatIdByChatPartnerIds((Iterable)((List)destination$iv$iv), userId.toCanonicalId()).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String participantId = (String)entry.getKey();
            UUID chatId = (UUID)entry.getValue();
            entry = TuplesKt.to((Object)ProfileId.Companion.fromCanonicalId(participantId), (Object)new ChatId(chatId));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    @Nullable
    public ChatId getOneOnOneChatIdByChatPartnerId(@NotNull ProfileId chatPartnerId, @NotNull ProfileId userId) {
        Intrinsics.checkNotNullParameter((Object)chatPartnerId, (String)"chatPartnerId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (ChatId)this.getOneOnOneChatIdByChatPartnerIds(SetsKt.setOf((Object)chatPartnerId), userId).get(chatPartnerId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> findOneOnOneChatIdsByProfileId(@NotNull ProfileId id) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Iterable $this$mapToSet$iv = this.chatParticipantRepository.findOneOnOneChatIdsByProfileId(id.toCanonicalId());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChatId((UUID)it));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, Profile> getDirectChatPartnersForProfile(@NotNull Set<ChatId> chatIds2, @NotNull ProfileId currentProfileId) {
        void $this$associateTo$iv$iv$iv;
        void $this$associate$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Iterable $this$mapNotNull$iv$iv;
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)currentProfileId, (String)"currentProfileId");
        Map $this$mapValuesNotNull$iv = this.getDirectChatPartners(chatIds2);
        boolean $i$f$mapValuesNotNull = false;
        Iterable iterable = $this$mapValuesNotNull$iv.entrySet();
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object v0;
            Map.Entry entry$iv;
            block5: {
                Object element$iv$iv$iv$iv;
                Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                boolean bl = false;
                entry$iv = (Map.Entry)element$iv$iv$iv;
                boolean bl2 = false;
                Map.Entry entry = entry$iv;
                boolean bl3 = false;
                List profiles2 = (List)entry.getValue();
                Iterable $this$firstOrNull$iv = profiles2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Profile profile = (Profile)element$iv;
                    boolean bl4 = false;
                    if (!(!Intrinsics.areEqual((Object)profile.getId(), (Object)currentProfileId))) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            if ((Profile)v0 != null) {
                Profile it$iv;
                boolean bl = false;
                pair = TuplesKt.to(entry$iv.getKey(), (Object)it$iv);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv, (int)10)), (int)16);
        destination$iv$iv$iv = $this$associate$iv$iv;
        Map destination$iv$iv$iv2 = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv) {
            Map map = destination$iv$iv$iv2;
            Pair it$iv = (Pair)element$iv$iv$iv;
            boolean bl = false;
            Pair pair = it$iv;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, List<Profile>> getDirectChatPartners(@NotNull Set<ChatId> chatIds2) {
        void $this$associateWith$iv;
        Iterable list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMapToSet$iv;
        Collection collection;
        Object object;
        Object object2;
        Map.Entry entry;
        Object object3;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Map $this$mapValues$iv = this.findByChatIds((Iterable)chatIds2);
        boolean $i$f$mapValues22 = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterIsInstanceTo$iv$iv$iv;
            void $this$filterIsInstanceToSet$iv$iv;
            void $this$mapTo$iv$iv$iv;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            object = object3;
            boolean bl2 = false;
            List participants = (List)entry.getValue();
            ChatParticipant.Companion companion = ChatParticipant.Companion;
            Iterable $this$filterParticipantIds$iv = participants;
            boolean $i$f$filterParticipantIds = false;
            Iterable $this$map$iv$iv = $this$filterParticipantIds$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void p0$iv;
                ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv$iv;
                Collection collection2 = destination$iv$iv$iv;
                boolean bl3 = false;
                collection2.add(p0$iv.getParticipantId());
            }
            $this$map$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$filterIsInstanceToSet = false;
            $this$mapTo$iv$iv$iv = $this$filterIsInstanceToSet$iv$iv;
            destination$iv$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv$iv));
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv2 : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv2 instanceof ProfileId)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv2);
            }
            collection = (Set)destination$iv$iv$iv;
            object.put(object2, collection);
        }
        Map chatProfileIdsByChatId = destination$iv$iv;
        Iterable $i$f$mapValues22 = chatProfileIdsByChatId.values();
        object = this.profileService;
        boolean $i$f$flatMapToSet = false;
        destination$iv$iv = $this$flatMapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$flatMapToSet$iv));
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Set it = (Set)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Map chatPartners = object.findByIds((Set)destination$iv$iv2);
        $this$flatMapToSet$iv = chatIds2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void chatId;
            list$iv$iv = (ChatId)element$iv$iv;
            object2 = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            object3 = (Iterable)MapsKt.getValue((Map)chatProfileIdsByChatId, (Object)chatId);
            boolean $i$f$mapNotNull = false;
            entry = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Profile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                ProfileId profileId = (ProfileId)element$iv$iv2;
                boolean bl5 = false;
                if ((Profile)chatPartners.get(profileId) == null) continue;
                boolean bl6 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            collection = (List)destination$iv$iv3;
            object.put(object2, collection);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> findChatsWithProfileAdded(@NotNull ProfileId profileId, @NotNull Instant since) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable $this$mapToSet$iv = this.chatParticipantRepository.findChatsWithProfileAdded(profileId.toCanonicalId(), since);
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChatId((UUID)p0));
        }
        return (Set)destination$iv$iv;
    }

    @NotNull
    public Set<ChatId> findChatsWithProfileRemoved(@NotNull ProfileId profileId, @NotNull Instant since) {
        UUID p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable $this$map$iv = this.removedParticipantProfileRepository.findDistinctByProfileIdAndCreatedAtGreaterThan(profileId.toCanonicalId(), since);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DbRemovedParticipantProfileForSync.ChatIdProjection chatIdProjection = (DbRemovedParticipantProfileForSync.ChatIdProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getChatId());
        }
        Iterable $this$mapToSet$iv = (List)destination$iv$iv;
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (UUID)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChatId(p0));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ProfileId> findUpdatedDirectParticipants(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant since) {
        String p0;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable<? extends ParticipantId> iterable = participantIds;
        Object object = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$mapToSet$iv = object.findDirectParticipantsUpdatedSinceByParticipantIds((Iterable)((List)destination$iv$iv), since);
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(ProfileId.Companion.fromCanonicalId((String)it));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<UserGroupId> findUpdatedGroupParticipants(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant since) {
        String p0;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable<? extends ParticipantId> iterable = participantIds;
        Object object = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$mapToSet$iv = object.findGroupParticipantsUpdatedSinceByParticipantIds((Iterable)((List)destination$iv$iv), since);
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(UserGroupId.Companion.fromCanonicalId((String)it));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    @NotNull
    public List<ChatParticipantsChangedEvent> onUserGroupMembersAdded(@NotNull UserGroupMembersAddedEvent event) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$flatMap$iv = event.getUserGroupMembers();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            UserGroupMember member = (UserGroupMember)element$iv$iv;
            boolean bl = false;
            Set chatsWithGroup = this.findChatsWithParticipant((ParticipantId)member.getGroupId());
            Set chatsOfProfileWithoutGroup = this.findChatsOfProfileWithoutGroup(member.getProfileId(), member.getGroupId());
            Iterable $this$map$iv = chatsWithGroup;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void chatId;
                ChatId chatId2 = (ChatId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                boolean isParticipant = chatsOfProfileWithoutGroup.contains(chatId);
                collection.add(new ChatParticipantsChangedEvent((Object)this, (ChatId)chatId, false, null, isParticipant ? SetsKt.emptySet() : SetsKt.setOf((Object)member.getProfileId()), null, null, null, isParticipant ? SetsKt.setOf((Object)member.getProfileId()) : SetsKt.emptySet(), false, null, 1260, null));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    @NotNull
    public List<ChatParticipantsChangedEvent> onUserGroupMembersRemoved(@NotNull UserGroupMembersRemovedEvent event) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$flatMap$iv = event.getUserGroupMembers();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            UserGroupMember member = (UserGroupMember)element$iv$iv;
            boolean bl = false;
            Set chatsWithGroup = this.findChatsWithParticipant((ParticipantId)member.getGroupId());
            Set chatsOfProfileWithoutGroup = this.findChatsOfProfileWithoutGroup(member.getProfileId(), member.getGroupId());
            Set set = SetsKt.setOf((Object)member.getProfileId());
            this.saveRemovedParticipantProfilesForSync(set, chatsWithGroup);
            Iterable $this$map$iv = chatsWithGroup;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void chatId;
                ChatId chatId2 = (ChatId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                boolean isParticipant = chatsOfProfileWithoutGroup.contains(chatId);
                collection.add(new ChatParticipantsChangedEvent((Object)this, (ChatId)chatId, false, null, null, null, isParticipant ? SetsKt.emptySet() : SetsKt.setOf((Object)member.getProfileId()), null, isParticipant ? SetsKt.setOf((Object)member.getProfileId()) : SetsKt.emptySet(), false, null, 1212, null));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @EventListener
    @Transactional
    @NotNull
    public List<ChatParticipantsChangedEvent> onProfileDeleted(@NotNull ProfileDeletedEvent profileDeletedEvent) {
        Intrinsics.checkNotNullParameter((Object)profileDeletedEvent, (String)"profileDeletedEvent");
        return ChatParticipantService.deleteParticipant$default((ChatParticipantService)this, (ParticipantId)((ParticipantId)profileDeletedEvent.getProfileId()), null, (int)2, null);
    }

    @EventListener
    @Transactional
    @NotNull
    public List<ChatParticipantsChangedEvent> onUserGroupDeleted(@NotNull UserGroupDeletedEvent userGroupDeletedEvent) {
        Intrinsics.checkNotNullParameter((Object)userGroupDeletedEvent, (String)"userGroupDeletedEvent");
        return this.deleteParticipant((ParticipantId)userGroupDeletedEvent.getUserGroupId(), userGroupDeletedEvent.getUserGroupMembers());
    }

    /*
     * WARNING - void declaration
     */
    private List<ChatParticipantsChangedEvent> deleteParticipant(ParticipantId participantId, Set<UserGroupMember> deletedUserGroupMembers) {
        void $this$mapTo$iv$iv;
        ChatId $this$mapTo$iv$iv2;
        Iterable iterable;
        void $this$mapTo$iv$iv3;
        Set $this$mapToSet$iv;
        Set set;
        Set chatIdsWithDeletedParticipant = set = this.findChatsWithParticipant(participantId);
        boolean $i$a$-also-ChatParticipantService$deleteParticipant$22 = false;
        this.chatParticipantRepository.deleteByParticipantIds(SetsKt.setOf((Object)participantId.toCanonicalId()));
        Iterable iterable2 = chatIdsWithDeletedParticipant;
        Object object = this.chatRepository;
        boolean $i$f$mapToSet = false;
        void var9_13 = $this$mapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            iterable = destination$iv$iv;
            boolean bl = false;
            iterable.add(p0.getValue());
        }
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        object.updateSyncDateByChatIds((Set)destination$iv$iv, instant);
        Iterable $this$mapToSet$iv2 = deletedUserGroupMembers;
        boolean $i$f$mapToSet2 = false;
        destination$iv$iv = $this$mapToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            UserGroupMember bl = (UserGroupMember)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add(p0.getProfileId());
        }
        $this$mapToSet$iv = (Set)destination$iv$iv2;
        this.saveRemovedParticipantProfilesForSync($this$mapToSet$iv, chatIdsWithDeletedParticipant);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable $i$a$-also-ChatParticipantService$deleteParticipant$22 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void chatId;
            Set set2;
            $this$mapTo$iv$iv2 = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            ParticipantId $i$f$mapTo22 = participantId;
            if ($i$f$mapTo22 instanceof UserGroupId) {
                void $this$mapTo$iv$iv4;
                Iterable $this$mapToSet$iv3 = deletedUserGroupMembers;
                boolean $i$f$mapToSet3 = false;
                iterable = $this$mapToSet$iv3;
                Collection destination$iv$iv4 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv3));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                    void p0;
                    UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv2;
                    Collection collection2 = destination$iv$iv4;
                    boolean bl3 = false;
                    collection2.add(p0.getProfileId());
                }
                set2 = (Set)destination$iv$iv4;
            } else if ($i$f$mapTo22 instanceof ProfileId) {
                set2 = SetsKt.setOf((Object)participantId);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Set deletedProfileIds = set2;
            Set currentProfileIds = this.resolveProfileIdsOfParticipants((Collection)this.findByChatId((ChatId)chatId));
            collection.add(new ChatParticipantsChangedEvent((Object)this, (ChatId)chatId, false, null, null, SetsKt.setOf((Object)participantId), SetsKt.minus((Set)deletedProfileIds, (Iterable)currentProfileIds), null, null, true, null, 1436, null));
        }
        return (List)destination$iv$iv3;
    }

    static /* synthetic */ List deleteParticipant$default(ChatParticipantService chatParticipantService, ParticipantId participantId, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deleteParticipant");
        }
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return chatParticipantService.deleteParticipant(participantId, set);
    }

    /*
     * WARNING - void declaration
     */
    private void saveRemovedParticipantProfilesForSync(Set<ProfileId> profileIds, Set<ChatId> chatIds2) {
        void $this$flatMapTo$iv$iv$iv;
        void $this$cartesianProduct$iv;
        Iterable iterable = profileIds;
        Companion companion = Companion;
        RemovedParticipantProfileForSyncRepository removedParticipantProfileForSyncRepository = this.removedParticipantProfileRepository;
        boolean $i$f$cartesianProduct = false;
        void $this$flatMap$iv$iv = $this$cartesianProduct$iv;
        boolean $i$f$flatMap = false;
        void var8_9 = $this$flatMap$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv$iv;
            Object element$iv$iv$iv;
            Object a$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Iterable $this$map$iv$iv = chatIds2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv$iv;
            Collection destination$iv$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void p1;
                void b$iv;
                Object item$iv$iv$iv;
                Object t = item$iv$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv$iv2;
                boolean bl2 = false;
                ChatId chatId = (ChatId)b$iv;
                ProfileId p0 = (ProfileId)a$iv;
                boolean bl3 = false;
                collection.add(Companion.access$createDbRemovedParticipantProfile((Companion)companion, (ProfileId)p0, (ChatId)p1));
            }
            Iterable list$iv$iv$iv = (List)destination$iv$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv$iv, (Iterable)list$iv$iv$iv);
        }
        removedParticipantProfileForSyncRepository.saveAll((Iterable)((List)destination$iv$iv$iv));
    }

    private void validateParticipantChanges(ChatId chatId, Diff<ChatParticipant> diff2, ProfileId currentUserId, boolean isNewChat) throws ValidationException {
        DbChat chat = this.validatedChatForParticipantChange(chatId, isNewChat);
        this.validateResultingParticipants(chat.getType(), diff2);
        this.validateAddedParticipants(new TenantId(chat.getTenantId()), diff2, currentUserId);
    }

    private DbChat validatedChatForParticipantChange(ChatId chatId, boolean isNewChat) throws ValidationException {
        DbChat chat = (DbChat)this.chatRepository.findById((Object)chatId.getValue()).orElseThrow(() -> ChatParticipantService.validatedChatForParticipantChange$lambda$41(chatId));
        if (chat.getType() == ChatType.ONE_ON_ONE && !isNewChat) {
            throw new ValidationException("ONE_ON_ONE chats may not be updated", null, 2, null);
        }
        Intrinsics.checkNotNull((Object)chat);
        return chat;
    }

    /*
     * WARNING - void declaration
     */
    private void validateResultingParticipants(ChatType chatType, Diff<ChatParticipant> diff2) throws ValidationException {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = diff2.getTo();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatParticipant it = (ChatParticipant)element$iv$iv;
            boolean bl = false;
            if (!(it.getPermissionType() == PermissionType.MANAGER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List managers = (List)destination$iv$iv;
        switch (WhenMappings.$EnumSwitchMapping$0[chatType.ordinal()]) {
            case 1: {
                if (diff2.getTo().size() == 2 && managers.size() == 2) break;
                throw new ValidationException("A ONE_ON_ONE chat requires exactly 2 managers", null, 2, null);
            }
            case 2: {
                if (!managers.isEmpty()) break;
                throw new ValidationException("A chat requires at least one manager", null, 2, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateAddedParticipants(TenantId tenantId, Diff<ChatParticipant> diff2, ProfileId currentUserId) throws ValidationException {
        void $this$filterIsInstanceTo$iv$iv;
        Object element$iv2;
        Iterator $this$filterIsInstanceTo$iv$iv2;
        void $this$filterValues$iv;
        void $this$mapTo$iv$iv;
        if (diff2.getAdded().isEmpty()) {
            return;
        }
        Iterable $this$mapToSet$iv = diff2.getAdded();
        boolean $i$f$mapToSet22 = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getParticipantId());
        }
        Set addedParticipantIds = (Set)destination$iv$iv;
        Map $i$f$mapToSet22 = this.authorizationService.mayInteractWithParticipants(addedParticipantIds, currentUserId);
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            boolean it = (Boolean)entry$iv.getValue();
            boolean bl = false;
            if (!(!it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set nonInteractable = ((Map)result$iv).keySet();
        if (!((Collection)nonInteractable).isEmpty()) {
            throw new ValidationException("Adding non interactable participants is not allowed: " + nonInteractable, null, 2, null);
        }
        Iterable $this$filterIsInstanceToSet$iv = addedParticipantIds;
        boolean $i$f$filterIsInstanceToSet = false;
        Iterable $i$f$mapTo22 = $this$filterIsInstanceToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        Iterator bl = $this$filterIsInstanceTo$iv$iv2.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set profileIds = (Set)destination$iv$iv2;
        Iterable $this$forEach$iv = profileIds;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ProfileId profileId = (ProfileId)element$iv2;
            boolean bl2 = false;
            if (this.authorizationService.isMemberOfTenant(tenantId, profileId)) continue;
            throw new ValidationException(profileId + " is not in the same tenant as chat tenant (" + tenantId + ").", null, 2, null);
        }
        Iterable $this$filterIsInstanceToSet$iv2 = addedParticipantIds;
        boolean $i$f$filterIsInstanceToSet2 = false;
        element$iv2 = $this$filterIsInstanceToSet$iv2;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv2));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        Set userGroupIds = (Set)destination$iv$iv3;
        Map userGroups2 = this.userGroupService.findByIds(userGroupIds);
        Iterable $this$forEach$iv2 = userGroupIds;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            UserGroup userGroup;
            UserGroupId userGroupId = (UserGroupId)element$iv3;
            boolean bl3 = false;
            if ((UserGroup)userGroups2.get(userGroupId) == null) {
                throw new ValidationException(userGroupId + " does not exists.", null, 2, null);
            }
            if (Intrinsics.areEqual((Object)userGroup.getTenantId(), (Object)tenantId)) continue;
            throw new ValidationException(userGroupId + " is not in the same tenant (" + userGroup.getTenantId() + ") as chat tenant (" + tenantId + ").", null, 2, null);
        }
    }

    private void validateParticipantsForLeaveChat(List<ChatParticipant> participants, ChatId chatId, ProfileId currentUserId) {
        Object v0;
        ChatParticipant it;
        Iterable $this$firstOrNull$iv;
        boolean $i$f$firstOrNull;
        block5: {
            Iterable iterable = participants;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (ChatParticipant)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getParticipantId(), (Object)currentUserId)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        ChatParticipant chatParticipant = v0;
        if (chatParticipant == null) {
            throw new NotAllowedException("Cannot leave " + chatId + ". " + currentUserId + " participates through group membership.");
        }
        ChatParticipant participant = chatParticipant;
        if (participant.getPermissionType() == PermissionType.MANAGER) {
            Object v2;
            block6: {
                $this$firstOrNull$iv = participants;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (ChatParticipant)element$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it.getParticipantId(), (Object)currentUserId) && it.getPermissionType() == PermissionType.MANAGER)) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            if ((ChatParticipant)v2 == null) {
                throw new NotAllowedException("Cannot leave " + chatId + ". " + currentUserId + " is the only manager left.");
            }
        }
    }

    private Set<ChatId> findChatsOfProfileWithoutGroup(ProfileId profileId, UserGroupId groupId) {
        Set groupsOfMember = this.userGroupService.getUserGroupIdsByProfileId(profileId);
        return this.findChatsWithParticipants(SetsKt.minus((Set)SetsKt.plus((Set)groupsOfMember, (Object)profileId), (Object)groupId));
    }

    private Set<ChatId> findChatsWithParticipant(ParticipantId participantId) {
        return this.findChatsWithParticipants(SetsKt.setOf((Object)participantId));
    }

    /*
     * WARNING - void declaration
     */
    private Set<ChatId> findChatsWithParticipants(Set<? extends ParticipantId> participantIds) {
        DbChatParticipant p0;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = participantIds;
        Object object = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$mapToSet$iv = object.findByParticipantIds((Iterable)((List)destination$iv$iv));
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (DbChatParticipant)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new ChatId(it.getChatId()));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="resolveProfileIdsOfParticipants")
    private Set<ProfileId> resolveProfileIdsOfParticipants(Collection<ChatParticipant> participants) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv = participants;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getParticipantId());
        }
        Collection p0 = (Set)destination$iv$iv;
        boolean bl = false;
        return this.resolveProfileIdsOfParticipantIds(p0);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="resolveProfileIdsOfParticipantIds")
    private Set<ProfileId> resolveProfileIdsOfParticipantIds(Collection<? extends ParticipantId> participantIds) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstanceToSet$iv = participantIds;
        boolean $i$f$filterIsInstanceToSet = false;
        Iterable iterable = $this$filterIsInstanceToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set profileIds = (Set)destination$iv$iv;
        Iterable $this$filterIsInstanceToSet$iv2 = participantIds;
        boolean $i$f$filterIsInstanceToSet2 = false;
        destination$iv$iv = $this$filterIsInstanceToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv2));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set userGroupIds = (Set)destination$iv$iv2;
        return SetsKt.plus((Set)CollectionUtilsKt.flattenValuesToSet((Map)this.userGroupService.getMemberProfileIds(userGroupIds)), (Iterable)profileIds);
    }

    private static final ValidationException validatedChatForParticipantChange$lambda$41(ChatId $chatId) {
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        return new ValidationException("No chat for id " + $chatId, null, 2, null);
    }

    public static final /* synthetic */ void access$participantsChanged(ChatParticipantService $this, Diff diff2, ChatId chatId, ProfileId updater, boolean withSystemMessage, boolean isNewChat) {
        $this.participantsChanged(diff2, chatId, updater, withSystemMessage, isNewChat);
    }

    public static final /* synthetic */ PermissionService access$getPermissionService$p(ChatParticipantService $this) {
        return $this.permissionService;
    }
}

