/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2.client;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.authorization.oauth2.client.RegisteredClients;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\nH\u0016J \u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0012J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/authorization/oauth2/client/ExposedRegisteredClientRepository;", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "findByClientId", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClient;", "clientId", "", "findById", "id", "parseMap", "", "", "data", "save", "", "registeredClient", "toRegisteredClient", "it", "Lorg/jetbrains/exposed/sql/ResultRow;", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nExposedRegisteredClientRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposedRegisteredClientRepository.kt\nde/justsoftware/authorization/oauth2/client/ExposedRegisteredClientRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1549#2:98\n1620#2,3:99\n1549#2:102\n1620#2,3:103\n*S KotlinDebug\n*F\n+ 1 ExposedRegisteredClientRepository.kt\nde/justsoftware/authorization/oauth2/client/ExposedRegisteredClientRepository\n*L\n74#1:98\n74#1:99,3\n78#1:102\n78#1:103,3\n*E\n"})
public class ExposedRegisteredClientRepository
implements RegisteredClientRepository {
    @NotNull
    private final ObjectMapper objectMapper;

    public ExposedRegisteredClientRepository(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.objectMapper = objectMapper;
    }

    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void save(@NotNull RegisteredClient registeredClient) {
        Intrinsics.checkNotNullParameter((Object)registeredClient, (String)"registeredClient");
        QueriesKt.upsert$default((Table)((Table)RegisteredClients.INSTANCE), (Column[])new Column[0], null, null, null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)14, null);
    }

    @Nullable
    public RegisteredClient findById(@NotNull String id) {
        RegisteredClient registeredClient;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResultRow resultRow = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)RegisteredClients.INSTANCE)).where(SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)RegisteredClients.INSTANCE.getId(), (Comparable)UUID.fromString(id)))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            registeredClient = this.toRegisteredClient(it);
        } else {
            registeredClient = null;
        }
        return registeredClient;
    }

    @Nullable
    public RegisteredClient findByClientId(@NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        ResultRow resultRow = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)RegisteredClients.INSTANCE)).where(SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)RegisteredClients.INSTANCE.getClientId(), (Object)clientId))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            return this.toRegisteredClient(it);
        }
        return null;
    }

    private RegisteredClient toRegisteredClient(ResultRow it) {
        Map tokenSettingsMap = this.parseMap((String)it.get((Expression)RegisteredClients.INSTANCE.getTokenSettings()));
        Map clientSettingsMap = this.parseMap((String)it.get((Expression)RegisteredClients.INSTANCE.getClientSettings()));
        TokenSettings tokenSettings = !tokenSettingsMap.isEmpty() ? TokenSettings.withSettings((Map)tokenSettingsMap).build() : null;
        ClientSettings clientSettings = !clientSettingsMap.isEmpty() ? ClientSettings.withSettings((Map)clientSettingsMap).build() : null;
        RegisteredClient registeredClient = RegisteredClient.withId((String)((EntityID)it.get((Expression)RegisteredClients.INSTANCE.getId())).toString()).clientSecret((String)it.get((Expression)RegisteredClients.INSTANCE.getClientSecret())).clientId((String)it.get((Expression)RegisteredClients.INSTANCE.getClientId())).clientName((String)it.get((Expression)RegisteredClients.INSTANCE.getClientName())).clientAuthenticationMethods(arg_0 -> ExposedRegisteredClientRepository.toRegisteredClient$lambda$3(it, arg_0)).authorizationGrantTypes(arg_0 -> ExposedRegisteredClientRepository.toRegisteredClient$lambda$5(it, arg_0)).scopes(arg_0 -> ExposedRegisteredClientRepository.toRegisteredClient$lambda$6(it, arg_0)).redirectUris(arg_0 -> ExposedRegisteredClientRepository.toRegisteredClient$lambda$7(it, arg_0)).postLogoutRedirectUris(arg_0 -> ExposedRegisteredClientRepository.toRegisteredClient$lambda$8(it, arg_0)).clientSettings(clientSettings).tokenSettings(tokenSettings).build();
        Intrinsics.checkNotNullExpressionValue((Object)registeredClient, (String)"build(...)");
        return registeredClient;
    }

    private Map<String, Object> parseMap(String data) {
        try {
            Map map;
            if (data == null) {
                map = MapsKt.emptyMap();
            } else {
                Object object = this.getObjectMapper().readValue(data, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                map = (Map)object;
            }
            return map;
        }
        catch (JacksonException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void toRegisteredClient$lambda$3(ResultRow $it, Set methods) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Set set = StringUtils.commaDelimitedListToSet((String)((String)$it.get((Expression)RegisteredClients.INSTANCE.getAuthenticationMethods())));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
        Iterable iterable = set;
        Set set2 = methods;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ClientAuthenticationMethod((String)it));
        }
        set2.addAll((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final void toRegisteredClient$lambda$5(ResultRow $it, Set grantTypes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Set set = StringUtils.commaDelimitedListToSet((String)((String)$it.get((Expression)RegisteredClients.INSTANCE.getAuthorizationGrantTypes())));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
        Iterable iterable = set;
        Set set2 = grantTypes;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AuthorizationGrantType((String)it));
        }
        set2.addAll((List)destination$iv$iv);
    }

    private static final void toRegisteredClient$lambda$6(ResultRow $it, Set scopes) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Set set = StringUtils.commaDelimitedListToSet((String)((String)$it.get((Expression)RegisteredClients.INSTANCE.getScopes())));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
        scopes.addAll(set);
    }

    private static final void toRegisteredClient$lambda$7(ResultRow $it, Set uris) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Set set = StringUtils.commaDelimitedListToSet((String)((String)$it.get((Expression)RegisteredClients.INSTANCE.getRedirectUris())));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
        uris.addAll(set);
    }

    private static final void toRegisteredClient$lambda$8(ResultRow $it, Set uris) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Set set = StringUtils.commaDelimitedListToSet((String)((String)$it.get((Expression)RegisteredClients.INSTANCE.getPostLogoutRedirectUris())));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
        uris.addAll(set);
    }
}

