/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.JustUserDetailService$loadUserByUsername$;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lde/justsoftware/authorization/oauth2/JustUserDetailService;", "Lorg/springframework/security/core/userdetails/UserDetailsService;", "toroInternalUrl", "", "(Ljava/lang/String;)V", "getToroInternalUrl", "()Ljava/lang/String;", "loadUserByUsername", "Lorg/springframework/security/core/userdetails/UserDetails;", "username", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nJustUserDetailService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JustUserDetailService.kt\nde/justsoftware/authorization/oauth2/JustUserDetailService\n+ 2 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n*L\n1#1,31:1\n43#2:32\n*S KotlinDebug\n*F\n+ 1 JustUserDetailService.kt\nde/justsoftware/authorization/oauth2/JustUserDetailService\n*L\n24#1:32\n*E\n"})
public class JustUserDetailService
implements UserDetailsService {
    @NotNull
    private final String toroInternalUrl;

    public JustUserDetailService(@Value(value="${just.toro.internal}") @NotNull String toroInternalUrl) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        this.toroInternalUrl = toroInternalUrl;
    }

    @NotNull
    public String getToroInternalUrl() {
        return this.toroInternalUrl;
    }

    @NotNull
    public UserDetails loadUserByUsername(@NotNull String username) throws UsernameNotFoundException {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        RestClient restClient = RestClient.create();
        Object[] objectArray = new Object[]{username};
        RestClient.RequestHeadersSpec requestHeadersSpec = restClient.get().uri(this.getToroInternalUrl() + "/auth/user/{username}", objectArray);
        objectArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.ResponseSpec responseSpec = requestHeadersSpec.accept((MediaType[])objectArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$body$iv = responseSpec;
        boolean $i$f$body = false;
        JustUser result = (JustUser)$this$body$iv.body((ParameterizedTypeReference)new loadUserByUsername$$inlined$body$1());
        if (result == null) {
            throw new UsernameNotFoundException("No Just Social user found with username " + username);
        }
        return (UserDetails)result;
    }
}

