/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.LoginDto;
import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;

@ParametersAreNonnullByDefault
@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;", "Lorg/springframework/security/authentication/AuthenticationProvider;", "toroInternalUrl", "", "(Ljava/lang/String;)V", "getToroInternalUrl", "()Ljava/lang/String;", "authenticate", "Lorg/springframework/security/core/Authentication;", "authentication", "supports", "", "Ljava/lang/Class;", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nJustAuthenticationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JustAuthenticationProvider.kt\nde/justsoftware/authorization/oauth2/JustAuthenticationProvider\n+ 2 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n*L\n1#1,46:1\n43#2:47\n*S KotlinDebug\n*F\n+ 1 JustAuthenticationProvider.kt\nde/justsoftware/authorization/oauth2/JustAuthenticationProvider\n*L\n32#1:47\n*E\n"})
public class JustAuthenticationProvider
implements AuthenticationProvider {
    @NotNull
    private final String toroInternalUrl;

    public JustAuthenticationProvider(@Value(value="${just.toro.internal}") @NotNull String toroInternalUrl) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        this.toroInternalUrl = toroInternalUrl;
    }

    @NotNull
    public String getToroInternalUrl() {
        return this.toroInternalUrl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Authentication authenticate(@NotNull Authentication authentication) throws AuthenticationException {
        void $this$body$iv;
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        String username = authentication.getName();
        String password = authentication.getCredentials().toString();
        RestClient restClient = RestClient.create();
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.RequestBodySpec requestBodySpec = (RestClient.RequestBodySpec)((RestClient.RequestBodySpec)restClient.post().uri(this.getToroInternalUrl() + "/auth/login/", new Object[0])).accept(mediaTypeArray);
        Intrinsics.checkNotNull((Object)username);
        RestClient.ResponseSpec responseSpec = requestBodySpec.body((Object)new LoginDto(username, password)).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        boolean $i$f$body = false;
        JustUser result = (JustUser)$this$body$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (result == null) {
            throw new IllegalStateException("no result".toString());
        }
        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = UsernamePasswordAuthenticationToken.authenticated((Object)result.getUsername(), (Object)result.getPassword(), (Collection)result.getAuthorities());
        Intrinsics.checkNotNullExpressionValue((Object)usernamePasswordAuthenticationToken, (String)"authenticated(...)");
        return (Authentication)usernamePasswordAuthenticationToken;
    }

    public boolean supports(@Nullable Class<?> authentication) {
        Class<?> clazz = authentication;
        return clazz != null ? Intrinsics.areEqual(clazz, UsernamePasswordAuthenticationToken.class) : false;
    }
}

