/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.drive;

import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.connector.drive.exceptions.DriveApiException;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\rH\u0016J*\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "", "driveInternalUrl", "", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "(Ljava/lang/String;Lorg/springframework/web/client/RestTemplate;)V", "addFile", "Lde/justsoftware/admin/id/DocumentId;", "documentId", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "userId", "Lde/justsoftware/admin/id/ProfileId;", "deleteFile", "", "user", "replaceFile", "oldFile", "newFile", "profileId", "Companion", "admin-service"})
public class DriveApiConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String driveInternalUrl;
    @NotNull
    private final RestTemplate restTemplate;
    @NotNull
    private static final Logger log;

    public DriveApiConnector(@Value(value="${just.drive.internal}") @NotNull String driveInternalUrl, @NotNull RestTemplate restTemplate) {
        Intrinsics.checkNotNullParameter((Object)driveInternalUrl, (String)"driveInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        this.driveInternalUrl = driveInternalUrl;
        this.restTemplate = restTemplate;
    }

    public void replaceFile(@Nullable DocumentId oldFile, @NotNull DocumentId newFile, @NotNull TenantId tenantId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.deleteFile(oldFile, profileId);
        this.addFile(newFile, tenantId, profileId);
    }

    public void deleteFile(@Nullable DocumentId documentId, @NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (documentId == null) {
            return;
        }
        try {
            this.restTemplate.delete(this.driveInternalUrl + "/file/" + documentId.getValue() + "/delete?deletingUser=" + user.getValue(), new Object[0]);
        }
        catch (HttpClientErrorException ex) {
            log.warn("deleteFile failed: '" + ex.getResponseBodyAsString() + "'!");
        }
    }

    @NotNull
    public DocumentId addFile(@NotNull DocumentId documentId, @NotNull TenantId tenantId, @NotNull ProfileId userId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"targetItemId", (Object)tenantId.toTypedString()), TuplesKt.to((Object)"tempFileIds", (Object)SetsKt.setOf((Object)documentId.getValue())), TuplesKt.to((Object)"ownerId", (Object)userId.getValue())};
        ResponseEntity it = this.restTemplate.postForEntity(this.driveInternalUrl + "/tmp/move", (Object)MapsKt.mapOf((Pair[])pairArray), Map.class, new Object[0]);
        boolean bl = false;
        if (it.getStatusCode() != HttpStatus.OK) {
            HttpStatusCode httpStatusCode = it.getStatusCode();
            Intrinsics.checkNotNullExpressionValue((Object)httpStatusCode, (String)"getStatusCode(...)");
            throw new DriveApiException(documentId, httpStatusCode);
        }
        Object object = (Map)it.getBody();
        Object firstResult = object != null && (object = object.values()) != null && (object = object.iterator()) != null ? object.next() : null;
        Intrinsics.checkNotNull(firstResult, (String)"null cannot be cast to non-null type java.util.LinkedHashMap<*, *>{ kotlin.collections.TypeAliasesKt.LinkedHashMap<*, *> }");
        String responseId = String.valueOf(((Map)firstResult).get("id"));
        return DocumentId.Companion.fromStringValue(responseId);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DriveApiConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

