/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Map;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.producer.BaseProducer;
import kafka.producer.KeyedMessage;
import kafka.producer.NewShinyProducer;
import kafka.producer.OldProducer;
import kafka.tools.ConsoleProducer;
import org.apache.kafka.common.utils.Utils;

public final class ConsoleProducer$ {
    public static final ConsoleProducer$ MODULE$;

    static {
        new ConsoleProducer$();
    }

    public void main(String[] args) {
        try {
            ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(args);
            ConsoleProducer.MessageReader reader = (ConsoleProducer.MessageReader)Class.forName(config.readerClass()).newInstance();
            reader.init(System.in, this.getReaderProps(config));
            BaseProducer producer = config.useOldProducer() ? new OldProducer(this.getOldProducerProps(config)) : new NewShinyProducer(this.getNewProducerProps(config));
            Runtime.getRuntime().addShutdownHook(new Thread(producer){
                private final BaseProducer producer$1;

                public void run() {
                    this.producer$1.close();
                }
                {
                    this.producer$1 = producer$1;
                }
            });
            KeyedMessage<byte[], byte[]> message = null;
            while (true) {
                if ((message = reader.readMessage()) != null) {
                    producer.send(message.topic(), message.key(), message.message());
                }
                if (message != null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        catch (OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    /*
     * WARNING - void declaration
     */
    public Properties getReaderProps(ConsoleProducer.ProducerConfig config) {
        void var2_2;
        Properties props = new Properties();
        props.put("topic", config.topic());
        props.putAll((Map<?, ?>)config.cmdLineProps());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getOldProducerProps(ConsoleProducer.ProducerConfig config) {
        void var2_2;
        Properties props = this.producerProps(config);
        props.put("metadata.broker.list", config.brokerList());
        props.put("compression.codec", config.compressionCodec());
        props.put("producer.type", config.sync() ? "sync" : "async");
        props.put("batch.num.messages", config.batchSize().toString());
        props.put("message.send.max.retries", config.messageSendMaxRetries().toString());
        props.put("retry.backoff.ms", config.retryBackoffMs().toString());
        props.put("queue.buffering.max.ms", config.sendTimeout().toString());
        props.put("queue.buffering.max.messages", config.queueSize().toString());
        props.put("queue.enqueue.timeout.ms", config.queueEnqueueTimeoutMs().toString());
        props.put("request.required.acks", config.requestRequiredAcks().toString());
        props.put("request.timeout.ms", config.requestTimeoutMs().toString());
        props.put("key.serializer.class", config.keyEncoderClass());
        props.put("serializer.class", config.valueEncoderClass());
        props.put("send.buffer.bytes", config.socketBuffer().toString());
        props.put("topic.metadata.refresh.interval.ms", config.metadataExpiryMs().toString());
        props.put("client.id", "console-producer");
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerProps(ConsoleProducer.ProducerConfig config) {
        void var2_2;
        Properties props = config.options().has(config.producerConfigOpt()) ? Utils.loadProps(config.options().valueOf(config.producerConfigOpt())) : new Properties();
        props.putAll((Map<?, ?>)config.extraProducerProps());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getNewProducerProps(ConsoleProducer.ProducerConfig config) {
        void var2_2;
        Properties props = this.producerProps(config);
        props.put("bootstrap.servers", config.brokerList());
        props.put("compression.type", config.compressionCodec());
        props.put("send.buffer.bytes", config.socketBuffer().toString());
        props.put("retry.backoff.ms", config.retryBackoffMs().toString());
        props.put("metadata.max.age.ms", config.metadataExpiryMs().toString());
        props.put("max.block.ms", config.maxBlockMs().toString());
        props.put("acks", config.requestRequiredAcks().toString());
        props.put("request.timeout.ms", config.requestTimeoutMs().toString());
        props.put("retries", config.messageSendMaxRetries().toString());
        props.put("linger.ms", config.sendTimeout().toString());
        props.put("buffer.memory", config.maxMemoryBytes().toString());
        props.put("batch.size", config.maxPartitionMemoryBytes().toString());
        props.put("client.id", "console-producer");
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        return var2_2;
    }

    private ConsoleProducer$() {
        MODULE$ = this;
    }
}

