/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.controller;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.authentication.service.JustUsernameNotFoundException;
import de.justsoftware.onx.security.model.JustConnectUser;
import java.security.Principal;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.security.auth.login.AccountExpiredException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.view.RedirectView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@ParametersAreNonnullByDefault
public class JustErrorController
implements ErrorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(JustErrorController.class);
    private static final String PATH = "/error";
    private static final ImmutableMap<String, String> ERROR_TYPE_MAP = ImmutableMap.builder().put((Object)UsernameNotFoundException.class.getName(), (Object)"unfe").put((Object)JustUsernameNotFoundException.class.getName(), (Object)"unfe").put((Object)AccountExpiredException.class.getName(), (Object)"aee").put((Object)CredentialsExpiredException.class.getName(), (Object)"cee").put((Object)DisabledException.class.getName(), (Object)"de").put((Object)LockedException.class.getName(), (Object)"le").build();

    public String getErrorPath() {
        return "/error";
    }

    @CheckForNull
    public static String getPrincipalName(@Nullable SecurityContext securityContext) {
        Authentication auth;
        Authentication authentication = auth = securityContext == null ? null : securityContext.getAuthentication();
        if (auth == null) {
            return null;
        }
        Object principal = auth.getPrincipal();
        if (principal instanceof JustConnectUser) {
            return ((JustConnectUser)principal).getUsername();
        }
        Object details = auth.getDetails();
        if (details instanceof JustConnectUser) {
            return ((JustConnectUser)details).getUsername();
        }
        if (principal instanceof Principal) {
            return ((Principal)principal).getName();
        }
        return null;
    }

    @RequestMapping(value={"/error"})
    public RedirectView error(HttpServletRequest request) {
        Object errorAttribute = request.getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        RedirectView redirectView = new RedirectView("/toro/external/login/error");
        Map attributesMap = redirectView.getAttributesMap();
        if (Throwable.class.isInstance(errorAttribute)) {
            Throwable error = (Throwable)Throwable.class.cast(errorAttribute);
            attributesMap.put("type", ERROR_TYPE_MAP.getOrDefault((Object)error.getClass().getName(), (Object)"t"));
            attributesMap.put("details", error.getMessage());
            if (JustUsernameNotFoundException.class.isInstance(errorAttribute)) {
                attributesMap.put("objectGUID", ((JustUsernameNotFoundException)errorAttribute).getObjectGUID());
            }
            LOGGER.error("Error: ", error);
        } else {
            LOGGER.error("Error: no authentication failure exception available. See previous errors in log. ", errorAttribute);
        }
        String principalName = JustErrorController.getPrincipalName((SecurityContext)SecurityContextHolder.getContext());
        if (principalName != null) {
            attributesMap.put("principal", principalName);
        }
        return redirectView;
    }
}

