/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.application;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;

@Configuration
@ConfigurationProperties
@ParametersAreNonnullByDefault
public class TaskConfiguration {
    @Nonnull
    @Bean(value={"taskScheduler"})
    public TaskScheduler taskScheduler(ScheduledExecutorService scheduledExecutorService) {
        return new ConcurrentTaskScheduler(scheduledExecutorService);
    }

    @Nonnull
    @Bean(value={"scheduledExecutorService"})
    public ScheduledExecutorService scheduledExecutorService() {
        return new ScheduledThreadPoolExecutor(10, new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

