/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.externallink;

import de.justsoftware.people.business.externallink.ExternalLinkParser;
import de.justsoftware.people.business.externallink.ExternalLinkService;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.business.externallink.model.LinkConfigCreateModel;
import de.justsoftware.people.business.externallink.model.ValidExternalLink;
import de.justsoftware.people.business.externallink.model.ValidLinkInsertModel;
import de.justsoftware.people.model.ExternalLinkId;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.persistence.ExternalLinkRepository;
import de.justsoftware.people.persistence.model.DbExternalLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\t\u001a\u00020\nH\u0016J6\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001c0\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/people/business/externallink/ExternalLinkService;", "", "linkRepository", "Lde/justsoftware/people/persistence/ExternalLinkRepository;", "linkParser", "Lde/justsoftware/people/business/externallink/ExternalLinkParser;", "(Lde/justsoftware/people/persistence/ExternalLinkRepository;Lde/justsoftware/people/business/externallink/ExternalLinkParser;)V", "createExternalLink", "Lde/justsoftware/people/model/ExternalLinkId;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "createModel", "Lde/justsoftware/people/business/externallink/model/LinkConfigCreateModel;", "creator", "Lde/justsoftware/people/model/ProfileId;", "deleteExternalLinks", "", "linkIds", "", "getConfiguredLinks", "", "Lde/justsoftware/people/business/externallink/model/ExternalLinkConfig;", "getLinkFromConfigAndData", "Lde/justsoftware/people/business/externallink/model/ValidExternalLink;", "linkConfigs", "dataFields", "", "", "", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nExternalLinkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalLinkService.kt\nde/justsoftware/people/business/externallink/ExternalLinkService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1549#2:87\n1620#2,3:88\n1603#2,9:91\n1855#2:100\n1856#2:102\n1612#2:103\n1549#2:104\n1620#2,3:105\n1855#2,2:108\n1#3:101\n*S KotlinDebug\n*F\n+ 1 ExternalLinkService.kt\nde/justsoftware/people/business/externallink/ExternalLinkService\n*L\n52#1:87\n52#1:88,3\n66#1:91,9\n66#1:100\n66#1:102\n66#1:103\n75#1:104\n75#1:105,3\n77#1:108,2\n66#1:101\n*E\n"})
public class ExternalLinkService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExternalLinkRepository linkRepository;
    @NotNull
    private final ExternalLinkParser linkParser;

    public ExternalLinkService(@NotNull ExternalLinkRepository linkRepository, @NotNull ExternalLinkParser linkParser) {
        Intrinsics.checkNotNullParameter((Object)linkRepository, (String)"linkRepository");
        Intrinsics.checkNotNullParameter((Object)linkParser, (String)"linkParser");
        this.linkRepository = linkRepository;
        this.linkParser = linkParser;
    }

    @NotNull
    public ExternalLinkId createExternalLink(@NotNull TenantId tenantId, @NotNull LinkConfigCreateModel createModel, @NotNull ProfileId creator) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)createModel, (String)"createModel");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        ValidLinkInsertModel insertModel = this.linkParser.parseAndValidateCreateModel(createModel);
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        return new ExternalLinkId(((DbExternalLink)this.linkRepository.save((Object)new DbExternalLink(uUID, insertModel.getUri(), (UUID)tenantId.getId(), ((Number)creator.getId()).longValue(), insertModel.getDescription()))).getId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ExternalLinkConfig> getConfiguredLinks(@NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$map$iv = this.linkRepository.findByTenantId((UUID)tenantId.getId());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbExternalLink dbExternalLink = (DbExternalLink)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbExternalLink.Companion.toExternalLinkConfig((DbExternalLink)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ValidExternalLink> getLinkFromConfigAndData(@NotNull List<ExternalLinkConfig> linkConfigs, @NotNull Map<String, ? extends Collection<String>> dataFields) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(linkConfigs, (String)"linkConfigs");
        Intrinsics.checkNotNullParameter(dataFields, (String)"dataFields");
        Map singleValueFields = Companion.access$getSingleValueFields((Companion)Companion, dataFields);
        Iterable iterable = linkConfigs;
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValidExternalLink it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ExternalLinkConfig config = (ExternalLinkConfig)element$iv$iv;
            boolean bl2 = false;
            if (this.linkParser.linkFromConfig(config, singleValueFields) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteExternalLinks(@NotNull TenantId tenantId, @NotNull Set<ExternalLinkId> linkIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(linkIds, (String)"linkIds");
        Iterable $this$map$iv = linkIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ExternalLinkId externalLinkId = (ExternalLinkId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((UUID)p0.getId());
        }
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.linkRepository.deleteByTenantIdAndIdIn((UUID)tenantId.getId(), it);
        }
    }
}

