/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.model.ArticleDto;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.search.update.UpdateSearchIndexProducer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001BS\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0001\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0012J\u0016\u0010*\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020)0(H\u0012J\u001e\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0012J\u001e\u00102\u001a\u00020)2\u0006\u00103\u001a\u0002042\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0012J\u001e\u00105\u001a\u00020)2\u0006\u00106\u001a\u0002072\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0012J\u0016\u00108\u001a\u00020&2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00160(H\u0012J\u0016\u0010:\u001a\u00020&2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00160(H\u0012J\u0016\u0010;\u001a\u00020&2\f\u00109\u001a\b\u0012\u0004\u0012\u00020<0(H\u0016J\b\u0010=\u001a\u00020&H\u0016J\b\u0010>\u001a\u00020&H\u0016J\b\u0010?\u001a\u00020&H\u0016J\b\u0010@\u001a\u00020&H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u00020\u00198\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u00020\u00198\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\"\u0010\u001b\u001a\u0004\b#\u0010\u001dR\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0016X\u0092D\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lde/justsoftware/wikiservice/search/SolrService;", "", "solrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "updateSearchIndexProducer", "Lde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "useSoftCommit", "", "commitWithinInMs", "", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/permission/client/rest/PermissionRequestConnector;Lde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer;Lio/micrometer/core/instrument/MeterRegistry;ZI)V", "articleType", "", "chapterType", "failedIndexedDocumentCount", "Ljava/util/concurrent/atomic/AtomicLong;", "getFailedIndexedDocumentCount$wiki_service$annotations", "()V", "getFailedIndexedDocumentCount$wiki_service", "()Ljava/util/concurrent/atomic/AtomicLong;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "successfulIndexedDocumentCount", "getSuccessfulIndexedDocumentCount$wiki_service$annotations", "getSuccessfulIndexedDocumentCount$wiki_service", "wikiType", "addSolrDocuments", "", "inputDocuments", "", "Lorg/apache/solr/common/SolrInputDocument;", "addSolrDocumentsSingly", "solrDocuments", "createArticleSolrDocument", "article", "Lde/justsoftware/wikiservice/business/model/ArticleDto;", "visibleForRoles", "", "Lde/justsoftware/permission/client/model/Role;", "createChapterSolrDocument", "chapter", "Lde/justsoftware/wikiservice/business/model/ChapterDto;", "createWikiSolrDocument", "wiki", "Lde/justsoftware/wikiservice/business/model/WikiDto;", "deleteSolrDocuments", "ids", "deleteSolrDocumentsSingly", "index", "Lde/justsoftware/wikiservice/model/AbstractId;", "reindexAll", "reindexArticles", "reindexChapters", "reindexWikis", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nSolrService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrService.kt\nde/justsoftware/wikiservice/search/SolrService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1549#2:258\n1620#2,3:259\n1549#2:262\n1620#2,3:263\n1549#2:266\n1620#2,3:267\n1855#2,2:270\n1855#2,2:272\n800#2,11:274\n800#2,11:285\n800#2,11:296\n1549#2:307\n1620#2,3:308\n1549#2:311\n1620#2,3:312\n1549#2:315\n1620#2,3:316\n1549#2:319\n1620#2,3:320\n1549#2:323\n1620#2,3:324\n1549#2:327\n1620#2,3:328\n1549#2:331\n1620#2,3:332\n*S KotlinDebug\n*F\n+ 1 SolrService.kt\nde/justsoftware/wikiservice/search/SolrService\n*L\n107#1:258\n107#1:259,3\n120#1:262\n120#1:263,3\n135#1:266\n135#1:267,3\n163#1:270,2\n204#1:272,2\n222#1:274,11\n223#1:285,11\n224#1:296,11\n234#1:307\n234#1:308,3\n234#1:311\n234#1:312,3\n237#1:315\n237#1:316,3\n240#1:319\n240#1:320,3\n243#1:323\n243#1:324,3\n245#1:327\n245#1:328,3\n247#1:331\n247#1:332,3\n*E\n"})
public class SolrService {
    @NotNull
    private final SolrClient solrClient;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private final UpdateSearchIndexProducer updateSearchIndexProducer;
    private final boolean useSoftCommit;
    private final int commitWithinInMs;
    private final Logger logger;
    @NotNull
    private final String wikiType;
    @NotNull
    private final String chapterType;
    @NotNull
    private final String articleType;
    @NotNull
    private final AtomicLong successfulIndexedDocumentCount;
    @NotNull
    private final AtomicLong failedIndexedDocumentCount;

    @Autowired
    public SolrService(@NotNull SolrClient solrClient, @NotNull WikiService wikiService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull PermissionRequestConnector permissionRequestConnector, @NotNull UpdateSearchIndexProducer updateSearchIndexProducer, @NotNull MeterRegistry meterRegistry, @Value(value="${just.search.useSoftCommit:true}") boolean useSoftCommit, @Value(value="${just.search.commitWithinInMs:1000}") int commitWithinInMs) {
        Intrinsics.checkNotNullParameter((Object)solrClient, (String)"solrClient");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        Intrinsics.checkNotNullParameter((Object)updateSearchIndexProducer, (String)"updateSearchIndexProducer");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.solrClient = solrClient;
        this.wikiService = wikiService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.permissionRequestConnector = permissionRequestConnector;
        this.updateSearchIndexProducer = updateSearchIndexProducer;
        this.useSoftCommit = useSoftCommit;
        this.commitWithinInMs = commitWithinInMs;
        this.logger = LoggerFactory.getLogger(SolrService.class);
        this.wikiType = "WIKI_WIKI";
        this.chapterType = "WIKI_CHAPTER";
        this.articleType = "WIKI_ARTICLE";
        this.successfulIndexedDocumentCount = new AtomicLong(0L);
        this.failedIndexedDocumentCount = new AtomicLong(0L);
        Gauge.builder((String)"wiki.search.index.successfulIndexedDocuments", () -> SolrService._init_$lambda$0(this)).description("Count of successfully indexed documents").baseUnit("Document").register(meterRegistry);
        Gauge.builder((String)"wiki.search.index.failedIndexedDocuments", () -> SolrService._init_$lambda$1(this)).description("Count of failed indexed documents").baseUnit("Document").register(meterRegistry);
    }

    @NotNull
    public AtomicLong getSuccessfulIndexedDocumentCount$wiki_service() {
        return this.successfulIndexedDocumentCount;
    }

    @VisibleForTesting
    public static /* synthetic */ void getSuccessfulIndexedDocumentCount$wiki_service$annotations() {
    }

    @NotNull
    public AtomicLong getFailedIndexedDocumentCount$wiki_service() {
        return this.failedIndexedDocumentCount;
    }

    @VisibleForTesting
    public static /* synthetic */ void getFailedIndexedDocumentCount$wiki_service$annotations() {
    }

    public void reindexAll() {
        this.solrClient.deleteByQuery("just_app_id:WIKI");
        this.reindexWikis();
        this.reindexChapters();
        this.reindexArticles();
    }

    public void reindexWikis() {
        this.solrClient.deleteByQuery("type:" + this.wikiType);
        this.updateSearchIndexProducer.reindex(this.wikiService.readAllIds());
    }

    public void reindexChapters() {
        this.solrClient.deleteByQuery("type:" + this.chapterType);
        this.updateSearchIndexProducer.reindex(this.chapterService.readAllIds());
    }

    public void reindexArticles() {
        this.solrClient.deleteByQuery("type:" + this.articleType);
        this.updateSearchIndexProducer.reindex(this.articleService.readAllIds());
    }

    /*
     * WARNING - void declaration
     */
    private SolrInputDocument createWikiSolrDocument(WikiDto wiki, Set<Role> visibleForRoles) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createWikiSolrDocument_u24lambda_u243 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$createWikiSolrDocument_u24lambda_u243.setField("id", (Object)wiki.getId().toString());
        $this$createWikiSolrDocument_u24lambda_u243.setField("name", (Object)wiki.getTitle());
        $this$createWikiSolrDocument_u24lambda_u243.setField("name_sort", (Object)wiki.getTitle());
        $this$createWikiSolrDocument_u24lambda_u243.setField("description", (Object)wiki.getDescription());
        $this$createWikiSolrDocument_u24lambda_u243.setField("type", (Object)this.wikiType);
        $this$createWikiSolrDocument_u24lambda_u243.setField("modify_date", (Object)new Date(wiki.getUpdatedAt().toInstant().toEpochMilli()));
        $this$createWikiSolrDocument_u24lambda_u243.setField("publication_date", (Object)new Date(wiki.getCreatedAt().toInstant().toEpochMilli()));
        $this$createWikiSolrDocument_u24lambda_u243.setField("just_app_id", (Object)"WIKI");
        Iterable iterable = visibleForRoles;
        String string = "visible_for_roles";
        SolrInputDocument solrInputDocument2 = $this$createWikiSolrDocument_u24lambda_u243;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        solrInputDocument2.setField(string, (Object)collection);
        return solrInputDocument;
    }

    /*
     * WARNING - void declaration
     */
    private SolrInputDocument createChapterSolrDocument(ChapterDto chapter, Set<Role> visibleForRoles) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createChapterSolrDocument_u24lambda_u245 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$createChapterSolrDocument_u24lambda_u245.setField("id", (Object)chapter.getId().toString());
        $this$createChapterSolrDocument_u24lambda_u245.setField("name", (Object)chapter.getTitle());
        $this$createChapterSolrDocument_u24lambda_u245.setField("name_sort", (Object)chapter.getTitle());
        $this$createChapterSolrDocument_u24lambda_u245.setField("type", (Object)this.chapterType);
        $this$createChapterSolrDocument_u24lambda_u245.setField("modify_date", (Object)new Date(chapter.getUpdatedAt().toInstant().toEpochMilli()));
        $this$createChapterSolrDocument_u24lambda_u245.setField("publication_date", (Object)new Date(chapter.getCreatedAt().toInstant().toEpochMilli()));
        $this$createChapterSolrDocument_u24lambda_u245.setField("just_app_id", (Object)"WIKI");
        Iterable iterable = visibleForRoles;
        String string = "visible_for_roles";
        SolrInputDocument solrInputDocument2 = $this$createChapterSolrDocument_u24lambda_u245;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        solrInputDocument2.setField(string, (Object)collection);
        $this$createChapterSolrDocument_u24lambda_u245.setField("parent_ids", (Object)CollectionsKt.listOf((Object)chapter.getWikiId().toString()));
        return solrInputDocument;
    }

    /*
     * WARNING - void declaration
     */
    private SolrInputDocument createArticleSolrDocument(ArticleDto article, Set<Role> visibleForRoles) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createArticleSolrDocument_u24lambda_u247 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$createArticleSolrDocument_u24lambda_u247.setField("id", (Object)article.getId().toString());
        $this$createArticleSolrDocument_u24lambda_u247.setField("name", (Object)article.getTitle());
        $this$createArticleSolrDocument_u24lambda_u247.setField("name_sort", (Object)article.getTitle());
        $this$createArticleSolrDocument_u24lambda_u247.setField("content", (Object)article.getTextContent());
        $this$createArticleSolrDocument_u24lambda_u247.setField("type", (Object)this.articleType);
        $this$createArticleSolrDocument_u24lambda_u247.setField("modify_date", (Object)new Date(article.getUpdatedAt().toInstant().toEpochMilli()));
        $this$createArticleSolrDocument_u24lambda_u247.setField("publication_date", (Object)new Date(article.getCreatedAt().toInstant().toEpochMilli()));
        $this$createArticleSolrDocument_u24lambda_u247.setField("just_app_id", (Object)"WIKI");
        Iterable iterable = visibleForRoles;
        String string = "visible_for_roles";
        SolrInputDocument solrInputDocument2 = $this$createArticleSolrDocument_u24lambda_u247;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        solrInputDocument2.setField(string, (Object)collection);
        $this$createArticleSolrDocument_u24lambda_u247.setField("parent_ids", (Object)CollectionsKt.listOf((Object)article.getWikiId().toString()));
        return solrInputDocument;
    }

    private void addSolrDocuments(List<? extends SolrInputDocument> inputDocuments) {
        if (inputDocuments.isEmpty()) {
            return;
        }
        try {
            if (this.useSoftCommit) {
                this.solrClient.add((Collection)inputDocuments, this.commitWithinInMs);
            } else {
                this.solrClient.add((Collection)inputDocuments);
            }
            this.getSuccessfulIndexedDocumentCount$wiki_service().addAndGet(inputDocuments.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            this.logger.warn("Batch adding of " + inputDocuments.size() + " documents failed. Try to add documents singly.", (Throwable)e);
            this.addSolrDocumentsSingly(inputDocuments);
        }
    }

    private void addSolrDocumentsSingly(List<? extends SolrInputDocument> solrDocuments) {
        Iterable $this$forEach$iv = solrDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrInputDocument it = (SolrInputDocument)element$iv;
            boolean bl = false;
            try {
                if (this.useSoftCommit) {
                    this.solrClient.add(it, this.commitWithinInMs);
                } else {
                    this.solrClient.add(it);
                }
                this.getSuccessfulIndexedDocumentCount$wiki_service().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                SolrInputField solrInputField = (SolrInputField)it.get((Object)"id");
                Object id = solrInputField != null ? solrInputField.getValue() : null;
                this.logger.error("Failed to index solr document for " + id, (Throwable)e);
                this.getFailedIndexedDocumentCount$wiki_service().incrementAndGet();
            }
        }
    }

    private void deleteSolrDocuments(List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            if (this.useSoftCommit) {
                this.solrClient.deleteById(ids, this.commitWithinInMs);
            } else {
                this.solrClient.deleteById(ids);
            }
            this.getSuccessfulIndexedDocumentCount$wiki_service().addAndGet(ids.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            this.logger.warn("Batch deletion of " + ids.size() + " documents failed. Try to delete documents singly.", (Throwable)e);
            this.deleteSolrDocumentsSingly(ids);
        }
    }

    private void deleteSolrDocumentsSingly(List<String> ids) {
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            try {
                if (this.useSoftCommit) {
                    this.solrClient.deleteById(it, this.commitWithinInMs);
                } else {
                    this.solrClient.deleteById(it);
                }
                this.getSuccessfulIndexedDocumentCount$wiki_service().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                this.logger.error("Failed to delete solr document " + it, (Throwable)e);
                this.getFailedIndexedDocumentCount$wiki_service().incrementAndGet();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void index(@NotNull List<? extends AbstractId> ids) {
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        Object it2;
        Collection<WikiId> collection;
        Iterable $this$mapTo$iv$iv3;
        Iterable $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        Object element$iv$iv3;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv3;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$filterIsInstance$iv = ids;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv3) {
            if (!(element$iv$iv2 instanceof WikiId)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filterIsInstance$iv2 = ids;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv3 instanceof ChapterId)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        Set chapterIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$filterIsInstance$iv3 = ids;
        boolean $i$f$filterIsInstance3 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv3;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo3 = false;
        for (Object element$iv$iv4 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv4 instanceof ArticleId)) continue;
            destination$iv$iv3.add(element$iv$iv4);
        }
        Set articleIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        if (wikiIds.isEmpty() && chapterIds.isEmpty() && articleIds.isEmpty()) {
            return;
        }
        Map articles = this.articleService.readByIds(articleIds);
        Map chapters = this.chapterService.readByIds(chapterIds);
        destination$iv$iv3 = articles.values();
        Collection<SolrInputDocument> collection2 = wikiIds;
        Object object = this.wikiService;
        boolean $i$f$map = false;
        element$iv$iv3 = $this$map$iv2;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            ArticleDto articleDto = (ArticleDto)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(it2.getWikiId());
        }
        collection = (List)destination$iv$iv4;
        $this$map$iv2 = chapters.values();
        collection2 = SetsKt.plus((Set)collection2, (Iterable)collection);
        $i$f$map = false;
        $this$mapTo$iv$iv3 = $this$map$iv2;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            it2 = (ChapterDto)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(it2.getWikiId());
        }
        collection = (List)destination$iv$iv4;
        Map wikis = object.readByIds(SetsKt.plus((Set)collection2, (Iterable)collection));
        $this$mapTo$iv$iv3 = wikis.values();
        object = this.permissionRequestConnector;
        boolean $i$f$map2 = false;
        void $i$f$mapTo2 = $this$map$iv;
        Iterable destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            WikiDto wikiDto = (WikiDto)item$iv$iv;
            collection2 = destination$iv$iv5;
            boolean bl = false;
            collection2.add((SolrInputDocument)it.getId().toString());
        }
        ImmutableSetMultimap immutableSetMultimap = object.visibility((Iterable)((List)destination$iv$iv5));
        Intrinsics.checkNotNullExpressionValue((Object)immutableSetMultimap, (String)"visibility(...)");
        ImmutableSetMultimap permissions = immutableSetMultimap;
        $this$map$iv = SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.minus((Set)wikiIds, (Iterable)wikis.keySet()), (Iterable)SetsKt.minus((Set)chapterIds, (Iterable)chapters.keySet())), (Iterable)SetsKt.minus((Set)articleIds, (Iterable)articles.keySet()));
        $i$f$map2 = false;
        $this$mapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        it2 = $this$mapTo$iv$iv2.iterator();
        while (it2.hasNext()) {
            Object item$iv$iv;
            it = item$iv$iv = it2.next();
            object = destination$iv$iv5;
            boolean bl = false;
            object.add(((AbstractId)it).toString());
        }
        List idsToDeleted = (List)destination$iv$iv5;
        this.deleteSolrDocuments(idsToDeleted);
        Iterable $this$map$iv3 = wikis.values();
        boolean $i$f$map3 = false;
        destination$iv$iv5 = $this$map$iv3;
        Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            WikiDto bl = (WikiDto)item$iv$iv;
            object = destination$iv$iv6;
            boolean bl2 = false;
            ImmutableSet immutableSet = permissions.get((Object)it3.getId().toString());
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"get(...)");
            object.add(this.createWikiSolrDocument((WikiDto)it3, (Set)immutableSet));
        }
        $this$map$iv3 = chapters.values();
        object = (List)destination$iv$iv6;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChapterDto it3 = (ChapterDto)item$iv$iv;
            collection2 = destination$iv$iv6;
            boolean bl = false;
            ImmutableSet immutableSet = permissions.get((Object)it3.getWikiId().toString());
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"get(...)");
            collection2.add(this.createChapterSolrDocument(it3, (Set)immutableSet));
        }
        $this$map$iv3 = articles.values();
        object = CollectionsKt.plus((Collection)object, (Iterable)((List)destination$iv$iv6));
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ArticleDto it4 = (ArticleDto)item$iv$iv;
            collection2 = destination$iv$iv6;
            boolean bl = false;
            ImmutableSet immutableSet = permissions.get((Object)it4.getWikiId().toString());
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"get(...)");
            collection2.add(this.createArticleSolrDocument(it4, (Set)immutableSet));
        }
        List documents = CollectionsKt.plus((Collection)object, (Iterable)((List)destination$iv$iv6));
        this.addSolrDocuments(documents);
        if (!this.useSoftCommit) {
            this.solrClient.commit();
        }
    }

    private static final Number _init_$lambda$0(SolrService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getSuccessfulIndexedDocumentCount$wiki_service().get();
    }

    private static final Number _init_$lambda$1(SolrService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getFailedIndexedDocumentCount$wiki_service().get();
    }
}

