<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-type" content="text/html; charset=utf-8" />

        <link rel="stylesheet" href="/toro/assets/juco.css" /> 

        <style TYPE="text/css">

            .hidden {
                display:none;
            }

            @media print 
            {
                .dontprint {
                    display:none;
                }
            }
        </style>

        <script type="text/javascript">

            function printIFramePdf(){
                var frames = window.frames["idPdfFrame"];
                frames.focus();

                try {
                    frames.print();
                } catch(e) {
                    console.log(e);
                    window.print();
                }
            }

            function doPrint() {
                if (document.getElementById('idPdfObjectEmbed')) {
                    try {
                        document.getElementById('idPdfObject').Print();
                    } catch(e) {
                        console.log(e);
                        printIFramePdf();
                    }
                } else {
                    // newer FF do replace our embed with PDF.JS content, so just print the invisible frame instead
                    printIFramePdf();
                }
            }

        </script>

    </head>

    <body class="documentPrintingBody" >
        <div class="documentPrintingContainer" >
            <div class="dontprint documentPrintingControls">
                <form>
                    <a class="btn" onClick="doPrint()">
                        <i class="icon-large icon-print">&nbsp;${print}&nbsp;</i>
                    </a>
                </form>
            </div>
            <iframe class="hidden documentPrintingFrame" id="idPdfFrame" name="idPdfFrame" src="${pdfUrl}" frameborder="0"></iframe>
            <object class="documentPrintingObject" id="idPdfObject" type="application/pdf" data="${pdfUrl}">
                <embed class="documentPrintingEmbed" id="idPdfObjectEmbed" src="${pdfUrl}" type="application/pdf"></embed>
                <span class="dontprint documentPrintingHelp">${help}</span>
            </object>
        </div>
    </body>
</html>
