/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.filters;

import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseHeaderFilter
implements Filter {
    public static final String URL_PATTERN = "ResponseHeaderFilter.UrlPattern";
    private String[] headers = new String[0];
    private String[] values = new String[0];
    private Log logger = LogFactory.getLog(this.getClass());
    private Pattern urlPattern = Pattern.compile(".*?");

    private void setupMatcher(String pattern) {
        this.urlPattern = Pattern.compile(pattern);
        this.logger.debug((Object)("Matching " + pattern));
    }

    private void addHeaders(HttpServletRequest request, HttpServletResponse response) {
        response.setBufferSize(0);
        String query = request.getRequestURI();
        Matcher urlMatcher = this.urlPattern.matcher(query);
        if (!urlMatcher.matches()) {
            return;
        }
        for (int i = 0; i < this.headers.length; ++i) {
            response.setHeader(this.headers[i], this.values[i]);
        }
    }

    private int getSize(Enumeration<?> e) {
        int size = 0;
        while (e.hasMoreElements()) {
            e.nextElement();
            ++size;
        }
        return size;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            this.addHeaders((HttpServletRequest)request, (HttpServletResponse)response);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig conf) throws ServletException {
        int size = this.getSize(conf.getInitParameterNames());
        if (conf.getInitParameter(URL_PATTERN) != null) {
            --size;
            this.setupMatcher(conf.getInitParameter(URL_PATTERN));
        }
        this.headers = new String[size];
        this.values = new String[size];
        if (size == 0) {
            this.logger.warn((Object)"Instantiated ResponseHeaderFilter without header mappings");
            return;
        }
        this.logger.debug((Object)"ResponseHeaderFilter header mappings:");
        Enumeration e = conf.getInitParameterNames();
        int i = 0;
        while (i < size) {
            String header = ((String)e.nextElement()).toString();
            if (URL_PATTERN.equals(header)) continue;
            this.headers[i] = header;
            this.values[i] = conf.getInitParameter(this.headers[i]);
            if ("".equals(this.values[i])) {
                this.values[i] = null;
            }
            this.logger.debug((Object)(this.headers[i] + " = " + this.values[i]));
            ++i;
        }
    }
}

