/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyDetailsHandler;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyQuestionsWidget;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyTeaserWidget;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.survey.shared.model.SurveyTeaser;

public class SurveyTeaserWidget
extends Composite {
    private static final SurveyConstants SURVEY = I18nMediator.SURVEY;
    private static final SurveyTeaserWidgetUIBinder UI_BINDER = (SurveyTeaserWidgetUIBinder)GWT.create(SurveyTeaserWidgetUIBinder.class);
    @UiField
    Hyperlink _title;
    @UiField
    Label _surveyType;
    @UiField
    FlowPanel _mainPanel;
    @UiField
    FlowPanel _optionsPanel;
    private SurveyTeaser _survey;

    public SurveyTeaserWidget(SurveyTeaser survey, ClientFactory clientFactory) {
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this.setSurvey(survey, clientFactory);
    }

    private void setSurvey(SurveyTeaser survey, ClientFactory clientFactory) {
        boolean hasParticipate;
        this._survey = survey;
        this._mainPanel.clear();
        this._optionsPanel.clear();
        String surveyDetailsToken = SurveyDetailsHandler.token((SurveyId)this._survey.getSurveyId(), (boolean)false);
        this._title.setText(this._survey.getTitle());
        if (this._survey.getSurveyData() != null) {
            this._surveyType.setVisible(true);
            this._surveyType.setText(SURVEY.surveyTypeLabel() + ": " + (this._survey.getSurveyData().isAnonym() ? SURVEY.anonymous() : SURVEY.named()));
        } else {
            this._surveyType.setVisible(false);
        }
        this._title.setTargetHistoryToken(surveyDetailsToken);
        this._optionsPanel.add((Widget)new Hyperlink(SURVEY.viewSurveyDetailsLabel(), surveyDetailsToken));
        boolean bl = hasParticipate = !CollectionUtil.isEmpty((Iterable)this._survey.getCurrentUserAnswers());
        if (hasParticipate) {
            this._mainPanel.add((Widget)new Label(SURVEY.youHaveParticipated()));
        } else {
            SurveyQuestionsWidget surveyQuestionsWidget = new SurveyQuestionsWidget(this._survey, clientFactory);
            surveyQuestionsWidget.setSurveyAnswersSaveSuccessHandler((SurveyQuestionsWidget.SurveyAnswersSaveSuccessHandler)new /* Unavailable Anonymous Inner Class!! */);
            this._mainPanel.add((Widget)surveyQuestionsWidget);
        }
    }
}

