/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.survey.presentation.client.ui.ConfigSurveyQuestionWidget;
import de.justsoftware.onx.survey.presentation.client.ui.CreateOrEditSurveyBaseDataWidget;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyTab;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SurveyCreateOrEditWidget
extends TabPanel {
    private static final SurveyConstants SURVEY = I18nMediator.SURVEY;
    private GlobalId _surveyParentId;
    private SurveyId _surveyId;
    private int _selectedTabIndex;
    private final boolean _redirectToSurveyOnNewMemberEnabled;
    private final ClientFactory _clientFactory;

    public SurveyCreateOrEditWidget(@Nullable SurveyId surveyId, @Nullable GlobalId surveyParentId, int selectedTabIndex, boolean redirectToSurveyOnNewMemberEnabled, PageTitleCallback titleCallback, ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._redirectToSurveyOnNewMemberEnabled = redirectToSurveyOnNewMemberEnabled;
        this.addStyleName("survey-create-or-edit-tabs");
        if (surveyId == null && surveyParentId == null) {
            throw new IllegalStateException("SurveyId or surveyParentId must not be empty");
        }
        this._selectedTabIndex = selectedTabIndex;
        this.addSelectionHandler(event -> {
            this._selectedTabIndex = (Integer)event.getSelectedItem();
            Widget tabWidget = this.getWidget(this._selectedTabIndex);
            if (tabWidget instanceof SurveyTab) {
                ((SurveyTab)tabWidget).onTabShow();
            }
        });
        if (surveyParentId == null) {
            this._surveyId = surveyId;
            this._clientFactory.surveyClientFactory().controller().getRemoteBySurveyId(this._surveyId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this._surveyParentId = surveyParentId;
            String pageTitle = SURVEY.createSurveyBreadCrumpLabel();
            titleCallback.setPageTitle(pageTitle);
            this.addTabForCreation();
            this.selectTab(this._selectedTabIndex);
        }
    }

    private void addTabForEdit(DBSurvey survey) {
        this.addTab((Widget)new CreateOrEditSurveyBaseDataWidget(survey, this._redirectToSurveyOnNewMemberEnabled, this._clientFactory), SURVEY.surveyBaseDataTab());
        this.addTab((Widget)new ConfigSurveyQuestionWidget(survey, this._clientFactory), SURVEY.surveyQuestionsTab());
    }

    private void addTabForCreation() {
        this.addTab((Widget)new CreateOrEditSurveyBaseDataWidget(this._surveyParentId, this._redirectToSurveyOnNewMemberEnabled, this._clientFactory), SURVEY.surveyBaseDataTab());
    }

    private void addTab(Widget content, String label) {
        Label tabLabel = new Label(label);
        tabLabel.addStyleName("app-hover-color");
        tabLabel.addStyleName("app-border-color");
        this.add(content, (Widget)tabLabel);
    }

    public int getSelectedTabIndex() {
        return this._selectedTabIndex;
    }

    public void setSelectedTabIndex(int selectedTabIndex) {
        this._selectedTabIndex = selectedTabIndex;
        this.selectTab(this._selectedTabIndex);
    }

    @CheckForNull
    public SurveyId getSurveyId() {
        return this._surveyId;
    }

    @CheckForNull
    public GlobalId getSurveyParentId() {
        return this._surveyParentId;
    }
}

