/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.upload;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.storage.SaveImageResult;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageType;
import com.freiheit.toro.server.upload.AbstractImageUploadServlet;
import com.freiheit.toro.server.upload.JsonUploadResult;
import com.freiheit.toro.server.upload.UploadResult;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.container.business.EntityImageService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalDesignImage;
import de.justsoftware.onx.design.business.ThemeService;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.server.upload.EntityImageUploadServlet;
import de.justsoftware.onx.server.upload.GlobalImageToThemeAttributeVisitor;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EntityImageUploadServlet
extends AbstractImageUploadServlet {
    private static final String ENTITY_ID_PARAMS = "entityId";
    private static final String TYPE_PARAMS = "type";
    private final EntityImageService _entityImageService;
    private final ThemeService _legacyThemeService;
    private final de.justsoftware.onx.tenantdesign.ThemeService _themeService;

    @Autowired
    @ParametersAreNonnullByDefault
    public EntityImageUploadServlet(Settings settings, StorageServerHelper storageServerHelper, SessionAuthorizationContextProvider authorizationContextProvider, EntityImageService entityImageService, I18nService i18nService, ThemeService legacyThemeService, @Qualifier(value="acceptableImageUploadTypes") Set<String> types, de.justsoftware.onx.tenantdesign.ThemeService themeService) {
        super(settings, storageServerHelper, authorizationContextProvider, i18nService, types);
        this._entityImageService = entityImageService;
        this._legacyThemeService = legacyThemeService;
        this._themeService = themeService;
    }

    @RequestMapping(value={"/upload/entity"})
    public ModelAndView handleRequest(MultipartHttpServletRequest request, HttpServletResponse response) throws IOException {
        return super.handleRequest(request, response);
    }

    private void saveEntityImage(@Nonnull MultipartFile file, @Nullable String type, @Nonnull EntityId entityId, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) throws ServiceException {
        String filePrefix = Long.toString(entityId.getId());
        if ("logo".equals(type)) {
            String filename = this.saveFile(file, type, filePrefix, (Collection)ImmutableSet.of((Object)ImageSize.LARGE, (Object)ImageSize.SMALL, (Object)ImageSize.X_SMALL, (Object)ImageSize.ORIGINAL));
            this._entityImageService.saveEntityImage(entityId, EntityImageService.EntityImageType.LOGO, filename, (AuthorizationCheckContext)authorizationContext);
        } else if ("icon".equals(type)) {
            String filename = this.saveFile(file, type, filePrefix, (Collection)ImmutableSet.of((Object)ImageSize.ICON_SMALL, (Object)ImageSize.ORIGINAL));
            this._entityImageService.saveEntityImage(entityId, EntityImageService.EntityImageType.ICON, filename, (AuthorizationCheckContext)authorizationContext);
        } else if ("slideshow".equals(type)) {
            String filename = this.saveFile(file, type, filePrefix, (Collection)ImmutableSet.of((Object)ImageSize.LARGE, (Object)ImageSize.ORIGINAL_UNSCALED));
            this._entityImageService.saveEntityImage(entityId, EntityImageService.EntityImageType.SLIDESHOW, filename, (AuthorizationCheckContext)authorizationContext);
        }
    }

    @Nonnull
    private String saveFile(@Nonnull MultipartFile file, @Nullable String type, @Nonnull String prefix, @Nonnull Collection<ImageSize> sizes) {
        String originalFilename = Objects.requireNonNullElse(file.getOriginalFilename(), file.getName());
        String filename = prefix + "-" + type + "-" + SecureRandomUtil.randomHex() + this._storageServerHelper.getExtension(originalFilename);
        SaveImageResult saveResult = this._storageServerHelper.saveFileOnStorageServer(file, ImageType.ENTITY_IMAGE.getPath(), filename, sizes);
        if (!saveResult.isOk()) {
            throw new ServiceException("EntityImageUploadServlet: " + saveResult.getMessage());
        }
        return filename;
    }

    @Nonnull
    private String saveFileByImageType(@Nonnull MultipartFile file, @Nonnull ImageType imageType, @Nonnull Collection<ImageSize> sizes, boolean squareOfImages) {
        String originalFilename = Objects.requireNonNullElse(file.getOriginalFilename(), file.getName());
        String filename = SecureRandomUtil.randomHex() + this._storageServerHelper.getExtension(originalFilename);
        SaveImageResult saveResult = this._storageServerHelper.saveFileOnStorageServer(file, imageType.getPath(), filename, sizes, squareOfImages);
        if (!saveResult.isOk()) {
            throw new ServiceException("EntityImageUploadServlet: " + saveResult.getMessage());
        }
        return filename;
    }

    private void saveEntityImages(List<MultipartFile> files, Map<String, String> parameters, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) throws ServiceException {
        EntityId entityId = new EntityId(Long.parseLong(parameters.get(ENTITY_ID_PARAMS)));
        String type = parameters.get(TYPE_PARAMS);
        for (MultipartFile f : files) {
            if (f == null) continue;
            this.saveEntityImage(f, type, entityId, authorizationContext);
        }
    }

    private void saveDefaultEntityDesignImages(@Nonnull List<MultipartFile> files, @Nonnull Map<String, String> parameters, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) throws ServiceException {
        String type = parameters.get(TYPE_PARAMS);
        GlobalDesignImage image = (GlobalDesignImage)GlobalDesignImage.VALUE_OF_MAP.get((Object)type);
        if (image == null) {
            throw new ServiceException("EntityImageUploadServlet: image type '" + type + "' unknown");
        }
        for (MultipartFile f : files) {
            if (f == null) continue;
            String filename = (String)image.visit((GlobalDesignImage.GlobalDesignImagesVisitor)new SaveGlobalDesignImageVisitor(this, f, "default"));
            Theme defaultTheme = this._themeService.getLegacyTheme(null);
            ThemeAttributeType attributeType = (ThemeAttributeType)((Optional)image.visit((GlobalDesignImage.GlobalDesignImagesVisitor)new GlobalImageToThemeAttributeVisitor())).orNull();
            if (attributeType == null) continue;
            ThemeAttribute imageAttribute = new ThemeAttribute(defaultTheme.getId(), filename, attributeType);
            this._legacyThemeService.setDefaultThemeAttribute(imageAttribute, (AuthorizationCheckContext)authorizationContext);
        }
    }

    protected UploadResult saves(List<MultipartFile> files, AuthorizationCheckContextWithUserId authorizationContext, HashMap<String, String> parameters) {
        try {
            if (parameters.get(ENTITY_ID_PARAMS) != null) {
                this.saveEntityImages(files, parameters, authorizationContext);
            } else {
                this.saveDefaultEntityDesignImages(files, parameters, authorizationContext);
            }
        }
        catch (ServiceException e) {
            return JsonUploadResult.error((String)e.getMessage());
        }
        return JsonUploadResult.success();
    }

    protected UploadResult returnError(HttpServletRequest request, String message) {
        return JsonUploadResult.error((String)message);
    }
}

