/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.presentation.client.ui.JCNavWidget;
import de.justsoftware.onx.searchnew.presentation.client.SingleSelectionFilterLink;
import de.justsoftware.onx.searchnew.presentation.client.ui.SingleSelectionFilterDropDown;
import de.justsoftware.onx.searchnew.presentation.client.ui.SingleSelectionFilterView;
import java.util.Map;
import javax.annotation.Nonnull;

public class SingleSelectionFilterViewImpl<S>
implements SingleSelectionFilterView<S> {
    private final SingleSelectionFilterDropDown _filterDropdown = new SingleSelectionFilterDropDown();
    private final Map<S, JCNavWidget> _countLinks = Maps.newHashMap();
    private final SingleSelectionFilterView.Presenter<S> _presenter;

    public SingleSelectionFilterViewImpl(@Nonnull SingleSelectionFilterView.Presenter<S> presenter) {
        this._presenter = presenter;
    }

    public void setFilterHeader(String filterHeader) {
        this._filterDropdown.setText(filterHeader);
    }

    private void addFilterLink(@Nonnull SingleSelectionFilterLink<S> facetLink) {
        JCNavWidget navWidget = new JCNavWidget();
        navWidget.setTextAndTitle(facetLink.getLabel());
        navWidget.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._filterDropdown.add((Widget)navWidget);
        navWidget.setActive(facetLink.isSelected());
        navWidget.setCount(0L);
        navWidget.setLowerBound(-1L);
        this._countLinks.put(facetLink.getSelection(), navWidget);
    }

    public void setSelectedFilter(SingleSelectionFilterLink<S> selectionLink, boolean removable) {
        if (removable) {
            FlowPanel selectedFilterPanel = new FlowPanel();
            selectedFilterPanel.add((Widget)new InlineLabel(selectionLink.getLabel()));
            JCIconOnlyAnchor removeIcon = new JCIconOnlyAnchor(IconType.REMOVE, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            removeIcon.addStyleName("remove-filter-icon");
            selectedFilterPanel.add((Widget)removeIcon);
            this._filterDropdown.setSelectedFilter((IsWidget)selectedFilterPanel);
        } else {
            this._filterDropdown.setSelectedFilter((IsWidget)new Label(selectionLink.getLabel()));
        }
    }

    public void setSelectionCounts(S searchFacet, long count) {
        JCNavWidget navWidget = (JCNavWidget)this._countLinks.get(searchFacet);
        if (navWidget != null) {
            navWidget.setCount(count);
        }
    }

    public void setFilterLinks(ImmutableList<SingleSelectionFilterLink<S>> filterLinks) {
        this._filterDropdown.clear();
        this._countLinks.clear();
        for (SingleSelectionFilterLink facetlink : filterLinks) {
            this.addFilterLink(facetlink);
        }
    }

    public Widget asWidget() {
        return this._filterDropdown.asWidget();
    }

    public void setVisible(boolean isVisible) {
        this._filterDropdown.setVisible(isVisible);
    }

    public void showByToggler(boolean show) {
        this._filterDropdown.setStyleName("search-filter-hidden", !show);
    }
}

