/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.account.presentation.ui.LoginManagerImpl;
import de.justsoftware.onx.calendar.presentation.client.ui.CalendarViewDialogBox;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultHeaderView;
import de.justsoftware.onx.searchnew.presentation.client.ui.ShowMonthLinkPredicate;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import java.util.Date;
import javax.annotation.Nonnull;

public class SearchResultHeaderPresenter
implements SearchResultHeaderView.Presenter {
    private SearchParameters _searchParameters;
    private final ClientFactory _clientFactory;
    private final SearchResultHeaderView _view;

    public SearchResultHeaderPresenter(@Nonnull ClientFactory clientFactory) {
        this(clientFactory, true, false);
    }

    public SearchResultHeaderPresenter(@Nonnull ClientFactory clientFactory, boolean hasParentColumn, boolean hasContextSwitch) {
        this._clientFactory = clientFactory;
        this._view = this._clientFactory.searchFactory().createSearchResultHeaderView((SearchResultHeaderView.Presenter)this, hasParentColumn, hasContextSwitch);
    }

    public void onMonthViewClick() {
        if (this._searchParameters == null) {
            return;
        }
        EntityType entityType = (EntityType)FilterTypes.TO_ENTITY_TYPE.apply((Object)this._searchParameters.getFilterType());
        if (entityType == null) {
            return;
        }
        boolean creatingAllowed = LoginManagerImpl.getInstance().may((Action)Actions.entityCreate((EntityType)entityType));
        CalendarViewDialogBox.showCalendarViewDialogBox((ClientFactory)this._clientFactory, (boolean)creatingAllowed, (SearchParameters)this._searchParameters, (Date)new Date(), (EntityType)entityType, (boolean)false);
    }

    @Nonnull
    public SearchResultHeaderView getView() {
        return this._view;
    }

    void update(@Nonnull SearchParameters searchParameters) {
        this._searchParameters = searchParameters;
        this._view.setVisible(this._searchParameters.hasDefaultSearchProvider());
        FilterType filterType = this._searchParameters.getFilterType();
        if (ShowMonthLinkPredicate.INSTANCE.apply(filterType)) {
            this._view.showMonthLink(filterType);
        } else {
            this._view.hideMonthLink();
        }
    }

    void setResultCount(int numberOfResults) {
        this._view.setResultCount(numberOfResults);
    }
}

