/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.gwt.user.client.ui.tabs.TabData;
import de.justsoftware.gwt.user.client.ui.tabs.TabbedView;
import de.justsoftware.gwt.user.client.ui.tabs.TabbedViewResizePresenter;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.presentation.client.ClientFilterTypes;
import de.justsoftware.onx.searchnew.presentation.client.ClientSearchConfigurationProvider;
import de.justsoftware.onx.searchnew.presentation.client.SearchHandler;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterListPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterTogglePresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterToggleView;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterType;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeCountType;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class SearchFilterTabsPresenter
extends TabbedViewResizePresenter
implements SearchFilterPresenter {
    private final ClientFactory _clientFactory;
    private final TabbedView _view;
    private final SearchFilterTogglePresenter _searchFilterToggle;
    private ImmutableSet<FilterType> _filterTypes = ImmutableSet.of();
    private final boolean _searchContextSupported;
    private SearchParameters _searchParameters = null;
    private SearchFilterListPresenter _currentTab = null;
    private ImmutableMap<FilterType, TabData> _currentTabdata = null;

    public SearchFilterTabsPresenter(ClientFactory clientFactory, SearchParameters searchParameters, @Nullable SearchFilterTogglePresenter searchFilterToggle, ImmutableSet<FilterType> filterTypes, boolean searchContextSupported) {
        super(clientFactory);
        this._clientFactory = clientFactory;
        this._filterTypes = filterTypes;
        this._searchFilterToggle = searchFilterToggle == null ? this.createSearchFilterToggle(clientFactory) : searchFilterToggle;
        this._view = clientFactory.searchFactory().getSearchFilterTabsView((TabbedView.Presenter)this, (SearchFilterToggleView.Presenter)this._searchFilterToggle);
        this._searchContextSupported = searchContextSupported;
        this.onSearchParametersChanged(searchParameters);
    }

    public SearchFilterTabsPresenter(ClientFactory clientFactory, SearchParameters searchParameters) {
        this(clientFactory, searchParameters, null, ImmutableSet.of(), true);
        clientFactory.searchFactory().getOrderedSearchFilterTypes((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateFilterTypes(ImmutableSet<FilterType> filterTypes) {
        this._filterTypes = filterTypes;
    }

    @Nonnull
    private SearchFilterTogglePresenter createSearchFilterToggle(ClientFactory clientFactory) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void addToParent(HasWidgets.ForIsWidget parent) {
        parent.add((IsWidget)this._view);
    }

    public void onSearchParametersChanged(SearchParameters searchParameters) {
        this.onSearchParametersChanged(searchParameters, false);
    }

    private void onSearchParametersChanged(SearchParameters searchParameters, boolean forceRedraw) {
        if (!searchParameters.hasDefaultSearchProvider()) {
            this.setFilterSupported(false);
            return;
        }
        this.setFilterSupported(true);
        boolean redrawTabs = SearchFilterTabsPresenter.isRedrawRequired((SearchParameters)this._searchParameters, (SearchParameters)searchParameters);
        this._searchParameters = searchParameters;
        if (redrawTabs || forceRedraw) {
            ImmutableMap.Builder filterTabBuilder = ImmutableMap.builder();
            Iterable availableFilters = this.getAvailableFilterTypes();
            if (this._searchParameters.getFilterType() == null) {
                this._searchParameters = this._searchParameters.withFilter((FilterType)Iterables.getFirst((Iterable)availableFilters, null));
            }
            for (FilterType filter : availableFilters) {
                String token = this.getTokenForFilterType(filter, this._searchParameters);
                TabData data = new TabData(token, ClientFilterTypes.labelPlural((FilterType)filter), ImmutableSet.of(), (TabData.TabSelectHandler)new /* Unavailable Anonymous Inner Class!! */);
                data.setActive(this._searchParameters.hasFilter(filter));
                Long currentFilterTypeCount = this.getCurrentFilterTypeCount(filter);
                if (currentFilterTypeCount != null) {
                    data.setItemCount(currentFilterTypeCount.longValue());
                    data.setVisible(currentFilterTypeCount > 0L);
                }
                filterTabBuilder.put((Object)filter, (Object)data);
            }
            this._currentTabdata = filterTabBuilder.build();
            this._view.setTabs((Iterable)this._currentTabdata.values(), (Iterable)ImmutableSet.of());
        } else if (this._currentTab != null) {
            this._currentTab.onSearchParametersChanged(this._searchParameters);
        }
    }

    @Nonnull
    protected String getTokenForFilterType(FilterType filterType, SearchParameters searchParameters) {
        return SearchHandler.tokenFor((SearchParameters)searchParameters.withFilter(filterType).withDefaultSearchContext().withDefaultSortTypeAndSubfilter(ClientSearchConfigurationProvider.INSTANCE));
    }

    @CheckForNull
    private Long getCurrentFilterTypeCount(FilterType filterType) {
        TabData current = this._currentTabdata != null ? (TabData)this._currentTabdata.get((Object)filterType) : null;
        return current != null ? current.getItemCount() : null;
    }

    @Nonnull
    private Iterable<FilterType> getAvailableFilterTypes() {
        SearchContext searchContext = this._searchParameters.getSearchContextOrEntirePlatform();
        Predicate filterTypeAvailablePredicate = searchContext.isMyContentContext() ? Predicates.not((Predicate)Predicates.equalTo((Object)StaticFilterType.PROFILES)) : Predicates.alwaysTrue();
        return Iterables.filter((Iterable)this._filterTypes, (Predicate)filterTypeAvailablePredicate);
    }

    @VisibleForTesting
    protected static boolean isRedrawRequired(@Nullable SearchParameters prevSearchParameters, SearchParameters newSearchParameters) {
        if (prevSearchParameters == null) {
            return true;
        }
        boolean searchContextCategoryChanged = prevSearchParameters.getSearchContextOrEntirePlatform().isMyContentContext() != newSearchParameters.getSearchContextOrEntirePlatform().isMyContentContext();
        boolean contextIdChanged = !Objects.equal((Object)prevSearchParameters.getContextId(), (Object)newSearchParameters.getContextId());
        FilterType previousFilterType = prevSearchParameters.getFilterType();
        return previousFilterType == null || !Objects.equal((Object)prevSearchParameters.getText(), (Object)newSearchParameters.getText()) || !previousFilterType.equals(newSearchParameters.getFilterType()) || searchContextCategoryChanged || contextIdChanged;
    }

    public void onSearchResult(SearchResult<FederatedSearchResultEntry> result) {
        if (this._currentTab != null) {
            this._currentTab.onSearchResult(result);
        }
        if (this._currentTabdata != null) {
            for (Map.Entry entry : this._currentTabdata.entrySet()) {
                long visibleItemCount;
                FilterType filterType = (FilterType)entry.getKey();
                TabData tabData = (TabData)entry.getValue();
                ImmutableMultiset counts = (ImmutableMultiset)result.getFilterCount().get((Object)filterType);
                if (counts != null) {
                    visibleItemCount = this.getVisibleCount(filterType, counts);
                    tabData.setVisible(!counts.isEmpty());
                } else {
                    visibleItemCount = 0L;
                }
                tabData.setItemCount(visibleItemCount);
                this._view.setTabCount(tabData.getTabToken(), visibleItemCount);
            }
            this.handleContentResize(0);
        }
    }

    private long getVisibleCount(FilterType filterType, ImmutableMultiset<FilterTypeCountType> counts) {
        if (filterType instanceof EntityFilterType) {
            EntityType entityType = ((EntityFilterType)filterType).getType();
            ClientEntityConfig cec = this._clientFactory.getHostPropertiesBean().getClientEntityConfig(entityType);
            if (cec == null || EntityDurationTimeOption.OFF.equals((Object)cec.getDurationTimeOption())) {
                return counts.count((Object)FilterTypeCountType.STANDARD);
            }
            return counts.count((Object)FilterTypeCountType.FUTURE);
        }
        return counts.count((Object)FilterTypeCountType.STANDARD);
    }

    public void setFilterSupported(boolean supported) {
        this._view.setVisible(supported);
    }

    protected void resizeView() {
        this._view.handleResize();
    }

    public IsWidget getView() {
        return this._view;
    }

    public void showFilterList(boolean showFilter) {
        if (this._currentTab != null) {
            this._currentTab.showFilterList(showFilter);
            this.resizeView();
        }
    }
}

