/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.raweditor.presentation.client.ui;

import com.freiheit.toro.client.event.GlobalEventBus;
import com.freiheit.toro.client.event.GlobalEventManager;
import com.freiheit.toro.client.mediator.HistoryManager;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ui.PopupHelper;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.editor.InlineEditorView;
import de.justsoftware.onx.common.presentation.client.ui.editor.LockHandler;
import de.justsoftware.onx.common.presentation.client.ui.editor.LockOwner;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.component.ComponentTypeVisitor;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.raweditor.presentation.shared.RawEditorControllerAsync;
import de.justsoftware.onx.raweditor.shared.i18n.RawEditorConstants;
import de.justsoftware.onx.raweditor.shared.model.RawEditorVersion;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class InlineRawEditorPresenter
implements InlineEditorView.Presenter {
    private static final int RAW_EDITOR_EDIT_LINK_POS = 3;
    private static final ComponentTypeVisitor<LockOwner> LOCK_OWNER_VISITOR = new /* Unavailable Anonymous Inner Class!! */;
    private final RawEditorVersion _rawEditorVersion;
    private final InlineEditorView _view;
    private final RawEditorControllerAsync _mediator;
    private final PopupHelper _popupHelper;
    private final String _toolbar;
    private final String _locale;
    private final GlobalEventManager _globalEventManager;
    private final LockHandler _lockHandler;
    private boolean _currentlyEditing = false;

    public InlineRawEditorPresenter(EditorClientFactory clientFactory, RawEditorVersion rawEditorVersion, RawEditorControllerAsync mediator, PopupHelper popupHelper, String toolbar, String locale, HistoryManager historyManager, GlobalEventManager globalEventManager, RawEditorConstants i18n) {
        this._rawEditorVersion = rawEditorVersion;
        this._mediator = mediator;
        this._popupHelper = popupHelper;
        this._toolbar = toolbar;
        this._locale = locale;
        this._globalEventManager = globalEventManager;
        this._lockHandler = new LockHandler(clientFactory.lockManager(), (LockOwner)this._rawEditorVersion.getEditorType().accept(LOCK_OWNER_VISITOR));
        boolean editable = this._rawEditorVersion.getMay().contains((Object)StaticAction.RAWEDITOR_WRITE);
        this._view = clientFactory.getInlineEditorView((InlineEditorView.Presenter)this, (GlobalId)this._rawEditorVersion.getRawEditorId(), editable, false);
        this._view.setFilebrowserUploadUrl(UrlUtil.generateCKEditorUploadUrl((GlobalId)rawEditorVersion.getParentId()));
        this._view.setContent(this._rawEditorVersion.getText());
        if (editable) {
            this._globalEventManager.fireRenderWikiEditLink(this._rawEditorVersion.getEditorType().getNameAndParam().getName(), (GlobalEventBus.Callback)new /* Unavailable Anonymous Inner Class!! */, (String)this._rawEditorVersion.getEditorType().accept((ComponentTypeVisitor)new /* Unavailable Anonymous Inner Class!! */), 3 + (Integer)this._rawEditorVersion.getEditorType().accept((ComponentTypeVisitor)new /* Unavailable Anonymous Inner Class!! */));
            historyManager.confirmNextHistoryChange((HistoryManager.ConfirmHistoryChangeCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void stopEditing() {
        this._lockHandler.freeLock();
        this._view.showButtons(false);
        this._view.setSaveButtonEnabled(false);
        this._view.setDirty(false);
        this._view.stopInlineEditing(this._rawEditorVersion.getText());
        this._currentlyEditing = false;
        this._globalEventManager.fireActivateWikiEditLink();
    }

    private void editText(@Nullable Runnable callback) {
        if (this._currentlyEditing || !this._rawEditorVersion.getMay().contains((Object)StaticAction.RAWEDITOR_WRITE)) {
            return;
        }
        if (!this._lockHandler.tryLock()) {
            return;
        }
        this._currentlyEditing = true;
        this._globalEventManager.fireDeactivateWikiEditLink();
        this._view.showButtons(true);
        this._view.setContent(this._rawEditorVersion.getText());
        this._view.setLanguage(this._locale);
        this._view.setToolbar(this._toolbar);
        this._view.startInlineEditing(callback);
    }

    public void onEdit(boolean respectLock) {
        this.editText(null);
    }

    public void onSave(boolean sendNotificationToSubscribers) {
        String text = this._view.getContent();
        this._mediator.insertVersion(this._rawEditorVersion.getRawEditorId(), text, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onCancel() {
        this.stopEditing();
    }

    public void onContentClick(boolean respectLock) {
        this.editText(() -> ((InlineEditorView)this._view).focus());
    }

    public void onChange(boolean dirty) {
        this._view.setDirty(dirty);
        this._view.setSaveButtonEnabled(dirty);
    }

    public void showIn(AcceptsOneWidget container) {
        container.setWidget((IsWidget)this._view);
    }

    public void onUnload() {
        this._lockHandler.freeLock();
        this._globalEventManager.fireRemoveWikiEditLink(this._rawEditorVersion.getEditorType().getNameAndParam().getName());
    }

    public boolean clearOnUnload() {
        return true;
    }

    public boolean resetOnLoad() {
        return true;
    }
}

