/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client.ui.presenter;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.BoxedInfoWidget;
import de.justsoftware.onx.common.presentation.client.ui.OnxPage;
import de.justsoftware.onx.common.presentation.client.ui.PlaceHolder;
import de.justsoftware.onx.common.presentation.client.ui.PlaceHolderPanel;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.person.presentation.client.ui.presenter.ProfileOverviewPresenter;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.model.PersonDetailsModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileOverviewPresenter {
    private static final ProfileConstants PROFILE = I18nMediator.PROFILE;
    private final ClientFactory _clientFactory;
    private final OnxPage _view = new OnxPage();
    private final PersonDetailsModel _person;
    private final Predicate<ComponentModel> _componentFilter;

    public ProfileOverviewPresenter(PersonDetailsModel person, ClientFactory clientFactory) {
        this(person, clientFactory, Predicates.alwaysTrue());
    }

    public ProfileOverviewPresenter(PersonDetailsModel person, ClientFactory clientFactory, Predicate<ComponentModel> componentFilter) {
        this._clientFactory = clientFactory;
        this._componentFilter = componentFilter;
        this._person = person;
        if (this._person.isBlocked()) {
            this._view.getBottomLeft().add((Widget)this.createBoxedInfoPanel(PROFILE.profileHasBeenBlocked(), ""));
        }
        if (!this._person.isActive()) {
            this._view.getBottomLeft().add((Widget)this.createBoxedInfoPanel(PROFILE.profileDeactived(), ""));
        }
        this.addComponents();
    }

    @Nonnull
    private FlowPanel createBoxedInfoPanel(String closeTitle, String closeText) {
        FlowPanel result = new FlowPanel();
        result.addStyleName("component");
        result.add((Widget)new BoxedInfoWidget(closeTitle, closeText, IconType.LOCK));
        return result;
    }

    private void addComponents() {
        ArrayList<ComponentModel> topLeft = new ArrayList<ComponentModel>();
        ArrayList<ComponentModel> topRight = new ArrayList<ComponentModel>();
        ArrayList<ComponentModel> center = new ArrayList<ComponentModel>();
        ArrayList<ComponentModel> bottomLeft = new ArrayList<ComponentModel>();
        ArrayList<ComponentModel> bottomRight = new ArrayList<ComponentModel>();
        ImmutableList filteredComponents = FluentIterable.from((Iterable)this._person.getComponents()).filter(this._componentFilter).toList();
        for (ComponentModel c : filteredComponents) {
            switch (2.$SwitchMap$de$justsoftware$onx$container$shared$model$ComponentPosition[c.getPositionConfig().getPosition().ordinal()]) {
                case 1: {
                    topLeft.add(c);
                    break;
                }
                case 2: {
                    topRight.add(c);
                    break;
                }
                case 3: {
                    center.add(c);
                    break;
                }
                case 4: {
                    bottomLeft.add(c);
                    break;
                }
                case 5: {
                    bottomRight.add(c);
                    break;
                }
            }
        }
        this.addSortedToPanel(this._view.getTopLeft(), topLeft);
        this.addSortedToPanel(this._view.getTopRight(), topRight);
        this.addSortedToPanel(this._view.getCenter(), center);
        this.addSortedToPanel(this._view.getBottomLeft(), bottomLeft);
        this.addSortedToPanel(this._view.getBottomRight(), bottomRight);
    }

    private void addSortedToPanel(Panel p, List<ComponentModel> cs) {
        Collections.sort(cs, new /* Unavailable Anonymous Inner Class!! */);
        for (ComponentModel c : cs) {
            if (!c.getPositionConfig().isVisible()) continue;
            PlaceHolderPanel placeholder = new PlaceHolderPanel();
            p.add((Widget)placeholder);
            this._clientFactory.componentFactory().replacePlaceHolderWithProfileComponentWidget((PlaceHolder)placeholder, c, this._person);
        }
    }

    @Nonnull
    public OnxPage getView() {
        return this._view;
    }
}

