/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client.ui.presenter;

import com.freiheit.toro.account.presentation.ui.settings.SettingsHandler;
import com.freiheit.toro.client.mediator.Callback;
import com.freiheit.toro.client.mediator.Callbacks;
import com.freiheit.toro.client.mediator.HistoryManager;
import com.freiheit.toro.client.ui.ConfirmPopup;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.Presenter;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.common.presentation.client.ui.personpopup.PersonPopupManager;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.person.presentation.client.PersonClientFactory;
import de.justsoftware.onx.person.presentation.client.ui.BlockPersonClickHandler;
import de.justsoftware.onx.person.presentation.client.ui.InviteAsFriendWidget;
import de.justsoftware.onx.person.presentation.client.ui.component.ProfileOptionsView;
import de.justsoftware.onx.person.presentation.client.ui.presenter.ProfileOptionsPresenter;
import de.justsoftware.onx.person.presentation.shared.model.ProfileOption;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.i18n.ProfileMessages;
import de.justsoftware.onx.person.shared.model.PersonMayProvider;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileOptionsPresenter
implements Presenter {
    private final ProfileConstants _profileI18nConstants;
    private final ProfileMessages _profileI18nMessages;
    private final ClientFactory _clientFactory;
    private final PersonClientFactory _personClientFactory;
    private final ProfileOptionsView _view;
    private final ImmutableSet<ProfileOption> _defaultVisibleOptions;
    private final ImmutableSet<ProfileOption> _extendedOptions;
    private final EventManager _eventManager;
    private final EventManager.EventManagerHelper _eventManagerHelper;
    private final HistoryManager _historyManager;
    private PersonTeaserModel _person;
    private PersonMayProvider _mayProvider;

    public ProfileOptionsPresenter(ClientFactory clientFactory, ProfileOptionsView view, PersonTeaserModel person, PersonMayProvider mayProvider, ProfileConstants profileI18nConstants, ProfileMessages profileI18nMessages, int defaultVisibleOptionsCount) {
        this._clientFactory = clientFactory;
        this._personClientFactory = clientFactory.personClientFactory();
        this._eventManager = clientFactory.eventManager();
        this._eventManagerHelper = this._eventManager.helper();
        this._profileI18nConstants = profileI18nConstants;
        this._profileI18nMessages = profileI18nMessages;
        this._historyManager = clientFactory.historyManager();
        this._person = person;
        this._mayProvider = mayProvider;
        if (defaultVisibleOptionsCount == 0) {
            this._defaultVisibleOptions = ProfileOption.ALL;
            this._extendedOptions = ImmutableSet.of();
        } else {
            ImmutableSet activeOptions = FluentIterable.from((Iterable)ProfileOption.ALL).filter(Objects::nonNull).filter(o -> this.isOptionVisible(o, this._person, this._mayProvider)).toSet();
            this._defaultVisibleOptions = FluentIterable.from((Iterable)activeOptions).limit(defaultVisibleOptionsCount).toSet();
            this._extendedOptions = ImmutableSet.copyOf((Collection)Sets.difference((Set)activeOptions, (Set)this._defaultVisibleOptions));
        }
        this._view = view;
        this._view.asHasAttachHandlers().addAttachHandler(event -> {
            if (!event.isAttached()) {
                this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
            }
        });
        this.initView();
    }

    public void show(HasWidgets parentWidget) {
        parentWidget.add(this._view.asWidget());
    }

    private void initView() {
        this._view.clearOptions();
        for (ProfileOption option : this._defaultVisibleOptions) {
            AddOptionCallback cb = this.createAddOptionCallback(option);
            if (cb == null) continue;
            cb.call(false);
        }
        ArrayList<AddOptionCallback> extendedOptionCallbacks = new ArrayList<AddOptionCallback>(this._extendedOptions.size());
        for (ProfileOption option : this._extendedOptions) {
            AddOptionCallback callback = this.createAddOptionCallback(option);
            if (callback == null) continue;
            extendedOptionCallbacks.add(callback);
        }
        if (extendedOptionCallbacks.size() == 1) {
            ((AddOptionCallback)extendedOptionCallbacks.get(0)).call(false);
        } else {
            for (AddOptionCallback callback : extendedOptionCallbacks) {
                callback.call(true);
            }
        }
    }

    @CheckForNull
    private AddOptionCallback createAddOptionCallback(ProfileOption option) {
        switch (5.$SwitchMap$de$justsoftware$onx$person$presentation$shared$model$ProfileOption[option.ordinal()]) {
            case 1: {
                return this.addOptionAddContact(this._person, this._mayProvider);
            }
            case 2: {
                return this.addOptionRemoveInvitation(this._person, this._mayProvider);
            }
            case 3: {
                return this.addOptionAcceptInvitation(this._person);
            }
            case 4: {
                return this.addOptionDeclineInvitation(this._person);
            }
            case 5: {
                return this.addOptionRemoveContact(this._person, this._mayProvider);
            }
            case 6: {
                return this.addOptionAdminDeleteWithoutPassword(this._person, this._mayProvider);
            }
            case 7: {
                return this.addOptionAdminBlockProfile(this._mayProvider);
            }
            case 8: {
                return this.addOptionEditAccountSettings(this._person, this._mayProvider);
            }
            case 9: {
                return this.addOptionStartChat(this._person, this._mayProvider);
            }
            case 10: {
                return this.addOptionAdminActivateProfile(this._mayProvider);
            }
        }
        return null;
    }

    private boolean isOptionVisible(ProfileOption option, PersonTeaserModel person, PersonMayProvider mayProvider) {
        switch (5.$SwitchMap$de$justsoftware$onx$person$presentation$shared$model$ProfileOption[option.ordinal()]) {
            case 1: {
                return mayProvider.isAllowedTo((Action)StaticAction.PERSON_ADD_CONTACT);
            }
            case 2: {
                return mayProvider.isAllowedTo((Action)StaticAction.PERSON_REMOVE_INVITATION);
            }
            case 3: {
                return person.isInvitationPending();
            }
            case 4: {
                return person.isInvitationPending();
            }
            case 5: {
                return mayProvider.isAllowedTo((Action)StaticAction.PERSON_REMOVE_CONTACT);
            }
            case 6: {
                return mayProvider.isAllowedTo((Action)StaticAction.ADMIN_PERSON_DELETE_WITHOUT_PASSWORD);
            }
            case 7: {
                return mayProvider.isAllowedTo((Action)StaticAction.PERSON_BLOCK);
            }
            case 8: {
                return mayProvider.isAllowedTo((Action)StaticAction.PROFILE_MODIFY_ACCOUNT_SETTINGS);
            }
            case 9: {
                return this.isUserMayChatWithOther(mayProvider);
            }
            case 10: {
                return mayProvider.isAllowedTo((Action)StaticAction.PERSON_ACTIVATE);
            }
        }
        return false;
    }

    private boolean isUserMayChatWithOther(PersonMayProvider mayProvider) {
        return mayProvider.mayChatWith();
    }

    public void updatePersonData(PersonTeaserModel person, PersonMayProvider mayProvider) {
        this._person = person;
        this._mayProvider = mayProvider;
        this.initView();
    }

    private void update() {
        this._personClientFactory.personController().getPersonDetailsModelById((PersonId)this._person.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @CheckForNull
    private AddOptionCallback addOptionAdminDeleteWithoutPassword(PersonTeaserModel person, PersonMayProvider mayProvider) {
        if (mayProvider.isAllowedTo((Action)StaticAction.ADMIN_PERSON_DELETE_WITHOUT_PASSWORD)) {
            return extended -> this._view.addAdminDeleteWithoutPassword((Callback)new /* Unavailable Anonymous Inner Class!! */, person.getFullName(), extended);
        }
        return null;
    }

    @CheckForNull
    private AddOptionCallback addOptionAdminBlockProfile(PersonMayProvider mayProvider) {
        if (mayProvider.isAllowedTo((Action)StaticAction.PERSON_BLOCK)) {
            return extended -> this._view.addAdminBlockProfile((Callback)new BlockPersonClickHandler(this._person, this._profileI18nMessages), this._person.isBlocked(), extended);
        }
        return null;
    }

    @CheckForNull
    private AddOptionCallback addOptionAdminActivateProfile(PersonMayProvider mayProvider) {
        if (mayProvider.isAllowedTo((Action)StaticAction.PERSON_ACTIVATE)) {
            return extended -> this._view.addAdminActivateProfile(() -> {
                boolean isActive = this._person.isActive();
                String message = isActive ? this._profileI18nMessages.deactivateProfileQuestion(this._person.getFullName()) : this._profileI18nMessages.activateProfileQuestion(this._person.getFullName());
                ConfirmPopup popup = ConfirmPopup.makeConfirmPopup((String)message, (boolean)false);
                ClickHandler acceptHandler = event -> {
                    popup.getWidget().getElement().getStyle().setTextAlign(Style.TextAlign.CENTER);
                    popup.setContent((IsWidget)new WaitSpinner(IconSize.TWO_TIMES));
                    this._clientFactory.personClientFactory().personController().setActivated((PersonId)this._person.getId(), !isActive, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                };
                popup.addOnAcceptClickHandler(acceptHandler);
                popup.show();
            }, this._person.isActive());
        }
        return null;
    }

    @CheckForNull
    private AddOptionCallback addOptionRemoveContact(PersonTeaserModel person, PersonMayProvider mayProvider) {
        if (mayProvider.isAllowedTo((Action)StaticAction.PERSON_REMOVE_CONTACT)) {
            return extended -> this._view.addRemoveContact(() -> this._personClientFactory.friendsController().removeFriend((PersonId)person.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */), extended);
        }
        return null;
    }

    @CheckForNull
    private AddOptionCallback addOptionRemoveInvitation(PersonTeaserModel person, PersonMayProvider mayProvider) {
        if (mayProvider.isAllowedTo((Action)StaticAction.PERSON_REMOVE_INVITATION)) {
            return extended -> this._view.addRemoveInvitation(() -> this._personClientFactory.friendsController().declineInvitation((PersonId)person.getId(), (AsyncCallback)new UpdateOnSuccess(this)), extended);
        }
        return null;
    }

    @CheckForNull
    private AddOptionCallback addOptionAcceptInvitation(PersonTeaserModel person) {
        if (person.isInvitationPending()) {
            return extended -> this._view.addAcceptInvitation(() -> this._personClientFactory.friendsController().acceptInvitation((PersonId)person.getId(), (AsyncCallback)new UpdateOnSuccess(this)), extended);
        }
        return null;
    }

    @CheckForNull
    private AddOptionCallback addOptionDeclineInvitation(PersonTeaserModel person) {
        if (person.isInvitationPending()) {
            return extended -> this._view.addDeclineInvitation(() -> this._personClientFactory.friendsController().declineInvitation((PersonId)person.getId(), (AsyncCallback)new UpdateOnSuccess(this)), extended);
        }
        return null;
    }

    @CheckForNull
    private AddOptionCallback addOptionAddContact(PersonTeaserModel person, PersonMayProvider mayProvider) {
        if (mayProvider.isAllowedTo((Action)StaticAction.PERSON_ADD_CONTACT) && !person.isInvitationPending()) {
            return extended -> this._view.addContact(() -> new InviteAsFriendWidget((PersonId)person.getId(), Callbacks.compose((Callback[])new Callback[]{this._eventManager.createFireEventCallback((ClientEvent)PersonPopupManager.ClosePersonPopupEvent.INSTANCE), new UpdateOnSuccess(this)})).show(), extended);
        }
        return null;
    }

    @CheckForNull
    private AddOptionCallback addOptionEditAccountSettings(PersonTeaserModel person, PersonMayProvider mayProvider) {
        if (mayProvider.isAllowedTo((Action)StaticAction.PROFILE_MODIFY_ACCOUNT_SETTINGS)) {
            return extended -> this._view.addEditAccount(SettingsHandler.token((PersonId)((PersonId)person.getId())), extended);
        }
        return null;
    }

    @CheckForNull
    private AddOptionCallback addOptionStartChat(PersonTeaserModel person, PersonMayProvider mayProvider) {
        if (this.isUserMayChatWithOther(mayProvider)) {
            return extended -> {
                PersonId id = (PersonId)person.getId();
                Callback startChatCallback = () -> Window.Location.assign((String)("#/chat/oneOnOne/PROFILE," + id));
                this._view.addStartChat(startChatCallback, extended);
            };
        }
        return null;
    }

    public boolean containsOptions() {
        return this._view.getOptionCount() > 0;
    }
}

