/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.presentation.client.ui.presenters;

import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorPreloader;
import de.justsoftware.onx.common.presentation.client.ui.editor.InlineEditorView;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiEditorPresenter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultiWikiEditorPresenter
implements InlineEditorView.Presenter {
    private final InlineEditorView _view;
    private String _content;
    private final EditHandler _editHandler;
    private final EditorPreloader _editorPreloader;

    public MultiWikiEditorPresenter(EditorClientFactory editorFactory, GlobalId parentId, String content, String toolbar, EditHandler editHandler, boolean editable) {
        this._editHandler = editHandler;
        this._view = editorFactory.getInlineEditorView((InlineEditorView.Presenter)this, parentId, editable, true);
        this._view.setToolbar(toolbar);
        this._view.setFilebrowserUploadUrl(UrlUtil.generateCKEditorUploadUrl((GlobalId)parentId));
        this.setContent(content);
        this._editorPreloader = editorFactory.getEditorPreloader();
    }

    public void setEditable(boolean editable) {
        this._view.setEditable(editable);
        if (editable) {
            this._editorPreloader.preloadCKEditor();
        }
    }

    public void onEdit(boolean respectLock) {
    }

    public void onSave(boolean sendNotificationToSubscribers) {
    }

    public void onCancel() {
        this._view.setDirty(false);
        this._view.stopInlineEditing(this._content);
    }

    public void onContentClick(boolean respectLock) {
        this._editHandler.onEdit(() -> ((InlineEditorView)this._view).focus());
    }

    public void startEditing(@Nullable Runnable callback) {
        this._view.setWaitIndicatorVisibility(true);
        this._view.startInlineEditing(() -> {
            this._view.setWaitIndicatorVisibility(false);
            if (callback != null) {
                callback.run();
            }
        });
    }

    public void onChange(boolean dirty) {
        this._view.setDirty(dirty);
        this._editHandler.onChange();
    }

    public void showIn(AcceptsOneWidget container) {
        container.setWidget((IsWidget)this._view);
    }

    public void onUnload() {
    }

    @Nonnull
    public String getContent() {
        return this.isDirty() ? this._view.getContent() : this._content;
    }

    public boolean isDirty() {
        return this._view.checkDirty();
    }

    public void setContent(String content) {
        this._content = content;
        this._view.setContent(this._content);
    }

    public boolean clearOnUnload() {
        return this._editHandler.clearOnUnload();
    }

    public boolean resetOnLoad() {
        return this._editHandler.resetOnLoad();
    }

    public void focus() {
        this._view.focus();
    }
}

