/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.presentation.client.ui;

import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.model.ListAndCountAndIndex;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.presentation.client.ui.LikeClientService;
import de.justsoftware.onx.like.presentation.shared.LikeController;
import de.justsoftware.onx.like.presentation.shared.LikeControllerAsync;
import de.justsoftware.onx.like.shared.model.LikeStatus;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionStatus;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class LikeClientServiceImpl
implements LikeClientService {
    private final ClientFactory _clientFactory;
    private final LikeControllerAsync _asyncController;

    public LikeClientServiceImpl(ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._asyncController = (LikeControllerAsync)GWT.create(LikeController.class);
        UrlUtil.setRemoteServiceUrl((Object)this._asyncController, (String)"/like");
    }

    public void getAllLikers(ItemId itemId, int offset, int limit, AsyncCallback<ListAndCountAndIndex<PersonTeaserModel>> callback) {
        this._asyncController.getAllLikers(itemId, offset, limit, callback);
    }

    public void getLikes(ImmutableSet<ItemId> ids, AsyncCallback<Map<ItemId, LikeStatus>> callback) {
        this._asyncController.getLikes(ids, callback);
    }

    public void getLike(ItemId id, AsyncCallback<LikeStatus> callback) {
        this._asyncController.getLike(id, callback);
    }

    public void setLikeAndSubscription(ItemId itemId, boolean like) {
        this._asyncController.setLikeAndSubscription(itemId, like, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setSubscriptionsState(ItemId itemId, EntityType entityType, SubscriptionState state, AsyncCallback<SubscriptionStatus> callback) {
        this._asyncController.setSubscriptionsState(ImmutableSet.of((Object)itemId), state, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

