/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.license.presentation.client;

import com.freiheit.toro.util.client.LoggingUtil;
import com.google.common.collect.Sets;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Window;
import de.justsoftware.onx.common.shared.util.RegExUtil;
import de.justsoftware.onx.license.presentation.client.LicenseClientFactory;
import de.justsoftware.onx.license.shared.model.LicenseClientModel;
import de.justsoftware.onx.license.shared.model.LicenseProblem;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class LicenseWarningPresenter {
    private final LicenseClientFactory _licenseClientFactory;

    public LicenseWarningPresenter(@Nonnull LicenseClientFactory licenseClientFactory) {
        this._licenseClientFactory = licenseClientFactory;
    }

    public void check(@Nonnull LicenseClientModel license) {
        EnumSet problems = Sets.newEnumSet((Iterable)license.getProblems(), LicenseProblem.class);
        String domains = license.getDomains();
        if (!problems.contains(LicenseProblem.COULD_NOT_LOAD_OR_VERIFY) && domains != null) {
            String usedDomain = Window.Location.getHostName();
            RegExp domainPattern = RegExp.compile((String)RegExUtil.wildcardsListToRegExString((String)domains), (String)"i");
            if (!domainPattern.test(usedDomain)) {
                problems.add(LicenseProblem.NO_DOMAIN_MATCH);
            }
        }
        LoggingUtil.info((Object)this, (String)("License Problems: " + problems));
        if (!problems.isEmpty()) {
            this._licenseClientFactory.getLicenseWarningView().show((Set)problems);
        }
    }
}

