/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.drive.presentation.client;

import com.google.common.base.Strings;
import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtml;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.PreviewManager;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemIdVisitor;
import de.justsoftware.onx.drive.presentation.client.DriveClientFactory;
import de.justsoftware.onx.drive.presentation.client.DriveClientFactoryImpl;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.drive.shared.model.DriveShareId;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSearchResultBadgeModel;
import java.util.function.IntConsumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class DriveClientFactoryImpl
implements DriveClientFactory {
    private static final String DEFAULT_BASENAME = "/drive";
    private static final DriveTemplates TEMPLATES = (DriveTemplates)GWT.create(DriveTemplates.class);
    private final ClientFactory _clientFactory;

    public DriveClientFactoryImpl(ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
    }

    public void translate(String key, DriveClientFactory.StringCallback i18nCallback) {
        DriveClientFactoryImpl.translateNative((String)key, (String)this._clientFactory.getCurrentLocale(), (DriveClientFactory.StringCallback)i18nCallback);
    }

    public String urlToShare(DriveShareId id) {
        return "/drive/share/" + id.asString();
    }

    public String urlToFile(DriveDocumentId id) {
        return this.urlToFile(id, "/drive");
    }

    public String urlToFile(DriveDocumentId id, String basename) {
        return basename + "/file/" + id.getId();
    }

    public String urlToFolder(DriveDocumentId id) {
        return this.urlToFolder(id, "/drive");
    }

    public String urlToFolder(DriveDocumentId id, String basename) {
        return basename + "/folder/" + id.getId();
    }

    @Nonnull
    private String getDefaultHistoryToken(DriveDocumentId id, DriveDocumentSearchResultBadgeModel.DocumentType documentType) {
        if (documentType == DriveDocumentSearchResultBadgeModel.DocumentType.FOLDER) {
            return this.urlToFolder(id);
        }
        return PreviewManager.getPreviewLinkForCurrentLocation((DriveDocumentId)id, null);
    }

    public String getHistoryToken(DriveDocumentId id, DriveDocumentSearchResultBadgeModel.DocumentType documentType, ItemId parentId) {
        if (parentId == null) {
            return this.getDefaultHistoryToken(id, documentType);
        }
        return (String)parentId.accept((ItemIdVisitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getIconUrlForMimeType(@Nullable String mimeType) {
        return DriveClientFactoryImpl.nativeGetIconUrlForMimeType((String)Strings.nullToEmpty((String)mimeType));
    }

    @Nonnull
    private static native String translateNative(String var0, String var1, DriveClientFactory.StringCallback var2);

    @CheckForNull
    private static native String nativeGetIconUrlForMimeType(String var0);

    public SafeHtml getFolderIcon() {
        return TEMPLATES.folderIcon();
    }

    public SafeHtml getShareIcon() {
        return TEMPLATES.shareIcon();
    }

    public void grantShareAccess(PersonId personId, DriveShareId shareId, String permission, IntConsumer callback) {
        this.grantShareAccess((double)personId.getId(), shareId.asString(), permission, callback);
    }

    private native void grantShareAccess(double var1, String var3, String var4, IntConsumer var5);

    private native void nativeRefreshFolder(String var1);

    public void refreshFolder(String folderId) {
        this.nativeRefreshFolder(folderId);
    }
}

