/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.server;

import com.freiheit.toro.account.shared.model.WrongPasswordException;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import de.justsoftware.gwt.i18n.dynamic.server.I18nMessagesFactory;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.i18n.I18nServiceException;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.Person;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.action.VisibleActionSet;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityEventWorkflowService;
import de.justsoftware.onx.container.business.EntityInvitationWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberNotificationService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowMigrationService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowService;
import de.justsoftware.onx.container.business.EntityMembershipInfoService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EventWaitlistService;
import de.justsoftware.onx.container.business.RandomEntityMemberService;
import de.justsoftware.onx.container.presentation.shared.EntityMemberController;
import de.justsoftware.onx.container.presentation.shared.MemberWorkflowMigrationOption;
import de.justsoftware.onx.container.presentation.shared.model.EventMembershipChangeResult;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.EntityAdminTransferModel;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberConfiguratorInfo;
import de.justsoftware.onx.container.shared.model.EntityMemberPagerParams;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityMembership;
import de.justsoftware.onx.container.shared.model.EntityMembershipInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.FailedAndSuccessfulActionsDetails;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.InvitationResultKey;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.JoinChildEntityViewData;
import de.justsoftware.onx.container.shared.model.MakeCoAdminStatusKey;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.container.shared.model.MyMemberStatus;
import de.justsoftware.onx.container.shared.model.RoleOrInheritedRole;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.EmailModel;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class EntityMemberControllerImpl
implements EntityMemberController {
    private static final Logger LOG = LoggerFactory.getLogger(EntityMemberControllerImpl.class);
    private static final int RANDOM_PERSON_TEASER_COUNT = 3;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private EntityMemberService _entityMemberService;
    @Autowired
    private RandomEntityMemberService _randomEntityMemberService;
    @Autowired
    private EntityMemberNotificationService _entityNotificationService;
    @Autowired
    private EntityMemberWorkflowService _entityMemberWorkflowService;
    @Autowired
    private EntityAdministrationWorkflowService _entityAdministrationWorkflowService;
    @Autowired
    private EntityEventWorkflowService _entityEventWorkflowService;
    @Autowired
    private EntityInvitationWorkflowService _entityInvitationWorkflowService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private EventWaitlistService _waitlistService;
    @Autowired
    private EntityMemberWorkflowMigrationService _entityMemberWorkflowMigrationService;
    @Autowired
    private EntityChildrenService _entityChildrenService;
    @Autowired
    private EntityMembershipInfoService _entityAdminInfoService;
    @Autowired
    private Settings _settings;
    @Autowired
    private PasswordEncoder _passwordEncoder;

    public ImmutableList<PersonTeaserModel> getRandomMembers(EntityId id) throws ServiceException {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authCtx.check((ItemId)id, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        ImmutableSet ids = this._randomEntityMemberService.getRandomMemberIds(id, 3);
        ImmutableMap resultMap = this._profileTeaserService.getPersonTeasersByIds((Set)ids, (AuthorizationCheckContextWithLocale)authCtx);
        return FluentIterable.from((Iterable)ids).transform(Functions.forMap((Map)resultMap, null)).filter(Predicates.notNull()).toList();
    }

    public ListAndCount<EntityMembership> getEntityMembersByFilter(EntityId entityId, RoleOrInheritedRole roleOrInheritedRole, String filter, int offset, int count) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        ImmutableMap allMembers = this._entityMemberService.getEntityMembersMappedByEntityId(entityId);
        ListAndCount resultMembers = this.getMembersWithRole(entityId, allMembers, offset, count, roleOrInheritedRole, filter);
        ImmutableMap simplePersonsMapByIds = this._profileTeaserService.getPersonTeasersByIds((Set)EntityMemberUtil.transformToPersonIdSet((Iterable)resultMembers), (AuthorizationCheckContextWithLocale)authorizationContext);
        return EntityMemberControllerImpl.convertToEntityMember((EntityId)entityId, (ListAndCount)resultMembers, (Map)simplePersonsMapByIds, (Map)allMembers, (AuthorizationCheckContextWithLocale)authorizationContext);
    }

    public ImmutableListMultimap<RoleOrInheritedRole, EntityMembership> getAllEntityAdmins(EntityId entityId) {
        return this._entityAdminInfoService.getAllEntityAdmins(entityId, (AuthorizationCheckContextWithLocale)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    @Nonnull
    private static ListAndCount<EntityMembership> convertToEntityMember(EntityId entityId, ListAndCount<EntityMemberWithPerson> entityMembers, Map<PersonId, PersonTeaserModel> simplePersonsMapByIds, Map<PersonId, EntityMemberWithPerson> allEntityMembers, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableSet publicProfiles = authorizationContext.filterRoles((ImmutableCollection)entityMembers.stream().map(EntityMember::getPersonId).map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet()));
        List data = Lists.transform(entityMembers, (Function)new /* Unavailable Anonymous Inner Class!! */);
        return new ListAndCount(entityMembers.getMaxCount(), (Collection)data);
    }

    public EntityMemberConfiguratorInfo getEntityMemberConfiguratorInfo(EntityId id, ImmutableMap<RoleOrInheritedRole, EntityMemberPagerParams> pagers) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)id, (Action)StaticEntityAction.ENTITY_MODIFY);
        EntityMemberConfiguratorInfo result = new EntityMemberConfiguratorInfo();
        ImmutableMap unfilteredMembers = this._entityMemberService.getEntityMembersMappedByEntityId(id);
        ImmutableSet actions = ImmutableSet.of((Object)StaticEntityAction.ENTITY_MAKE_ADMIN, (Object)StaticEntityAction.ENTITY_MAKE_COADMIN, (Object)StaticEntityAction.ENTITY_MANAGE_MEMBER, (Object)StaticEntityAction.ENTITY_DELETE_COADMIN, (Object)StaticEntityAction.ENTITY_EXPORT_MEMBERS, (Object)StaticEntityAction.ENTITY_INVITE, (Object[])new StaticEntityAction[0]);
        result.setMay(authorizationContext.may((ItemId)id, actions));
        ImmutableMap.Builder entityMembersBuilder = ImmutableMap.builder();
        for (Map.Entry entry : pagers.entrySet()) {
            EntityMemberPagerParams pager = (EntityMemberPagerParams)entry.getValue();
            RoleOrInheritedRole roleOrInheritedRole = (RoleOrInheritedRole)entry.getKey();
            ListAndCount orderedPagedMember = this.getMembersWithRole(id, unfilteredMembers, pager.getOffset(), pager.getLimit(), roleOrInheritedRole, "");
            entityMembersBuilder.put((Object)roleOrInheritedRole, (Object)orderedPagedMember);
        }
        ImmutableMap entityMember = entityMembersBuilder.build();
        ImmutableMap simplePersonsMapByIds = this._profileTeaserService.getPersonTeasersByIds((Set)FluentIterable.from((Iterable)Iterables.concat((Iterable)entityMember.values())).transform(EntityMember.GET_PERSON_ID).toSet(), (AuthorizationCheckContextWithLocale)authorizationContext);
        ImmutableMap.Builder entityMemberShips = ImmutableMap.builder();
        for (Map.Entry entry : entityMember.entrySet()) {
            entityMemberShips.put((Object)((RoleOrInheritedRole)entry.getKey()), (Object)EntityMemberControllerImpl.convertToEntityMember((EntityId)id, (ListAndCount)((ListAndCount)entry.getValue()), (Map)simplePersonsMapByIds, (Map)unfilteredMembers, (AuthorizationCheckContextWithLocale)authorizationContext));
        }
        result.setEntityMembers(entityMemberShips.build());
        return result;
    }

    @Nonnull
    private ListAndCount<EntityMemberWithPerson> getMembersWithRole(EntityId entityId, ImmutableMap<PersonId, EntityMemberWithPerson> allMembers, int offset, int limit, RoleOrInheritedRole roleOrInheritedRole, String filter) {
        if (EntityMemberRole.EVENT_IS_ON_WAITINGLIST.equals((Object)roleOrInheritedRole)) {
            return this.getMembersOnWaitlist(entityId, offset, limit, allMembers, filter);
        }
        return (ListAndCount)roleOrInheritedRole.accept((RoleOrInheritedRole.Visitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    private ListAndCount<EntityMemberWithPerson> getMembersOnWaitlist(EntityId entityId, int offset, int limit, ImmutableMap<PersonId, EntityMemberWithPerson> allMembers, String filter) {
        ImmutableSet allPersonsOnWaitinglist = this._waitlistService.getParticipantsFromWaitlist((Set)ImmutableSet.of((Object)entityId)).get((Object)entityId);
        ImmutableList waitingList = FluentIterable.from((Iterable)allPersonsOnWaitinglist).transform(Functions.forMap(allMembers, null)).filter(Predicates.notNull()).filter(input -> input.getRoles().contains((Object)EntityMemberRole.EVENT_IS_ON_WAITINGLIST)).filter(EntityMemberUtil.matchSearchQuery((String)filter)).toList();
        return new ListAndCount((List)waitingList, offset, limit);
    }

    public ListAndCount<PersonTeaserModel> getInheritPersons(EntityId entityId, InheritsRole inheritsRole, boolean activeOnly, int offset, int limit) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        ListAndCount subList = this._entityMemberService.getInheritPersons(entityId, inheritsRole, "", activeOnly, (AuthorizationCheckContextWithLocale)authCtx, offset, limit);
        ImmutableMap persons = this._profileTeaserService.getPersonTeasersByIds((Set)FluentIterable.from((Iterable)subList).transform(EntityMember.GET_PERSON_ID).toSet(), (AuthorizationCheckContextWithLocale)authCtx);
        ListAndCount result = new ListAndCount(subList.size());
        for (EntityMemberWithPerson pid : subList) {
            PersonTeaserModel personTeaserModel = (PersonTeaserModel)persons.get((Object)pid.getPersonId());
            if (personTeaserModel == null) continue;
            result.add((Object)personTeaserModel);
        }
        result.setMaxCount(subList.getMaxCount());
        return result;
    }

    public void leaveEntity(EntityId id) throws ServiceException {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authCtx.check((ItemId)id, (Action)StaticEntityAction.ENTITY_LEAVE);
        this._entityMemberWorkflowService.leaveEntity(id, authCtx.getUserId(), (AuthorizationCheckContextWithUserId)authCtx);
    }

    public EntityInfo joinEntity(EntityId id) throws ServiceException {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._entityMemberWorkflowService.joinEntity(id, (AuthorizationCheckContextWithUserId)authorizationContext);
        return this._entityService.getInfoById(id, (AuthorizationCheckContextWithLocale)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public void deleteJoinRequest(EntityId id) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._entityMemberWorkflowService.withdrawJoinRequest(id, (AuthorizationCheckContextWithUserId)authCtx);
    }

    public void deleteCoAdmins(EntityId entityId, ImmutableSet<PersonId> persons) throws ServiceException {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_DELETE_COADMIN);
        this._entityAdministrationWorkflowService.deleteCoAdmins(entityId, persons);
    }

    public ImmutableMultiset<EntityMemberRole> getEntityMemberSizeByStatusAndRole(EntityId id) throws ServiceException {
        this._authorizationContextProvider.getAuthorizationContextForCurrentUser().check((ItemId)id, (Action)StaticEntityAction.ENTITY_SEND_NEWSLETTER);
        ImmutableList members = this._entityMemberService.getEntityMembersByEntityId(id);
        return ImmutableMultiset.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)members, (Function)EntityMember.GET_ROLES)));
    }

    @Nonnull
    private ImmutableMap<InvitationResultKey, String> getSuccessfulInvitationsMessages(Multiset<InvitationResultKey> numberOfInvitedPersons, EntityMessages entityMessages) {
        int alreadyInvitedInternal = numberOfInvitedPersons.count((Object)InvitationResultKey.ALREADY_INVITED_INTERNAL);
        int invitedInternal = numberOfInvitedPersons.count((Object)InvitationResultKey.INVITED_INTERNAL);
        int grantToMember = numberOfInvitedPersons.count((Object)InvitationResultKey.GRANT_TO_MEMBER);
        ImmutableMap.Builder messagesBuilder = ImmutableMap.builder();
        if (invitedInternal > 0) {
            messagesBuilder.put((Object)InvitationResultKey.INVITED_INTERNAL, (Object)entityMessages.xInternalInviationWasSent(invitedInternal));
        }
        if (alreadyInvitedInternal > 0) {
            messagesBuilder.put((Object)InvitationResultKey.ALREADY_INVITED_INTERNAL, (Object)entityMessages.xInvitationSkiped(alreadyInvitedInternal));
        }
        if (grantToMember > 0) {
            messagesBuilder.put((Object)InvitationResultKey.GRANT_TO_MEMBER, (Object)entityMessages.xPeopleWasGrantToMember(grantToMember));
        }
        return messagesBuilder.build();
    }

    public FailedAndSuccessfulActionsDetails<EntityId, ImmutableMap<InvitationResultKey, String>> inviteAllSelectedPersonsToEntity(ImmutableSet<Person> selectedPersons, EntityId entityId, String inviteMessage, ImmutableSet<ComponentType> selecteEditorTypes) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        authorizationContext.check((Item)new EntityItem(entity), (Action)StaticEntityAction.ENTITY_INVITE);
        FailedAndSuccessfulActionsDetails.Builder result = FailedAndSuccessfulActionsDetails.getBuilder();
        EntityMessages entityMessages = this._i18nService.getEntityMessagesByEntityType(entity.getType(), authorizationContext.getLocale());
        Multiset numberOfInvitedPersons = this.invitePersonsToEntity(selectedPersons, inviteMessage, authorizationContext, entity.getId(), selecteEditorTypes);
        result.addDetails((ItemId)entityId, (Object)this.getSuccessfulInvitationsMessages(numberOfInvitedPersons, entityMessages));
        return result.build();
    }

    public FailedAndSuccessfulActionsDetails<EntityId, ImmutableMap<InvitationResultKey, String>> inviteAllSelectedPersonsToEntities(ImmutableSet<Person> selectedPersons, ImmutableSet<EntityId> entityIds, String inviteMessage, EntityType type) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        EntityMessages entityMessages = this._i18nService.getEntityMessagesByEntityType(type, authorizationContext.getLocale());
        Map entities = this._entityService.getByIds(entityIds);
        FailedAndSuccessfulActionsDetails.Builder result = FailedAndSuccessfulActionsDetails.getBuilder();
        for (DBEntity entity : entities.values()) {
            if (authorizationContext.may((Item)new EntityItem(entity), (Action)StaticEntityAction.ENTITY_INVITE)) {
                Multiset numberOfInvitedPersons = this.invitePersonsToEntity(selectedPersons, inviteMessage, authorizationContext, entity.getId(), ImmutableSet.of());
                result.addDetails((ItemId)entity.getId(), (Object)this.getSuccessfulInvitationsMessages(numberOfInvitedPersons, entityMessages));
                continue;
            }
            int invitationNotAllowed = selectedPersons.size();
            if (invitationNotAllowed <= 0) continue;
            result.addErrorMessage((ItemId)entity.getId(), entityMessages.notAllowedToInviteUsers(invitationNotAllowed));
        }
        return result.build();
    }

    @Nonnull
    private Multiset<InvitationResultKey> invitePersonsToEntity(ImmutableSet<Person> selectedPersons, String inviteMessage, AuthorizationContext authCtx, EntityId entityId, ImmutableSet<ComponentType> selectedEditorTypes) {
        if (CollectionUtil.isEmpty(selectedPersons)) {
            I18nMessagesFactory factory = new I18nMessagesFactory();
            throw new I18nServiceException(factory.getMessage(((BasicConstants)factory.createProxy(BasicConstants.class)).pleaseSelectAtLeastOnePerson()));
        }
        if (inviteMessage.length() > this._settings.getInviteEmailMaxMessageLength()) {
            I18nMessagesFactory factory = new I18nMessagesFactory();
            throw new I18nServiceException(factory.getMessage(((BasicConstants)factory.createProxy(BasicConstants.class)).invitationMessageLengthExceeded()));
        }
        ImmutableSet.Builder internalInvitees = ImmutableSet.builder();
        for (Person invitee : selectedPersons) {
            PersonId id = invitee.getId();
            internalInvitees.add((Object)id);
        }
        return this._entityInvitationWorkflowService.invitePersons((AuthorizationCheckContextWithUserId)authCtx, (Set)internalInvitees.build(), entityId, inviteMessage, selectedEditorTypes);
    }

    @Nonnull
    private EntityMembershipInfo getEntityMembershipInfo(DBEntity entity, Multimap<EntityId, ? extends EntityMember> entityMember, AuthorizationCheckContextWithUserId authorizationContext) throws ServiceException {
        EntityMembershipInfo result = new EntityMembershipInfo();
        result.setClosed(this._entityService.isEntityClosed(entity));
        result.setInThePast(this._entityService.isEntityInThePast(entity));
        result.setEntityInfo((EntityInfo)InvalidIdServiceException.check((Object)this._entityService.getInfoById(entity.getId(), (AuthorizationCheckContextWithLocale)authorizationContext)));
        result.setEndAt((Date)entity.getEndAt());
        result.setStartAt((Date)entity.getStartAt());
        Collection members = entityMember.get((Object)entity.getId());
        Iterable filteredMembers = EntityMemberUtil.filterByRoles((Iterable)members, (EntityMemberRole[])new EntityMemberRole[]{EntityMemberRole.MEMBER});
        result.setCurrentParticipantCount(Iterables.size((Iterable)filteredMembers));
        EntityMember member = (EntityMember)Iterables.getFirst((Iterable)Iterables.filter((Iterable)members, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)authorizationContext.getUserId()), (Function)EntityMember.GET_PERSON_ID)), null);
        if (member != null) {
            result.setMemberRoles(member.getRoles());
        }
        return result;
    }

    public EntityMembershipInfo getEntityMembershipInfo(EntityId id) throws ServiceException {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        DBEntity entity = this._entityService.getByIdNotNull(id);
        ImmutableListMultimap members = this._entityMemberService.getEntityMembersByEntityIds((Set)ImmutableSet.of((Object)id));
        return this.getEntityMembershipInfo(entity, (Multimap)members, (AuthorizationCheckContextWithUserId)authorizationContext);
    }

    public void removeMembersFromEntity(EntityId entityId, ImmutableSet<PersonId> persons) throws ServiceException {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._entityMemberWorkflowService.removeMembersFromEntity(entityId, persons, authorizationContext);
    }

    public void makeAdmin(EntityId id, PersonId personId) throws ServiceException {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authCtx.check((ItemId)id, (Action)StaticEntityAction.ENTITY_MAKE_ADMIN);
        this._entityAdministrationWorkflowService.grantMemberToAdmin(id, personId, MemberChangeOptions.buildDefaultWith((AuthorizationCheckContextWithUserId)authCtx));
    }

    public FailedAndSuccessfulActionsDetails<EntityId, ImmutableMap<MakeCoAdminStatusKey, Integer>> makeCoAdmins(EntityId id, Set<PersonId> personIds) {
        FailedAndSuccessfulActionsDetails.Builder result = FailedAndSuccessfulActionsDetails.getBuilder();
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        if (auth.may((ItemId)id, (Action)StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            result.addDetails((ItemId)id, (Object)this._entityAdministrationWorkflowService.grantMembersToCoAdmin(id, personIds, MemberChangeOptions.buildDefaultWith((AuthorizationCheckContextWithUserId)auth)));
        } else {
            result.addErrorMessage((ItemId)id, ((BasicConstants)this._i18nService.createProxy(BasicConstants.class, auth.getLocale())).noPermission());
        }
        return result.build();
    }

    public void makeCoAdminWithMeAsAdminFallback(EntityId entityId, ImmutableSet<PersonId> newCoAdmins) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._entityAdministrationWorkflowService.makeCoAdminWithMeAsAdminFallback(entityId, newCoAdmins, (AuthorizationCheckContextWithUserId)authCtx);
    }

    public void acceptInvitation(EntityId id) {
        this._entityMemberWorkflowService.acceptInvitation(id, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public void acceptJoinRequest(PersonId memberId, EntityId entityId) {
        this._entityMemberWorkflowService.acceptJoinRequest(entityId, memberId, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public void declineJoinRequest(PersonId memberId, EntityId entityId) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._entityMemberWorkflowService.declineJoinRequest(ImmutableSet.of((Object)entityId), memberId, (AuthorizationCheckContextWithUserId)authCtx);
    }

    public ListAndCount<PersonTeaserModel> getAdminsByEntityId(EntityId entityId, int offset, int limit) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authCtx.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        return this._entityAdministrationWorkflowService.getActiveAdminsByEntityId(entityId, offset, limit, (AuthorizationCheckContextWithLocale)authCtx);
    }

    public MyMemberStatus getMyMemberStatus(EntityId entityId) {
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        return (MyMemberStatus)Preconditions.checkNotNull((Object)((MyMemberStatus)this._entityService.getMyMemberStatus((AuthorizationContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser(), (Map)ImmutableMap.of((Object)entityId, (Object)entity)).get((Object)entityId)));
    }

    public void sendMessageToEntityMembers(EntityId entityId, ImmutableSet<EntityMemberRole> toMemberOfRoles, String subject, String message) throws ServiceException {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_SEND_NEWSLETTER);
        this._entityNotificationService.sendMessageToEntityMembers(authorizationContext.getUserId(), entityId, toMemberOfRoles, subject, message, authorizationContext.getLocale());
    }

    public JoinChildEntityViewData getJoinChildEntityViewData(EntityId entityId, EntityType entityTypeOfMembership, int offset, int limit) throws ServiceException {
        if (limit > 10) {
            throw new IllegalArgumentException("Limit bigger than 10 not allowed");
        }
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        ImmutableList entityChildSortBy = ImmutableSet.copyOf((Collection)this._entityChildrenService.getChildrenIds(entityId, (Iterable)ImmutableSet.of((Object)entityTypeOfMembership), true, SortType.ALPHABETICAL)).asList();
        ListAndCount listAndCount = CollectionUtil.nullSafeListAndCount((List)entityChildSortBy, (int)offset, (int)limit);
        ImmutableSet entityIds = ImmutableSet.builder().add((Object)entityId).addAll((Iterable)listAndCount).build();
        ImmutableListMultimap members = this._entityMemberService.getEntityMembersByEntityIds((Set)entityIds);
        Map entities = this._entityService.getByIds((Set)entityIds);
        JoinChildEntityViewData result = new JoinChildEntityViewData();
        result.setChildType(entityTypeOfMembership);
        result.setCurrentEntity(this.getEntityMembershipInfo((DBEntity)InvalidIdServiceException.check((Object)((DBEntity)entities.get(entityId))), (Multimap)members, (AuthorizationCheckContextWithUserId)authorizationContext));
        result.setLimit(limit);
        result.setOffset(offset);
        ListAndCount entityMembershipInfos = new ListAndCount();
        entityMembershipInfos.setMaxCount(listAndCount.getMaxCount());
        for (EntityId id : listAndCount) {
            DBEntity entity = (DBEntity)entities.get(id);
            if (entity != null) {
                entityMembershipInfos.add((Object)this.getEntityMembershipInfo(entity, (Multimap)members, (AuthorizationCheckContextWithUserId)authorizationContext));
                continue;
            }
            LOG.warn("Can't find entity {} in DB. Please check if the search index is up to date.", (Object)id);
        }
        result.setEntityMembershipInfos(entityMembershipInfos);
        return result;
    }

    public EntityMembershipInfo joinOrDisjoinEntityAndReturnEntityMembershipInfo(EntityId id) throws ServiceException {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        EntityMemberWithEntityType member = this._entityMemberService.getMemberByPersonIdAndEntityId(authorizationContext.getUserId(), id);
        if (member != null) {
            if (EntityMemberUtil.isMember((EntityMember)member)) {
                MemberChangeOptions noMailOptions = MemberChangeOptions.builder().disableEmailNotification().setActor((AuthorizationCheckContextWithUserId)authorizationContext).build();
                this._entityMemberWorkflowService.leaveEntities((Set)ImmutableSet.of((Object)id), member.getPersonId(), noMailOptions, (AuthorizationCheckContextWithUserId)authorizationContext);
            } else if (EntityMemberUtil.hasInvitation((EntityMember)member) || EntityMemberUtil.hasRejected((EntityMember)member)) {
                this.acceptInvitation(id);
            } else if (EntityMemberUtil.hasSentJoinRequest((EntityMember)member)) {
                this.deleteJoinRequest(id);
            } else if (!EntityMemberUtil.isUndecided((EntityMember)member)) {
                this.joinEntity(id);
            }
        }
        return this.getEntityMembershipInfo(id);
    }

    public EntityAdminTransferModel getEntityAdminTransferModel(PersonId personId) throws ServiceException {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        auth.check((ItemId)personId.asProfileId(), (Action)StaticAction.ADMIN_PERSON_DELETE_WITHOUT_PASSWORD);
        return this.getEntityAdminTransferModel(personId, (AuthorizationCheckContextWithLocale)auth);
    }

    public EntityAdminTransferModel getEntityAdminTransferModel(String password) throws ServiceException {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        PersonId personId = auth.getUserId();
        ProfileItem user = (ProfileItem)InvalidIdServiceException.check((Object)this._personService.getProfileItemByPersonId(personId));
        auth.check((Item)user, (Action)StaticAction.PERSON_DELETE);
        if (this._passwordEncoder.matches((CharSequence)password, user.getPerson().getPasswordHash())) {
            return this.getEntityAdminTransferModel(personId, (AuthorizationCheckContextWithLocale)auth);
        }
        throw new WrongPasswordException();
    }

    @Nonnull
    private EntityAdminTransferModel getEntityAdminTransferModel(PersonId personId, AuthorizationCheckContextWithLocale authCtx) {
        EntityAdminTransferModel result = new EntityAdminTransferModel();
        result.setAdminEntities(this._entityAdministrationWorkflowService.getAdminEntities(personId, authCtx));
        result.setPersonForAdminRightsTransfer(this._entityAdministrationWorkflowService.getPersonForAdminRightsTransfer(authCtx));
        return result;
    }

    public EmailModel getEmailModelForFeedbackEmailToAdmins(EntityId entityId) {
        return this._entityNotificationService.getEmailModelForFeedbackEmailToAdmins((AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser(), entityId);
    }

    public EventMembershipChangeResult eventAttend(EntityId entityId, VisibleActionSet actionSet) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.EVENT_ATTEND);
        this._entityEventWorkflowService.attendEvent(entityId, (AuthorizationCheckContextWithUserId)authorizationContext);
        return this.getAllowedActions(entityId, actionSet);
    }

    @Nonnull
    private EventMembershipChangeResult getAllowedActions(EntityId entityId, @Nullable VisibleActionSet actionSet) {
        ImmutableSet actions = actionSet != null ? this._entityService.getAllowedEntityActions((Set)ImmutableSet.of((Object)entityId), actionSet, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser()).get((Object)entityId) : ImmutableSet.of();
        MyMemberStatus status = this.getMyMemberStatus(entityId);
        return new EventMembershipChangeResult(actions, status);
    }

    public EventMembershipChangeResult eventMaybeAttend(EntityId entityId, VisibleActionSet actionSet) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.EVENT_MAYBE_ATTEND);
        this._entityEventWorkflowService.maybeAttendEvent(entityId, (AuthorizationCheckContextWithUserId)authorizationContext);
        return this.getAllowedActions(entityId, actionSet);
    }

    public EventMembershipChangeResult eventDontAttend(EntityId entityId, VisibleActionSet actionSet) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.EVENT_DONT_ATTEND);
        this._entityEventWorkflowService.dontAttendEvent(entityId, (AuthorizationCheckContextWithUserId)authorizationContext);
        return this.getAllowedActions(entityId, actionSet);
    }

    public EventMembershipChangeResult eventLeave(EntityId entityId, VisibleActionSet actionSet) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._entityEventWorkflowService.leaveEvent(entityId, (AuthorizationCheckContextWithUserId)authorizationContext);
        return this.getAllowedActions(entityId, actionSet);
    }

    public void eventMovePersonsToList(EntityId entityId, ImmutableSet<PersonId> persons, EntityMemberRole statusToAssign) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._entityEventWorkflowService.managerMovePersonsToList(entityId, persons, statusToAssign, (AuthorizationCheckContextWithUserId)authorizationContext);
    }

    public void eventRemovePersonsFromEvent(EntityId entityId, Set<PersonId> personIds) throws ServiceException {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._entityEventWorkflowService.managerRemoveMovePersonsFromEvent(entityId, personIds, (AuthorizationCheckContextWithUserId)authorizationContext);
    }

    public EventMembershipChangeResult rejectInvitation(EntityId entityId, VisibleActionSet actionSet) {
        this._entityInvitationWorkflowService.rejectInvitation(entityId, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
        return this.getAllowedActions(entityId, actionSet);
    }

    public void moveToMemberList(EntityId entityId, Set<PersonId> personIds) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._entityMemberWorkflowService.moveToMemberList(entityId, personIds, MemberChangeOptions.buildDefaultWith((AuthorizationCheckContextWithUserId)authCtx), (AuthorizationCheckContextWithUserId)authCtx);
    }

    public void migrateEntityWorkflowMemberRolesFor(ImmutableSet<EntityType> entityTypes, MemberWorkflowMigrationOption migrationOption) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        this._entityMemberWorkflowMigrationService.migrateEntityTypes(entityTypes, migrationOption.getRole());
    }

    public ImmutableSet<PersonId> getAllEntityMemberIds(EntityId id) {
        AuthorizationContext context = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        context.check((ItemId)id, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        Multimap filteredMembers = Multimaps.filterValues((Multimap)this._entityMemberService.getEntityAndInheritedMembersByEntityId(id), EntityMemberWithPerson::isActiveMember);
        return ImmutableSet.copyOf((Collection)filteredMembers.keySet());
    }
}

