/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.allen_sauer.gwt.dnd.client.DragController;
import com.allen_sauer.gwt.dnd.client.PickupDragController;
import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.allen_sauer.gwt.dnd.client.drop.VerticalPanelDropController;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.github.gwtbootstrap.client.ui.ButtonGroup;
import com.github.gwtbootstrap.client.ui.NavHeader;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.jsinterop.Callback;
import de.justsoftware.gwt.user.client.ui.JucoDropdownButton;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.presenter.EditEntityLinkCreator;
import de.justsoftware.onx.container.presentation.client.ui.ComponentConfiguratorWidget;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateOrEditComponentConfiguratorWidget;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditView;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.shared.model.entityedit.ComponentConfigurationEntityEditModel;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityCreateOrEditComponentConfiguratorWidget
extends Composite
implements EntityEditView {
    private static final EntityCreateOrEditComponentConfiguratorWidgetUIBinder UI_BINDER = (EntityCreateOrEditComponentConfiguratorWidgetUIBinder)GWT.create(EntityCreateOrEditComponentConfiguratorWidgetUIBinder.class);
    @UiField
    AbsolutePanel _dragBoundary;
    @UiField
    VerticalPanel _topLeft;
    @UiField
    VerticalPanel _topRight;
    @UiField
    VerticalPanel _center;
    @UiField
    VerticalPanel _bottomLeft;
    @UiField
    VerticalPanel _bottomRight;
    @UiField
    ButtonGroup _submitButtons;
    @UiField
    JCButton _finishButton;
    @UiField
    JCButton _cancelLink;
    @UiField
    WaitSpinner _waitIcon;
    @UiField
    InlineFeedbackWidget _feedbackWidget;
    private final ClientFactory _clientFactory;
    private final PickupDragController _leftDragController;
    private final PickupDragController _rightDragController;
    private final List<ComponentConfiguratorWidget> _componentConfiguratorWidgets = Lists.newArrayList();
    private final EntityConstants _entityConstants;
    private final EntityId _entityId;
    private final JucoDropdownButton _continueButton = new JucoDropdownButton();
    private final Callback<EditEntityHistoryTokenTabName> _submitCallback;

    public EntityCreateOrEditComponentConfiguratorWidget(ClientFactory clientFactory, EntityId entityId, ComponentConfigurationEntityEditModel editModel, Callback<EditEntityHistoryTokenTabName> submitCallback) {
        this._clientFactory = clientFactory;
        this._entityId = entityId;
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)editModel.getEntityType());
        this._submitCallback = submitCallback;
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._cancelLink.setTargetHistoryToken(EntityOverviewHandler.token((EntityId)this._entityId));
        boolean mayMove = editModel.getPermissions().contains((Object)StaticEntityAction.ENTITY_MOVE_COMPONENTS);
        if (mayMove) {
            this._leftDragController = new PickupDragController(this._dragBoundary, false);
            this._rightDragController = new PickupDragController(this._dragBoundary, false);
        } else {
            this._leftDragController = null;
            this._rightDragController = null;
        }
        boolean hasTop = this.addComponents(editModel);
        if (mayMove) {
            this._leftDragController.registerDropController((DropController)new VerticalPanelDropController(this._bottomLeft));
            this._rightDragController.registerDropController((DropController)new VerticalPanelDropController(this._bottomRight));
            if (hasTop) {
                this._leftDragController.registerDropController((DropController)new VerticalPanelDropController(this._topLeft));
                this._rightDragController.registerDropController((DropController)new VerticalPanelDropController(this._topRight));
            }
        }
        this.configureContinueButton(editModel);
    }

    private void configureContinueButton(ComponentConfigurationEntityEditModel editModel) {
        this._continueButton.add((Widget)new NavHeader(this._entityConstants.finishAndContinueTo()));
        this._continueButton.setDropup(true);
        ImmutableMap visibleTabs = FluentIterable.from((Iterable)editModel.getVisibleTabs()).filter(tab -> EditEntityHistoryTokenTabName.SETTINGS != tab).toMap(tab -> e -> this.save(tab));
        if (!visibleTabs.isEmpty()) {
            this.addSaveAndContinueButton(visibleTabs);
        }
    }

    public void addSaveAndContinueButton(ImmutableMap<EditEntityHistoryTokenTabName, ClickHandler> visibleTabs) {
        this._submitButtons.add((Widget)this._continueButton);
        visibleTabs.forEach((tab, clickHandler) -> this._continueButton.add((Widget)EditEntityLinkCreator.createLink((EditEntityHistoryTokenTabName)tab, (ClickHandler)clickHandler, (EntityConstants)this._entityConstants)));
    }

    @UiFactory
    @Nonnull
    public EntityConstants getEntityConstants() {
        return this._entityConstants;
    }

    private void enableSubmit(boolean enabled) {
        this._finishButton.setEnabled(enabled);
        this._continueButton.setEnabled(enabled);
        this._waitIcon.setVisible(!enabled);
    }

    private void save(@Nullable EditEntityHistoryTokenTabName nextTab) {
        this.enableSubmit(false);
        ImmutableList.Builder cs = ImmutableList.builder();
        this.addComponentsForSubmit(cs, (Panel)this._topLeft, ComponentPosition.TOP_LEFT);
        this.addComponentsForSubmit(cs, (Panel)this._topRight, ComponentPosition.TOP_RIGHT);
        this.addComponentsForSubmit(cs, (Panel)this._center, ComponentPosition.CENTER);
        this.addComponentsForSubmit(cs, (Panel)this._bottomLeft, ComponentPosition.BOTTOM_LEFT);
        this.addComponentsForSubmit(cs, (Panel)this._bottomRight, ComponentPosition.BOTTOM_RIGHT);
        EntityMediator.getInstance().setEntityComponentPositions(this._entityId, cs.build(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"_finishButton"})
    void handleCreateAndFinishButton(ClickEvent event) {
        this.save(null);
    }

    private boolean addComponents(ComponentConfigurationEntityEditModel editModel) {
        ImmutableListMultimap indexed = Multimaps.index((Iterable)editModel.getAllowedComponents().values(), (Function)ComponentPositionConfig.POSITION_FUNCTION);
        this.addSortedToPanel((Panel)this._bottomLeft, (DragController)this._leftDragController, indexed.get((Object)ComponentPosition.BOTTOM_LEFT), editModel);
        this.addSortedToPanel((Panel)this._bottomRight, (DragController)this._rightDragController, indexed.get((Object)ComponentPosition.BOTTOM_RIGHT), editModel);
        boolean hasTopLeft = this.addSortedToPanel((Panel)this._topLeft, (DragController)this._leftDragController, indexed.get((Object)ComponentPosition.TOP_LEFT), editModel);
        boolean hasTopRight = this.addSortedToPanel((Panel)this._topRight, (DragController)this._rightDragController, indexed.get((Object)ComponentPosition.TOP_RIGHT), editModel);
        boolean hasCenter = this.addSortedToPanel((Panel)this._center, null, indexed.get((Object)ComponentPosition.CENTER), editModel);
        boolean hasTop = hasCenter || hasTopLeft || hasTopRight;
        return hasTop;
    }

    private void addComponentsForSubmit(ImmutableList.Builder<ComponentPositionConfig> result, Panel p, ComponentPosition pos) {
        int i = 0;
        for (Widget w : p) {
            if (w instanceof ComponentConfiguratorWidget) {
                ComponentConfiguratorWidget cc = (ComponentConfiguratorWidget)w;
                ComponentPositionConfig c = cc.getComponent();
                ImmutableSet availableRoles = ImmutableSet.of();
                List writeAllowedRoles = cc.getOpenFor();
                result.add((Object)new ComponentPositionConfig(c.getType(), pos, i, cc.isComponentVisible(), ImmutableSet.copyOf((Collection)writeAllowedRoles), availableRoles, c.getCustomizedTitle()));
            }
            ++i;
        }
    }

    private boolean addSortedToPanel(Panel p, @Nullable DragController dragCont, @Nullable ImmutableList<? extends ComponentPositionConfig> cs, ComponentConfigurationEntityEditModel entityEditModel) {
        if (CollectionUtil.isEmpty(cs)) {
            return false;
        }
        ImmutableList sorted = Ordering.natural().onResultOf(ComponentPositionConfig.ORDER_FUNCTION).immutableSortedCopy(cs);
        for (ComponentPositionConfig c : sorted) {
            ComponentConfiguratorWidget cc = this._clientFactory.componentFactory().getEntityComponentConfigWidget(c, this._entityId, entityEditModel);
            if (dragCont != null) {
                dragCont.makeDraggable((Widget)cc, cc.getDragHandleMoveIcon());
                dragCont.makeDraggable((Widget)cc, (Widget)cc.getDragHandleHeadLabel());
            }
            cc.showMoveImage(dragCont != null);
            p.add((Widget)cc);
            this._componentConfiguratorWidgets.add(cc);
        }
        return true;
    }

    private void fireSaveEventToComponentConfiguratorWidgets() {
        for (ComponentConfiguratorWidget cc : this._componentConfiguratorWidgets) {
            cc.fireOnSave();
        }
    }
}

