/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.server.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.business.LanguageService;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.presentation.server.JucoLocaleResolver;
import de.justsoftware.onx.common.shared.server.util.CookieUtil;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.common.shared.util.StringUtil;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Lazy(value=false)
@Primary
@ParametersAreNonnullByDefault
public class JucoLocaleResolverImpl
implements JucoLocaleResolver {
    private static final String PERSISTED_LOCALE_COOKIE = "jc_locale";
    private static final String PERSISTED_LOCALE_ATTRIBUTE = "jc_request_locale";
    private final Settings _settings;
    private final LanguageService _languageService;
    private final AcceptHeaderLocaleResolver _delegateResolver;

    @Autowired
    public JucoLocaleResolverImpl(Settings settings, LanguageService languageService) {
        this._settings = settings;
        this._languageService = languageService;
        this._delegateResolver = new AcceptHeaderLocaleResolver();
        List supportedLocales = this._languageService.getAvailableLanguageCode().stream().map(Locale::new).collect(Collectors.toList());
        this._delegateResolver.setSupportedLocales(supportedLocales);
        this._delegateResolver.setDefaultLocale(JucoLocaleResolverImpl.toLocale((String)this._settings.defaultLanguage()));
    }

    @CheckForNull
    private static Locale getCachedLocale() {
        Object attribute;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && (attribute = requestAttributes.getAttribute("jc_request_locale", 0)) instanceof Locale) {
            return (Locale)attribute;
        }
        return null;
    }

    private static void setAsCachedLocale(Locale locale) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            requestAttributes.setAttribute("jc_request_locale", (Object)locale, 0);
        }
    }

    @Nonnull
    private static Locale toLocale(String languageId) {
        return new Locale(languageId);
    }

    @Nonnull
    private Locale getDefaultLocale() {
        return JucoLocaleResolverImpl.toLocale((String)this._settings.defaultLanguage());
    }

    @Nonnull
    private Locale getRequestLocale(HttpServletRequest request) {
        String requestedLocale;
        ImmutableSet availableLanguageCodes = this._languageService.getAvailableLanguageCode();
        if (availableLanguageCodes.contains(requestedLocale = request.getParameter("locale"))) {
            return JucoLocaleResolverImpl.toLocale((String)requestedLocale);
        }
        String cookieValue = this.getCookieValue(request);
        if (cookieValue != null && availableLanguageCodes.contains(cookieValue)) {
            return JucoLocaleResolverImpl.toLocale((String)cookieValue);
        }
        return this._delegateResolver.resolveLocale(request);
    }

    public Locale resolveLocale(HttpServletRequest request) {
        Locale cachedLocale = JucoLocaleResolverImpl.getCachedLocale();
        if (cachedLocale != null) {
            return cachedLocale;
        }
        Locale resolvedLocale = this.getRequestLocale(request);
        JucoLocaleResolverImpl.setAsCachedLocale((Locale)resolvedLocale);
        return resolvedLocale;
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        String languageId = locale != null ? locale.getLanguage() : null;
        Locale newLocale = this._languageService.getAvailableLanguageCode().contains((Object)languageId) ? locale : this.getDefaultLocale();
        JucoLocaleResolverImpl.setAsCachedLocale((Locale)newLocale);
        this.setCookieValue(request, response, newLocale);
    }

    public void setLanguage(HttpServletRequest request, HttpServletResponse response, String languageId) {
        this.setLocale(request, response, languageId != null ? JucoLocaleResolverImpl.toLocale((String)languageId) : null);
    }

    @CheckForNull
    private String getCookieValue(HttpServletRequest request) {
        return CookieUtil.getCookieValueOrNull((String)"jc_locale", (HttpServletRequest)request);
    }

    private void setCookieValue(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        CookieUtil.addCookie((String)"jc_locale", (String)locale.getLanguage(), (int)Numbers.longToInt((long)TimeUnit.DAYS.toSeconds(356L)), (HttpServletRequest)request, (HttpServletResponse)response);
    }

    public String resolveLanguage(HttpServletRequest request) {
        return this.resolveLocale(request).getLanguage();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String cookieValue = this.getCookieValue(request);
        if (StringUtil.isBlank((String)cookieValue)) {
            this.setCookieValue(request, response, this.resolveLocale(request));
        }
        return true;
    }
}

