/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.personpopup;

import com.freiheit.toro.client.Toro;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.ui.personpopup.PersonPopupView;
import de.justsoftware.onx.common.presentation.client.ui.personpopup.PersonPopupViewImpl;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.util.UrlDetector;
import de.justsoftware.onx.components.presentation.client.ui.AnchorPanel;
import de.justsoftware.onx.design.client.util.CssClassUtil;
import de.justsoftware.onx.person.presentation.client.ProfileFieldNameTranslator;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PersonPopupViewImpl
extends Composite
implements PersonPopupView {
    private static final PersonPopupViewUIBinder UI_BINDER = (PersonPopupViewUIBinder)GWT.create(PersonPopupViewUIBinder.class);
    @UiField
    AnchorPanel _imagePanel;
    @UiField
    SimplePanel _title;
    @UiField
    FlowPanel _dynamicAttributes;
    @UiField
    FlowPanel _actions;

    public PersonPopupViewImpl() {
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
    }

    public void setName(PersonTeaserModel personTeaserModel) {
        this._title.setWidget(PersonUtil.profileLink((PersonTeaserModel)personTeaserModel, (ClientFactory)ClientFactoryImpl.INSTANCE, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITHOUT_POPUP));
    }

    public void setImage(PersonTeaserModel person) {
        PersonUtil.addImage((AnchorPanel)this._imagePanel, (PersonTeaserModel)person, (ImageSize)ImageSize.SMALL);
    }

    public void addDynamicAttribute(BadgeField attribute) {
        BadgeField translatedAttribute = ProfileFieldNameTranslator.INSTANCE.translate(attribute);
        Label title = new Label(translatedAttribute.getName());
        title.setStyleName(CssClassUtil.asWellFormedAndNamespaced((String)"label"));
        this._dynamicAttributes.add((Widget)title);
        HTMLPanel value = this.addLinking(translatedAttribute);
        value.addStyleName(CssClassUtil.asWellFormedAndNamespaced((String)"value"));
        this._dynamicAttributes.add((Widget)value);
    }

    @Nonnull
    private HTMLPanel addLinking(BadgeField attribute) {
        return new HTMLPanel(UrlDetector.addAnchorTags((String)attribute.getContent(), null, (UrlDetector.LinkToNewWindow)UrlDetector.LinkToNewWindow.ONLY_ON_FOREIGN_DOMAIN, (String)Toro.getCurrentDomain(), null, (boolean)false));
    }

    public HasWidgets getActionsPanel() {
        return this._actions;
    }

    public void removeActionsPanel() {
        this._actions.removeFromParent();
    }

    public void showActionsPanel() {
        this._actions.setVisible(true);
    }
}

