/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.input;

import com.google.common.collect.Lists;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.input.ValueChangeHandler;
import de.justsoftware.onx.common.presentation.client.ui.input.ValueInputWithInfo;
import de.justsoftware.onx.common.shared.util.StringUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ValueInputImpl<T>
implements ValueInputWithInfo<T> {
    private final IsWidget _container;
    private final Label _errorLabel;
    private final Label _infoLabel;
    private final ValueBoxBase<T> _input;
    private final List<ValueChangeHandler<T>> _changeHanders = Lists.newArrayList();

    public ValueInputImpl(IsWidget container, ValueBoxBase<T> input, Label errorLabel, Label infoLabel) {
        this._container = container;
        this._input = input;
        this._errorLabel = errorLabel;
        this._infoLabel = infoLabel;
        input.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        input.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void callChangeHandlers() {
        this.clearErrors();
        for (ValueChangeHandler h : this._changeHanders) {
            h.onSelect(this.get());
        }
    }

    public T get() {
        return (T)this._input.getValue();
    }

    public void set(T value) {
        this._input.setValue(value);
    }

    public void error(String msg) {
        this._errorLabel.setText(msg);
        this._errorLabel.setVisible(true);
        this._input.setStyleName("error", true);
    }

    public void clearErrors() {
        this._errorLabel.setVisible(false);
        this._input.setStyleName("error", false);
    }

    public void setFocus(boolean focus) {
        this._input.setFocus(true);
    }

    public HandlerRegistration addChangeHandler(ValueChangeHandler<T> handler) {
        this._changeHanders.add(handler);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setVisible(boolean visible) {
        this._input.setVisible(visible);
        this._errorLabel.setVisible(visible);
    }

    public Widget asWidget() {
        return this._container.asWidget();
    }

    public void setEnabled(boolean enabled) {
        this._input.setEnabled(enabled);
    }

    public void setInfoText(String text) {
        if (StringUtil.isEmpty((String)text)) {
            this._infoLabel.setVisible(false);
        }
        this._infoLabel.setText(text);
        this._infoLabel.setVisible(true);
    }
}

