/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.form.impl;

import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.presentation.client.ui.form.DynamicAttributeInputView;
import de.justsoftware.onx.design.client.util.CssClassUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractInputView<T extends Widget, R>
implements DynamicAttributeInputView<R> {
    private static final ImmutableList<String> WIDTH_CLASSES = ImmutableList.of((Object)CssClassUtil.asWellFormedAndNamespaced((String)"full-width"), (Object)CssClassUtil.asWellFormedAndNamespaced((String)"full-width-one-icon"), (Object)CssClassUtil.asWellFormedAndNamespaced((String)"full-width-two-icon"));
    protected final T _inputWidget;
    private final FlowPanel _controls;
    private final HelpInline _helpMessage;
    private final JCIconOnlyAnchor _add;
    private final JCIconOnlyAnchor _delete;
    private DynamicAttributeInputView.Presenter<R> _presenter;

    public AbstractInputView(@Nullable DynamicAttributeInputView.Presenter<R> presenter, @Nonnull T inputWidget) {
        this._inputWidget = inputWidget;
        this._controls = new FlowPanel();
        this._controls.addStyleName("input-append");
        this._presenter = presenter;
        this._inputWidget.getElement().setId(HTMLPanel.createUniqueId());
        this._controls.add(this._inputWidget);
        this._helpMessage = new HelpInline();
        this._helpMessage.addStyleName("help-message");
        this._helpMessage.setVisible(false);
        this._delete = new JCIconOnlyAnchor();
        this._delete.setIcon(IconType.TRASH);
        this._delete.setIconSize(IconSize.LARGE);
        this._delete.addStyleName("add-on");
        this._add = new JCIconOnlyAnchor();
        this._add.setIcon(IconType.PLUS);
        this._add.setIconSize(IconSize.LARGE);
        this._add.addStyleName("add-on");
        this._controls.add((Widget)this._delete);
        this._controls.add((Widget)this._add);
        this.updateWidthClassOfInput();
        this._controls.add((Widget)this._helpMessage);
        if (presenter != null) {
            this.setPresenter(presenter);
        }
    }

    public void setPresenter(DynamicAttributeInputView.Presenter<R> presenter) {
        this._presenter = presenter;
        this._delete.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._add.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setErrorMessage(String errorMessage) {
        this._helpMessage.setText(errorMessage);
        if (!Strings.isNullOrEmpty((String)errorMessage)) {
            this._helpMessage.setVisible(true);
        }
    }

    public void clearErrorMessage() {
        this._helpMessage.setText(null);
        this._helpMessage.setVisible(false);
    }

    public void setAddSignVisible(boolean visible) {
        this._add.setVisible(visible);
        this.updateWidthClassOfInput();
    }

    protected void setDeleteSignVisible(boolean visible) {
        this._delete.setVisible(visible);
        this.updateWidthClassOfInput();
    }

    protected void addToControls(@Nonnull IsWidget childControl) {
        this._controls.add(childControl);
    }

    public void removeFromParent() {
        this._controls.removeFromParent();
    }

    public Widget getAsControls() {
        return this._controls;
    }

    private void updateWidthClassOfInput() {
        int icons = 0;
        if (this._add.isVisible()) {
            ++icons;
        }
        if (this._delete.isVisible()) {
            ++icons;
        }
        for (String style : WIDTH_CLASSES) {
            this.setInputStyleName(style, false);
        }
        this.setInputStyleName((String)WIDTH_CLASSES.get(icons), true);
    }

    protected void setInputStyleName(@Nonnull String styleName, boolean add) {
        this._inputWidget.setStyleName(styleName, add);
    }
}

