/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.editor.impl;

import com.freiheit.toro.util.client.JavascriptUtil;
import com.freiheit.toro.util.client.LoggingUtil;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.gwt.ckeditor.CKEditor;
import de.justsoftware.onx.album.presentation.client.AlbumMediator;
import de.justsoftware.onx.album.presentation.client.ui.ImageEditPopup;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.editor.JustEditorPluginHandler;
import de.justsoftware.onx.common.presentation.client.ui.selectLink.SelectLinkMediator;
import de.justsoftware.onx.common.shared.model.JCMediaContentId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JustEditorPluginHandlerImpl
implements JustEditorPluginHandler {
    private final GlobalId _editorParentId;
    private int _editorWidth;
    private final ClientFactory _clientFactory;
    private final String _entityId;
    private final JCMediaContentId.Visitor<String> _contentIdTokenizer;

    public JustEditorPluginHandlerImpl(ClientFactory clientFactory, GlobalId parentId) {
        this._clientFactory = clientFactory;
        this._editorParentId = parentId;
        EntityId currentEntityId = clientFactory.entityFactory().getCurrentEntityId();
        this._entityId = currentEntityId != null ? currentEntityId.asString() : "";
        this._contentIdTokenizer = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void openPicSelectPopup(String src, String width, String height, String hspace, String vspace, String border, String align, String alt, JavaScriptObject insertPicCallback, JavaScriptObject cancelCallback) {
        if (src == null) {
            AlbumMediator.getInstance().getNoModuleAlbumByParentId(this._editorParentId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            LoggingUtil.info((Object)this, (String)("openPicSelectPopup: existing Image " + src));
            new ImageEditPopup(this._editorWidth, src, width, height, hspace, vspace, border, align, alt, (ImageEditPopup.ImageEditCallback)new /* Unavailable Anonymous Inner Class!! */).show();
        }
    }

    private void setSizeAttributes(int orgWidth, int orgHeight, JavaScriptObject attributes) {
        if (orgWidth > this._editorWidth) {
            int newHeight = this._editorWidth * orgHeight / orgWidth;
            JavascriptUtil.setProperty((JavaScriptObject)attributes, (String)"width", (String)("" + this._editorWidth));
            JavascriptUtil.setProperty((JavaScriptObject)attributes, (String)"height", (String)("" + newHeight));
        }
    }

    public void openLinkSelectPopup(String oldHref, JsArrayString anchors, JavaScriptObject linkCallback, JavaScriptObject cancelCallback) {
        ArrayList<String> anchorList = new ArrayList<String>();
        for (int i = 0; i < anchors.length(); ++i) {
            if (anchors.get(i).trim().equals("")) continue;
            anchorList.add(anchors.get(i));
        }
        SelectLinkMediator.getInstance().showLinkPopup(this._clientFactory, null, oldHref, anchorList, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */, (Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void bindToEditor(CKEditor editor, int width) {
        this._editorWidth = width;
        this.setupApi(editor, this);
    }

    @CheckForNull
    private String tokenizeContentId(String id) {
        ItemId typedId;
        try {
            typedId = ItemId.parse((String)id);
        }
        catch (IdParseException ex) {
            return null;
        }
        if (typedId instanceof JCMediaContentId) {
            return (String)((JCMediaContentId)typedId).accept(this._contentIdTokenizer);
        }
        return null;
    }

    private native void setupApi(CKEditor var1, JustEditorPluginHandlerImpl var2);
}

