/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.Validatable;
import com.freiheit.toro.common.shared.i18n.BasicMessages;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.CompositePanelWithValue;
import de.justsoftware.onx.common.shared.model.TimeZone;

public class TimeZoneListBox
extends CompositePanelWithValue<TimeZone>
implements Validatable {
    protected static final BasicMessages BASIC_MESSAGES = I18nMediator.BASIC_MESSAGES;
    private static final String NO_SELECTION_NAME = "---";
    private static final String NO_SELECTION_VALUE = "-1";
    private final ListBox _listBox;
    private boolean _mandatory;
    private String _fieldName;

    public TimeZoneListBox() {
        this("");
    }

    public TimeZoneListBox(String fieldname) {
        this(fieldname, false);
    }

    public TimeZoneListBox(String fieldname, boolean mandatory) {
        this._fieldName = fieldname;
        this._mandatory = mandatory;
        this._listBox = new ListBox();
        this.add((Widget)this._listBox);
        this._listBox.addItem(NO_SELECTION_NAME, NO_SELECTION_VALUE);
        for (TimeZone tz : TimeZone.values()) {
            this._listBox.addItem(tz.getDisplayString(), tz.name());
        }
        this._listBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void validate() throws ValidationException {
        if (this._mandatory && this.getValue() == null) {
            throw new ValidationException(BASIC_MESSAGES.fillFieldx(this._fieldName));
        }
    }

    public boolean isMandatory() {
        return this._mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this._mandatory = mandatory;
    }

    public void setValue(TimeZone value, boolean fireEvents) {
        String stringValue = value != null ? value.name() : NO_SELECTION_VALUE;
        for (int i = 0; i < this._listBox.getItemCount(); ++i) {
            if (!stringValue.equals(this._listBox.getValue(i))) continue;
            this._listBox.setSelectedIndex(i);
        }
        super.setValue((Object)value, fireEvents);
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public void setFieldName(String fieldName) {
        this._fieldName = fieldName;
    }
}

