/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCModalBox;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JCModalBox {
    private final DialogBox _dialogBox = new DialogBox(false, true);
    private final Panel _header = new FlowPanel();
    private final Label _title = new Label();
    private final Label _closeIcon = new Label("\u00d7");
    private final Panel _error = new FlowPanel();
    private final Panel _content = new FlowPanel();
    private final Panel _footer = new FlowPanel();
    private final FlowPanel _progressIndicator = new FlowPanel();
    private final List<CloseHandler> _closeHandlers = new LinkedList();

    public JCModalBox(String title) {
        FlowPanel container = new FlowPanel();
        this._progressIndicator.add((Widget)new WaitSpinner(IconSize.FOUR_TIMES));
        this._progressIndicator.addStyleName("progress-indicator");
        this._progressIndicator.setVisible(false);
        this._dialogBox.setGlassEnabled(true);
        this._title.setText(title);
        this._header.add((Widget)this._closeIcon);
        this._header.add((Widget)this._title);
        container.add((Widget)this._header);
        container.add((Widget)this._error);
        container.add((Widget)this._content);
        this._footer.addStyleName("jc-modal-footer");
        container.add((Widget)this._footer);
        container.add((Widget)this._progressIndicator);
        this._dialogBox.add((Widget)container);
        this._dialogBox.addStyleName("jc-modal-box");
        this._closeIcon.addStyleName("jc-modal-close");
        this._title.addStyleName("jc-modal-title");
        this._closeIcon.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void onClose() {
        for (CloseHandler h : this._closeHandlers) {
            h.onClose();
        }
        this.hide();
    }

    public void addCloseHandler(CloseHandler handler) {
        this._closeHandlers.add(handler);
    }

    public void hide() {
        this._dialogBox.hide();
    }

    public void show() {
        this._dialogBox.center();
    }

    @Nonnull
    public Panel getContent() {
        return this._content;
    }

    @Nonnull
    public Panel getFooter() {
        return this._footer;
    }

    public void showProgressIndicator(boolean visible) {
        this._progressIndicator.setVisible(visible);
    }

    public void error(String message) {
        Label errorLabel = new Label(message);
        errorLabel.addStyleName("error-message");
        errorLabel.addStyleName("general-error-message");
        this._error.add((Widget)errorLabel);
    }

    public void clearErrors() {
        this._error.clear();
    }

    public void addCancelLink(String label) {
        Anchor cancelLink = new Anchor(label);
        cancelLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._footer.add((Widget)cancelLink);
    }
}

