/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.ControlLabel;
import com.github.gwtbootstrap.client.ui.Controls;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.ReviewerSelectionView;
import de.justsoftware.onx.container.presentation.shared.EntityVersionControllerAsync;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class AbstractReviewerSelectionView
extends ControlGroup
implements ReviewerSelectionView {
    private static final String ERROR_CLASS = "error";
    private static final String ICON_STYLE = "icon";
    protected final EntityVersionConstants _versionMessages;
    protected final EntityId _entityId;
    protected final HelpInline _inlineHelp;
    protected final ReviewerSelectionView.Presenter _presenter;
    protected final EntityVersionControllerAsync _controller;
    protected int _reviewStage = 0;
    @CheckForNull
    protected PersonTeaserModel _defaultSelection;
    private final Widget _add;
    private final Widget _remove;
    private final ControlLabel _reviewerPositionLabel;

    public AbstractReviewerSelectionView(@Nonnull ReviewerSelectionView.Presenter presenter, @Nonnull ClientFactory clientFactory, @Nonnull EntityId entityId, int reviewStage) {
        this._presenter = presenter;
        this._entityId = entityId;
        this._controller = clientFactory.entityVersionFactory().controller();
        this._versionMessages = I18nMediator.LOCALIZED_MESSAGES.entityVersionConstants();
        this._reviewStage = reviewStage;
        this._reviewerPositionLabel = new ControlLabel();
        int reviewerPosition = this._reviewStage + 1;
        this._reviewerPositionLabel.getElement().setInnerText(this._versionMessages.reviewer(reviewerPosition));
        this.add((Widget)this._reviewerPositionLabel);
        Controls controls = new Controls();
        this._add = this.createAddAnchor();
        this._add.setVisible(false);
        this._remove = this.createRemoveAnchor();
        this._remove.setVisible(false);
        this._inlineHelp = new HelpInline();
        controls.add(this.createPersonSelector());
        controls.add(this._remove);
        controls.add(this._add);
        controls.add((Widget)this._inlineHelp);
        this.add((Widget)controls);
    }

    @Nonnull
    protected abstract Widget createPersonSelector();

    public void setAddButtonVisible(boolean visible) {
        this._add.setVisible(visible);
    }

    public void setRemoveButtonVisible(boolean visible) {
        this._remove.setVisible(visible);
    }

    public void remove() {
        this.removeFromParent();
    }

    protected int getReviewStage() {
        return this._reviewStage;
    }

    @Nonnull
    private Widget createAddAnchor() {
        Anchor addReviewer = new Anchor();
        addReviewer.addStyleName(ICON_STYLE);
        addReviewer.setTitle(this._versionMessages.addReviewer());
        addReviewer.getElement().insertFirst((Node)new Icon(IconType.PLUS).getElement());
        addReviewer.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return addReviewer;
    }

    @Nonnull
    private Widget createRemoveAnchor() {
        Anchor removeButton = new Anchor();
        removeButton.getElement().insertFirst((Node)new Icon(IconType.MINUS).getElement());
        removeButton.addStyleName(ICON_STYLE);
        removeButton.setTitle(this._versionMessages.removeReviewer());
        removeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return removeButton;
    }

    public void setHelpMessage(String helpMessage) {
        this._inlineHelp.setText(helpMessage);
    }

    public void setErrorState(boolean inError) {
        if (inError) {
            this.getElement().addClassName(ERROR_CLASS);
        } else {
            this.getElement().removeClassName(ERROR_CLASS);
        }
    }

    public void setDefaultSelection(PersonTeaserModel defaultSelection) {
        this._defaultSelection = defaultSelection;
    }
}

