/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.FrontendLoginService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.security.service.MobileLogoutService;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FrontendLoginServiceImpl
implements FrontendLoginService {
    private static final Logger LOG = LoggerFactory.getLogger(FrontendLoginServiceImpl.class);
    private final MobileLogoutService _mobileLogoutService;

    @Autowired
    @ParametersAreNonnullByDefault
    public FrontendLoginServiceImpl(MobileLogoutService mobileLogoutService) {
        this._mobileLogoutService = mobileLogoutService;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.logout();
        }
        catch (ServletException e) {
            LOG.error("error occurred while logging out", (Throwable)e);
        }
    }

    public void loggedOutFromAllMobileDevices(PersonId personId, AuthorizationCheckContext authContext) throws ServiceException {
        authContext.check((ItemId)personId.asProfileId(), (Action)StaticAction.PROFILE_MODIFY_ACCOUNT_SETTINGS);
        this._mobileLogoutService.logoutFromMobileDevices(personId);
    }
}

