/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.freiheit.toro.common.shared.i18n.AlbumConstants;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.album.presentation.client.AlbumMediator;
import de.justsoftware.onx.album.presentation.client.ui.ImageOverlay;
import de.justsoftware.onx.album.shared.model.AlbumImage;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.InPlaceEditLabel;
import de.justsoftware.onx.common.presentation.client.ui.overlay.ContentDetailsTypeSpecificWidget;
import de.justsoftware.onx.common.presentation.client.ui.overlay.ContentDetailsWidget;
import de.justsoftware.onx.common.presentation.client.ui.overlay.ContentOverlay;
import de.justsoftware.onx.common.presentation.client.ui.overlay.ContentOverlayDescriptor;
import de.justsoftware.onx.common.presentation.client.ui.overlay.EditableContentDetailsTypeSpecificWidget;
import de.justsoftware.onx.common.presentation.client.ui.overlay.LoadContentOverlayAsyncCallback;
import de.justsoftware.onx.common.presentation.shared.model.ContentOverlayParent;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.JCMediaContent;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.GlobalId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ImageOverlay
implements ContentOverlayDescriptor<AlbumImageId, AlbumImage> {
    private static final BasicConstants BASIC_CONSTANTS = I18nMediator.BASIC_CONSTANTS;
    private static final AlbumConstants ALBUM_CONSTANTS = I18nMediator.ALBUM;
    @CheckForNull
    private OverlayImage _imageWidget = null;
    private final EventManager _eventManager;
    private final PageTitleCallback _titleCallback;
    private final DateFormatter _dateFormatter;

    public ImageOverlay(EventManager eventManager, DateFormatter dateFormatter, PageTitleCallback titleCallback) {
        this._eventManager = eventManager;
        this._dateFormatter = dateFormatter;
        this._titleCallback = titleCallback;
    }

    public void load(AlbumImageId imageId, ContentOverlayParent contentOverlayParent, LoadContentOverlayAsyncCallback<AlbumImage> callback) {
        AlbumMediator.getInstance().getImageById(imageId, contentOverlayParent, callback);
    }

    public void initOverlay(ContentOverlay contentOverlay, AlbumImage image) {
        String imageTitle = image.getTitle();
        String pageTitle = Strings.isNullOrEmpty((String)imageTitle) ? ALBUM_CONSTANTS.picture() + ": " + BASIC_CONSTANTS.noTitle() : imageTitle;
        this._titleCallback.setPageTitle(pageTitle);
        contentOverlay.updateTitle(imageTitle);
        contentOverlay.setParentId((GlobalId)image.getId(), (GlobalId)image.getAlbumId());
        1 onTitleChangeHandler = new /* Unavailable Anonymous Inner Class!! */;
        boolean titleEditable = image.getMay().contains((Object)StaticAction.ALBUM_UPDATE);
        InPlaceEditLabel titleLabel = new InPlaceEditLabel(imageTitle, ALBUM_CONSTANTS.title(), BASIC_CONSTANTS.noTitle());
        titleLabel.setEditable(titleEditable);
        titleLabel.setMaxLength(255);
        titleLabel.addValueChangeHandler((ValueChangeHandler)onTitleChangeHandler);
        ContentDetailsWidget detailsWidget = contentOverlay.createDetailsWidget((JCMediaContent)image, titleLabel, ContentDetailsWidget.OnSave.NOOP, new EditableContentDetailsTypeSpecificWidget(), (Widget)this.createInfoWidget(image));
        this.addOptions(contentOverlay, image, detailsWidget);
        this._imageWidget = new OverlayImage(contentOverlay, image);
        contentOverlay.setContentWidget((Widget)this._imageWidget);
    }

    private void addOptions(ContentOverlay contentOverlay, AlbumImage image, ContentDetailsWidget<AlbumImage> detailsWidget) {
        ImmutableSet allowedActions = image.getMay();
        if (allowedActions.contains((Object)StaticAction.ALBUM_DELETE)) {
            detailsWidget.addOptionsLink(IconType.TRASH, I18nMediator.ALBUM.deleteImage(), (ClickHandler)new DeleteLinkClickHandler(contentOverlay, image, this._eventManager));
        }
    }

    @Nonnull
    private ContentDetailsTypeSpecificWidget createInfoWidget(AlbumImage content) {
        ContentDetailsTypeSpecificWidget detailsWidget = new ContentDetailsTypeSpecificWidget();
        detailsWidget.addRow((IsWidget)new Label(this._dateFormatter.formatDateTime(content.getCreateDate())));
        return detailsWidget;
    }

    public void onToggleInfoAreaVisibility() {
        if (this._imageWidget != null) {
            this._imageWidget.recalcImageSize();
        }
    }
}

