/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.common.shared.i18n.AlbumConstants;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.album.presentation.client.ui.AlbumOverviewHandler;
import de.justsoftware.onx.album.shared.model.Album;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.ui.BadgeWidgetBase;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;

public class AlbumBadgeWidget
extends BadgeWidgetBase {
    private static final AlbumConstants ALBUM = I18nMediator.ALBUM;

    public AlbumBadgeWidget(Album album, boolean first, boolean last) {
        super(first, last);
        String token = AlbumOverviewHandler.token((AlbumId)album.getId());
        String filename = album.getAlbumImage() == null ? null : album.getAlbumImage().getFilename();
        Image image = new Image(ImageUrlUtil.getFullAlbumImageUrl((ImageSize)ImageSize.SMALL, (String)filename));
        image.addStyleName("clickable");
        image.addClickHandler(ClientFactoryImpl.INSTANCE.historyManager().createNewItemHandler(token));
        this.setImage((Widget)image);
        this.addDetailsRow(ALBUM.albumName() + ":", (Widget)new Hyperlink(album.getTitle(), token));
        if (!StringUtil.isBlank((String)album.getDescription())) {
            this.addDetailsRow(ALBUM.albumDescription() + ":", album.getDescription());
        }
        if (!StringUtil.isBlank((String)album.getLocation())) {
            this.addDetailsRow(ALBUM.albumLocation() + ":", album.getLocation());
        }
        this.addDetailsRow(ALBUM.photos() + ":", "" + album.getImageCount());
        if (album.getOwner() != null) {
            this.addDetailsRow(ALBUM.authorAlbum() + ":", PersonUtil.profileLink((PersonTeaserModel)album.getOwner(), (ClientFactory)ClientFactoryImpl.INSTANCE, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITH_POPUP));
        }
    }
}

