/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.presentation.client;

import com.freiheit.toro.client.mediator.HistoryItemHandler;
import com.freiheit.toro.client.mediator.Mediated;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.album.presentation.client.AlbumMediatorInterface;
import de.justsoftware.onx.album.presentation.client.ui.AlbumOverviewWidget;
import de.justsoftware.onx.album.presentation.client.ui.AlbumWidget;
import de.justsoftware.onx.album.presentation.client.ui.AlbumsOverviewWidget;
import de.justsoftware.onx.album.presentation.client.ui.ImageOverlay;
import de.justsoftware.onx.album.presentation.client.ui.ImageSelectWidget;
import de.justsoftware.onx.album.presentation.client.ui.NewAlbumPopup;
import de.justsoftware.onx.album.presentation.shared.AlbumRemoteService;
import de.justsoftware.onx.album.presentation.shared.AlbumRemoteServiceAsync;
import de.justsoftware.onx.album.shared.model.Album;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImage;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.Albums;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.PlaceHolder;
import de.justsoftware.onx.common.presentation.client.ui.overlay.ContentOverlayDescriptor;
import de.justsoftware.onx.common.presentation.shared.model.ContentOverlayObject;
import de.justsoftware.onx.common.presentation.shared.model.ContentOverlayParent;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.JCMediaContentId;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.container.shared.model.GlobalId;
import java.util.List;

public class AlbumMediatorImpl
implements AlbumMediatorInterface {
    private final AlbumRemoteServiceAsync _controller = (AlbumRemoteServiceAsync)GWT.create(AlbumRemoteService.class);

    AlbumMediatorImpl() {
        UrlUtil.setRemoteServiceUrl((Object)this._controller, (String)"/mdlalbum");
    }

    public void insertAlbum(DBAlbum album, AsyncCallback<AlbumId> callback) {
        this._controller.insertAlbum(album, callback);
    }

    public void getAlbumById(AlbumId albumId, AsyncCallback<Album> callback) {
        this._controller.getAlbumById(albumId, callback);
    }

    public void getAlbumListByParentId(GlobalId itemId, int offset, int limit, AsyncCallback<ListAndCount<Album>> callback) {
        this._controller.getAlbumListByParentId(itemId, offset, limit, callback);
    }

    public void getAlbumsByParentId(GlobalId itemId, AsyncCallback<Albums> callback) {
        this._controller.getAlbumsByParentId(itemId, callback);
    }

    public void getImageById(AlbumImageId imageId, ContentOverlayParent contentOverlayParent, AsyncCallback<ContentOverlayObject<AlbumImage>> callback) {
        this._controller.getImageById(imageId, contentOverlayParent, callback);
    }

    public void getImageListByAlbumId(AlbumId albumId, int offset, int limit, AsyncCallback<ListAndCount<AlbumImage>> callback) {
        this._controller.getImageListByAlbumId(albumId, offset, limit, callback);
    }

    public void updateImageTitle(AlbumImageId imageId, String title, AsyncCallback<Void> callback) {
        this._controller.updateImageTitle(imageId, title, callback);
    }

    public void deleteImage(AlbumImageId imageId, AsyncCallback<Void> callback) {
        this._controller.deleteImage(imageId, callback);
    }

    public void deleteAlbum(AlbumId albumId, AsyncCallback<Void> callback) {
        this._controller.deleteAlbum(albumId, callback);
    }

    public void deleteImages(List<AlbumImageId> imageIds, AsyncCallback<Void> callback) {
        this._controller.deleteImages(imageIds, callback);
    }

    public void updateAlbumTitle(AlbumId id, String title, AsyncCallback<Void> callback) {
        this._controller.updateAlbumTitle(id, title, callback);
    }

    public void updateAlbumLocation(AlbumId id, String location, AsyncCallback<Void> callback) {
        this._controller.updateAlbumLocation(id, location, callback);
    }

    public void updateAlbumDescription(AlbumId id, String description, AsyncCallback<Void> callback) {
        this._controller.updateAlbumDescription(id, description, callback);
    }

    public void getPostitionOfImage(AlbumImageId imageId, AsyncCallback<Integer> callback) {
        this._controller.getPostitionOfImage(imageId, callback);
    }

    public void getNoModuleAlbumByParentId(GlobalId parentId, AsyncCallback<Album> callback) {
        this._controller.getNoModuleAlbumByParentId(parentId, callback);
    }

    public void createAlbumsOverviewWidget(GlobalId parentId, HistoryItemHandler.WidgetCreatedCallback callback, ClientFactory clientFactory) {
        callback.onWidgetCreated((IsWidget)new AlbumsOverviewWidget(parentId, true, clientFactory));
    }

    public void createAlbumOverviewWidget(AlbumId albumId, boolean showUpload, HistoryItemHandler.WidgetCreatedCallback callback, ClientFactory clientFactory, PageTitleCallback titleCallback) {
        callback.onWidgetCreated((IsWidget)new AlbumOverviewWidget(albumId, showUpload, titleCallback, clientFactory));
    }

    public void createImageOverlay(AlbumImageId imageId, HistoryItemHandler.WidgetCreatedCallback callback, EventManager eventManager, DateFormatter dateFormatter, PageTitleCallback titleCallback) {
        callback.onOverlayCreated((JCMediaContentId)imageId, ContentOverlayParent.DEFAULT, (ContentOverlayDescriptor)new ImageOverlay(eventManager, dateFormatter, titleCallback));
    }

    public void showNewAlbumPopup(GlobalId parentId) {
        new NewAlbumPopup(parentId).center();
    }

    public void createImageSelectWidget(AlbumId albumId, AlbumWidget.ImageClickCallback clickHandler, Mediated updateListener, PlaceHolder placeHolder, AlbumWidget.CancelClickHandler cancelClickHandler, EventManager eventManager) {
        ImageSelectWidget w = new ImageSelectWidget(albumId, clickHandler, cancelClickHandler, eventManager);
        w.setUpdateListener(updateListener);
        placeHolder.replace((IsWidget)w);
    }
}

