/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.administration.presentation.client.ui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.administration.presentation.client.ui.AdministrationView;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AdministrationViewImpl
extends Composite
implements AdministrationView {
    private final TabPanel _tabPanel = new TabPanel();
    private final BiMap<AdministrationView.AdministrationTab, Integer> _tabIndexMap = HashBiMap.create();

    public AdministrationViewImpl(AdministrationView.AdministrationPresenter presenter) {
        this._tabPanel.addStyleName("administration");
        this._tabPanel.getTabBar().setWidth("auto");
        this.initWidget((Widget)this._tabPanel);
        this._tabPanel.addSelectionHandler(event -> {
            AdministrationView.AdministrationTab selectedTab = (AdministrationView.AdministrationTab)this._tabIndexMap.inverse().get(event.getSelectedItem());
            if (selectedTab != null) {
                presenter.onTabSelected(selectedTab);
            }
        });
    }

    public void addTab(AdministrationView.AdministrationTab tab, Widget widget, String name) {
        if (this._tabIndexMap.containsKey((Object)tab)) {
            throw new IllegalArgumentException("Tab " + tab + " already added!");
        }
        Label tabLabel = new Label(name);
        tabLabel.addStyleName("app-hover-color");
        tabLabel.addStyleName("app-border-color");
        this._tabPanel.add(widget, (Widget)tabLabel);
        this._tabIndexMap.put((Object)tab, (Object)(this._tabPanel.getWidgetCount() - 1));
        if (this._tabPanel.getTabBar().getSelectedTab() < 0) {
            this._tabPanel.selectTab(0, false);
        }
    }

    public void selectTab(AdministrationView.AdministrationTab tab) {
        Integer index = (Integer)this._tabIndexMap.get((Object)tab);
        if (index == null) {
            throw new IllegalArgumentException("Tab " + tab + " does not exists!");
        }
        if (this._tabPanel.getTabBar().getTabCount() > index) {
            this._tabPanel.selectTab(index.intValue());
        }
    }

    public void addTabPanelStyleName(String styleName) {
        this._tabPanel.addStyleName(styleName);
    }
}

