/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.auth;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.onx.authorization.business.FrontendLoginService;
import de.justsoftware.onx.security.service.JustAuthenticationProvider;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@ParametersAreNonnullByDefault
public class ToroJwtProcessingFilter
extends JwtAuthenticationProcessingFilter {
    private final JustAuthenticationProvider _jwtTokenAuthenticationProvider;
    private final FrontendLoginService _frontEndloginService;

    ToroJwtProcessingFilter(JwtVerifier verifier, JustAuthenticationProvider jwtTokenAuthenticationProvider, FrontendLoginService frontEndloginService) {
        super(verifier);
        this._jwtTokenAuthenticationProvider = jwtTokenAuthenticationProvider;
        this._frontEndloginService = frontEndloginService;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        FilterChain noOpFilterChain = (rq, rs) -> {};
        super.doFilter(req, res, noOpFilterChain);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof JwtAuthenticationToken) {
            try {
                SecurityContextHolder.getContext().setAuthentication(this._jwtTokenAuthenticationProvider.authenticate(authentication));
            }
            catch (DisabledException | LockedException e) {
                this._frontEndloginService.logout((HttpServletRequest)req, (HttpServletResponse)res);
            }
        }
        chain.doFilter(req, res);
    }
}

