/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.wiki.service;

import de.justsoftware.mobile.gateway.util.ListsKt;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.SubscriptionFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiArticleFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiChapterFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiFragment;
import de.justsoftware.mobile.gateway.wiki.model.SubscribedWikiItem;
import de.justsoftware.mobile.gateway.wiki.model.Subscription;
import de.justsoftware.mobile.gateway.wiki.model.Wiki;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticle;
import de.justsoftware.mobile.gateway.wiki.model.WikiChapter;
import de.justsoftware.mobile.gateway.wiki.model.WikiTeaser;
import de.justsoftware.mobile.gateway.wiki.service.WikiApiGatewayService;
import de.justsoftware.mobile.gateway.wiki.service.WikiService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/mobile/gateway/wiki/service/WikiService;", "", "wikiApiGatewayService", "Lde/justsoftware/mobile/gateway/wiki/service/WikiApiGatewayService;", "<init>", "(Lde/justsoftware/mobile/gateway/wiki/service/WikiApiGatewayService;)V", "getWikiTeasers", "", "Lde/justsoftware/mobile/gateway/wiki/model/WikiTeaser;", "offset", "", "limit", "getSubscribedWikiItems", "Lde/justsoftware/mobile/gateway/wiki/model/SubscribedWikiItem;", "getWiki", "Lde/justsoftware/mobile/gateway/wiki/model/Wiki;", "wikiId", "", "subscribe", "Lde/justsoftware/mobile/gateway/wiki/model/Subscription;", "unsubscribe", "getWikiChapter", "Lde/justsoftware/mobile/gateway/wiki/model/WikiChapter;", "chapterId", "getWikiArticle", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticle;", "articleId", "Companion", "mobile-gateway"})
public class WikiService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WikiApiGatewayService wikiApiGatewayService;
    private static final int WIKI_MAX_SIZE = 200;

    public WikiService(@NotNull WikiApiGatewayService wikiApiGatewayService) {
        Intrinsics.checkNotNullParameter((Object)wikiApiGatewayService, (String)"wikiApiGatewayService");
        this.wikiApiGatewayService = wikiApiGatewayService;
    }

    @NotNull
    public List<WikiTeaser> getWikiTeasers(int offset, int limit) {
        return ListsKt.page((List)WikiTeaser.Companion.sort(WikiTeaser.Companion.toWikiTeasers(this.wikiApiGatewayService.getWikiTeasers(200))), (int)offset, (int)limit);
    }

    @NotNull
    public List<SubscribedWikiItem> getSubscribedWikiItems(int offset, int limit) {
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @Nullable
    public Wiki getWiki(@NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        WikiFragment wikiFragment = this.wikiApiGatewayService.getWiki(wikiId);
        return wikiFragment != null ? Wiki.Companion.toWiki(wikiFragment) : null;
    }

    @Nullable
    public Subscription subscribe(@NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        SubscriptionFragment subscriptionFragment = this.wikiApiGatewayService.subscribe(wikiId);
        return subscriptionFragment != null ? Subscription.Companion.toSubscription(subscriptionFragment) : null;
    }

    @Nullable
    public Subscription unsubscribe(@NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        SubscriptionFragment subscriptionFragment = this.wikiApiGatewayService.unsubscribe(wikiId);
        return subscriptionFragment != null ? Subscription.Companion.toSubscription(subscriptionFragment) : null;
    }

    @Nullable
    public WikiChapter getWikiChapter(@NotNull String chapterId) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        WikiChapterFragment wikiChapterFragment = this.wikiApiGatewayService.getWikiChapter(chapterId);
        return wikiChapterFragment != null ? WikiChapter.Companion.toWikiChapter(wikiChapterFragment) : null;
    }

    @Nullable
    public WikiArticle getWikiArticle(@NotNull String articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        WikiArticleFragment wikiArticleFragment = this.wikiApiGatewayService.getWikiArticle(articleId);
        return wikiArticleFragment != null ? WikiArticle.Companion.toWikiArticle(wikiArticleFragment) : null;
    }

    public static final /* synthetic */ WikiApiGatewayService access$getWikiApiGatewayService$p(WikiService $this) {
        return $this.wikiApiGatewayService;
    }
}

