/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfile;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfileSearchResults;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfiles;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroup;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroupDetails;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroups;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getProfiles$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getUserGroup$;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\"\u0010\u0014\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0012J\"\u0010\u0016\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0012J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0003H\u0012J \u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;", "", "peopleApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "getProfiles", "", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiProfile;", "query", "offset", "", "limit", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiUserGroup;", "getUserGroup", "groupId", "getUserGroupMembers", "profilesUri", "Ljava/net/URI;", "userGroupsUri", "userGroupDetailsUri", "userGroupMembersUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nPeopleApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeopleApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n+ 3 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt\n+ 4 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt$buildUri$1\n*L\n1#1,111:1\n28#2:112\n28#2:113\n28#2:114\n28#2:115\n11#3:116\n11#3:117\n7#3,5:118\n11#3:124\n9#4:123\n*S KotlinDebug\n*F\n+ 1 PeopleApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService\n*L\n31#1:112\n46#1:113\n57#1:114\n66#1:115\n79#1:116\n91#1:117\n100#1:118,5\n106#1:124\n100#1:123\n*E\n"})
public class PeopleApiGatewayService {
    @NotNull
    private final String peopleApiUrl;
    @NotNull
    private final WebClient webClient;

    public PeopleApiGatewayService(@Value(value="${just.people.api.url}") @NotNull String peopleApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)peopleApiUrl, (String)"peopleApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.peopleApiUrl = peopleApiUrl;
        this.webClient = webClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> getProfiles(@Nullable String query, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.profilesUri(query, offset, limit);
        boolean $i$f$get = false;
        return PeopleApiProfile.Companion.toApiProfiles((PeopleApiProfileSearchResults)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getProfiles$$inlined$get$1((WebClient)$this$get$iv, (URI)uri$iv, null)), (int)1, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiUserGroup> getUserGroups(@Nullable String query, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.userGroupsUri(query, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiUserGroups)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PeopleApiUserGroup getUserGroup(@NotNull String groupId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.userGroupDetailsUri(groupId);
        boolean $i$f$get = false;
        return ((PeopleApiUserGroupDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getUserGroup$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null)).getUserGroup();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> getUserGroupMembers(@NotNull String groupId, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        WebClient webClient = this.webClient;
        URI uRI = this.userGroupMembersUri(groupId, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiProfiles)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    private URI profilesUri(String query, int offset, int limit) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.peopleApiUrl + "/profiles";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder $this$profilesUri_u24lambda_u240 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        Object[] objectArray = new Object[]{offset};
        $this$profilesUri_u24lambda_u240.queryParam("offset", objectArray);
        objectArray = new Object[]{limit};
        $this$profilesUri_u24lambda_u240.queryParam("limit", objectArray);
        if (query != null) {
            objectArray = new Object[]{query};
            $this$profilesUri_u24lambda_u240.queryParam("query", objectArray);
        }
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    private URI userGroupsUri(String query, int offset, int limit) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.peopleApiUrl + "/usergroups";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder $this$userGroupsUri_u24lambda_u241 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        Object[] objectArray = new Object[]{offset};
        $this$userGroupsUri_u24lambda_u241.queryParam("offset", objectArray);
        objectArray = new Object[]{limit};
        $this$userGroupsUri_u24lambda_u241.queryParam("limit", objectArray);
        if (query != null) {
            objectArray = new Object[]{query};
            $this$userGroupsUri_u24lambda_u241.queryParam("query", objectArray);
        }
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    private URI userGroupDetailsUri(String groupId) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.peopleApiUrl + "/usergroups/" + groupId;
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    private URI userGroupMembersUri(String groupId, int offset, int limit) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.peopleApiUrl + "/usergroups/" + groupId + "/members";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder $this$userGroupMembersUri_u24lambda_u242 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        Object[] objectArray = new Object[]{offset};
        $this$userGroupMembersUri_u24lambda_u242.queryParam("offset", objectArray);
        objectArray = new Object[]{limit};
        $this$userGroupMembersUri_u24lambda_u242.queryParam("limit", objectArray);
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }
}

