/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiAttributes;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiConfiguration;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiProfile;
import de.justsoftware.mobile.gateway.people.service.LegacyProfileApiGatewayService;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0003H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService;", "", "toroBaseUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "getProfile", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiProfile;", "userId", "getProfileAttributes", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiAttributes;", "getProfileConfiguration", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiConfiguration;", "updateUserImage", "image", "Lorg/springframework/web/multipart/MultipartFile;", "deleteUserImage", "profileUri", "Ljava/net/URI;", "profileConfigurationUri", "updateUserImageUri", "deleteUserImageUri", "Companion", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nLegacyProfileApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyProfileApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n+ 3 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt\n+ 4 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt$buildUri$1\n*L\n1#1,61:1\n28#2:62\n28#2:63\n41#2:64\n53#2:65\n62#2:66\n7#3,5:67\n7#3,5:73\n7#3,5:79\n7#3,5:85\n9#4:72\n9#4:78\n9#4:84\n9#4:90\n*S KotlinDebug\n*F\n+ 1 LegacyProfileApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService\n*L\n23#1:62\n29#1:63\n35#1:64\n35#1:65\n42#1:66\n45#1:67,5\n48#1:73,5\n51#1:79,5\n54#1:85,5\n45#1:72\n48#1:78\n51#1:84\n54#1:90\n*E\n"})
public class LegacyProfileApiGatewayService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private static final String PROFILE_BASE = "/profile/api/v1";
    @NotNull
    private static final String UPDATE_IMAGE_PARAMETER_NAME = "image";

    public LegacyProfileApiGatewayService(@Value(value="${just.toro.internal.baseurl}") @NotNull String toroBaseUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.toroBaseUrl = toroBaseUrl;
        this.webClient = webClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiProfile getProfile(@NotNull String userId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.profileUri(userId);
        boolean $i$f$get = false;
        return (LegacyProfileApiProfile)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public LegacyProfileApiAttributes getProfileAttributes(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        LegacyProfileApiAttributes legacyProfileApiAttributes = this.getProfile(userId).getProfileAttributes();
        if (legacyProfileApiAttributes == null) {
            legacyProfileApiAttributes = LegacyProfileApiAttributes.Companion.getEMPTY();
        }
        return legacyProfileApiAttributes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiConfiguration getProfileConfiguration(@NotNull String userId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.profileConfigurationUri(userId);
        boolean $i$f$get = false;
        return (LegacyProfileApiConfiguration)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiProfile updateUserImage(@NotNull String userId, @NotNull MultipartFile image) {
        void name$iv;
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)image, (String)UPDATE_IMAGE_PARAMETER_NAME);
        WebClient webClient = this.webClient;
        URI uRI = this.updateUserImageUri(userId);
        String string = UPDATE_IMAGE_PARAMETER_NAME;
        boolean $i$f$post = false;
        return (LegacyProfileApiProfile)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiProfile deleteUserImage(@NotNull String userId) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.deleteUserImageUri(userId);
        boolean $i$f$delete = false;
        return (LegacyProfileApiProfile)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private URI profileUri(String userId) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.toroBaseUrl + "/profile/api/v1/" + userId;
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    private URI profileConfigurationUri(String userId) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.toroBaseUrl + "/profile/api/v1/attributes/configuration/" + userId;
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    private URI updateUserImageUri(String userId) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.toroBaseUrl + "/profile/api/v1/" + userId + "/image";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    private URI deleteUserImageUri(String userId) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.toroBaseUrl + "/profile/api/v1/" + userId + "/image";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }
}

