/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security.oauth2;

import de.justsoftware.gateway.security.oauth2.ClientTarget;
import de.justsoftware.gateway.security.oauth2.JustLoginHelper;
import de.justsoftware.gateway.security.oauth2.JustOauthLoginAuthenticationEntryPoint;
import de.justsoftware.gateway.security.oauth2.JwtAuthenticationManagerFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesRegistrationAdapter;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class JustInMemoryClientRegistrationRepository
implements ReactiveClientRegistrationRepository,
Iterable<ClientRegistration> {
    private static final Logger LOG = LoggerFactory.getLogger(JustInMemoryClientRegistrationRepository.class);
    private final ConcurrentHashMap<String, ReactiveAuthenticationManager> _authenticationManagers = new ConcurrentHashMap();
    private final JustOauthLoginAuthenticationEntryPoint _justOauthLoginAuthenticationEntryPoint;
    private final JwtAuthenticationManagerFactory _jwtAuthenticationManagerFactory;
    private final Map<String, ClientRegistration> _registrations;
    private boolean _externalIdpConfigured = false;

    @SuppressFBWarnings(value={"MC"}, justification="would need refactoring that should not be part of this commit")
    public JustInMemoryClientRegistrationRepository(OAuth2ClientProperties properties, JustOauthLoginAuthenticationEntryPoint justOauthLoginAuthenticationEntryPoint, JwtAuthenticationManagerFactory decoderFactory) {
        this._justOauthLoginAuthenticationEntryPoint = justOauthLoginAuthenticationEntryPoint;
        this._registrations = JustInMemoryClientRegistrationRepository.initializeRegistrations((OAuth2ClientProperties)properties);
        this._justOauthLoginAuthenticationEntryPoint.setDefaultIdp(this.getDefaultDesktopClient());
        this._jwtAuthenticationManagerFactory = decoderFactory;
    }

    @Nonnull
    private static Predicate<ClientRegistration> clientsForTarget(ClientTarget target) {
        return r -> {
            Object targetsObject = r.getProviderDetails().getConfigurationMetadata().get("targets");
            if (targetsObject instanceof Set) {
                return ((Set)targetsObject).contains(target);
            }
            return false;
        };
    }

    private static boolean isDefault(ClientRegistration r) {
        return ((Object)r.getProviderDetails().getConfigurationMetadata().getOrDefault("defaultProvider", false)).equals(Boolean.TRUE);
    }

    @Nonnull
    private static Map<String, ClientRegistration> initializeRegistrations(OAuth2ClientProperties properties) {
        return OAuth2ClientPropertiesRegistrationAdapter.getClientRegistrations((OAuth2ClientProperties)properties).values().stream().map(c -> {
            if (c.getRegistrationId().equals("just_mobile")) {
                return ClientRegistration.withClientRegistration((ClientRegistration)c).providerConfigurationMetadata(Map.of("targets", Set.of(ClientTarget.MOBILE_SOCIAL))).build();
            }
            if (c.getRegistrationId().equals("just")) {
                return ClientRegistration.withClientRegistration((ClientRegistration)c).providerConfigurationMetadata(Map.of("targets", Set.of(ClientTarget.DESKTOP))).build();
            }
            return c;
        }).collect(Collectors.toMap(ClientRegistration::getRegistrationId, Function.identity()));
    }

    @Override
    public synchronized Iterator<ClientRegistration> iterator() {
        return this._registrations.values().iterator();
    }

    public synchronized Mono<ClientRegistration> findByRegistrationId(String registrationId) {
        return Mono.justOrEmpty((Object)((ClientRegistration)this._registrations.get(registrationId)));
    }

    private void updateAuthenticationManagers() {
        Set currentlyActiveIssuers = this._authenticationManagers.keySet();
        Set<String> requiredIssuers = this._registrations.values().stream().map(it -> it.getProviderDetails().getIssuerUri()).filter(Objects::nonNull).filter(Predicate.not(String::isBlank)).collect(Collectors.toSet());
        requiredIssuers.forEach(arg_0 -> this.addManager(arg_0));
        currentlyActiveIssuers.forEach(uri -> {
            if (!requiredIssuers.contains(uri)) {
                this._authenticationManagers.remove(uri);
            }
        });
    }

    private void addManager(String issuerUri) {
        if (this._authenticationManagers.containsKey(issuerUri)) {
            return;
        }
        try {
            ReactiveAuthenticationManager manager = this._jwtAuthenticationManagerFactory.fromIssuerLocation(issuerUri);
            String key = this.getHostResolverKeyFromIssuer(issuerUri);
            if (key != null) {
                this._authenticationManagers.put(key, manager);
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Authentication manager for issuer-location " + issuerUri + " could not be added.", (Throwable)e);
        }
    }

    @Nonnull
    public Mono<ClientRegistration> findByClientId(String clientId, String issuer) {
        return Mono.justOrEmpty((Object)this._registrations.values().stream().filter(r -> r.getClientId().equals(clientId)).filter(r -> Objects.equals(this.getHostResolverKeyFromIssuer(r.getProviderDetails().getIssuerUri()), this.getHostResolverKeyFromIssuer(issuer))).findFirst().orElse(null));
    }

    @Nonnull
    public Mono<ReactiveAuthenticationManager> resolve(String issuer) {
        return Mono.justOrEmpty((Object)this.getHostResolverKeyFromIssuer(issuer)).filter(Predicate.not(String::isEmpty)).mapNotNull(this._authenticationManagers::get);
    }

    @CheckForNull
    private String getHostResolverKeyFromIssuer(@Nullable String issuer) {
        if (issuer == null) {
            return null;
        }
        try {
            return new URL(issuer).toExternalForm();
        }
        catch (MalformedURLException e) {
            LOG.warn("malformed issuer: " + issuer, (Throwable)e);
            return null;
        }
    }

    public void save(ClientRegistration registration) {
        this._registrations.put(registration.getRegistrationId(), registration);
        this.updateAuthenticationManagers();
        this.updateEntryPoint();
    }

    private void updateEntryPoint() {
        this._justOauthLoginAuthenticationEntryPoint.setDefaultIdp(this.getDefaultDesktopClient());
        this._externalIdpConfigured = this.getDefaultDesktopClient() != null;
    }

    public void delete(String clientRegistrationId) {
        this._registrations.remove(clientRegistrationId);
        this.updateAuthenticationManagers();
        this.updateEntryPoint();
    }

    @Nonnull
    public ClientRegistration getJustMobileClientRegistration() {
        return Objects.requireNonNull((ClientRegistration)this._registrations.get("just_mobile"));
    }

    @Nonnull
    public ClientRegistration getMobileClientRegistrationForTarget(ClientTarget target) {
        return this._registrations.values().stream().filter(JustInMemoryClientRegistrationRepository.clientsForTarget((ClientTarget)target)).filter(r -> !JustLoginHelper.isJustIdp((String)r.getRegistrationId())).findFirst().orElse(this.getJustMobileClientRegistration());
    }

    @Nonnull
    public Set<ClientRegistration> getAllDesktopClients() {
        return this._registrations.values().stream().filter(JustInMemoryClientRegistrationRepository.clientsForTarget((ClientTarget)ClientTarget.DESKTOP)).collect(Collectors.toUnmodifiableSet());
    }

    @CheckForNull
    private ClientRegistration getDefaultDesktopClient() {
        return this._registrations.values().stream().filter(JustInMemoryClientRegistrationRepository.clientsForTarget((ClientTarget)ClientTarget.DESKTOP)).filter(r -> !JustLoginHelper.isJustIdp((String)r.getRegistrationId())).filter(JustInMemoryClientRegistrationRepository::isDefault).findFirst().orElse(null);
    }

    public boolean isDesktopIdpConfigured() {
        return this._externalIdpConfigured;
    }
}

