/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway;

import de.justsoftware.gateway.domain.R2dbcRepositoryMarker;
import de.justsoftware.gateway.security.JustJwtProperties;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.reactive.ReactiveUserDetailsServiceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

@SpringBootApplication(exclude={ReactiveUserDetailsServiceAutoConfiguration.class})
@ParametersAreNonnullByDefault
@EnableR2dbcRepositories(basePackageClasses={R2dbcRepositoryMarker.class})
@EnableConfigurationProperties(value={JustJwtProperties.class})
public class JustGatewayApplication {
    private static final Logger LOG = LoggerFactory.getLogger(JustGatewayApplication.class);

    public static void main(String[] args) {
        LOG.debug("__ STARTING APPLICATION __");
        SpringApplication.run(JustGatewayApplication.class, (String[])args);
    }

    @Nonnull
    @Bean
    public RouterFunction<ServerResponse> imgRouter() {
        return RouterFunctions.resources((String)"/gateway/images/**", (Resource)new ClassPathResource("public/images/"));
    }
}

