/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.monitoring;

import de.justsoftware.drive.rest.monitoring.SolrPingHealthIndicator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SolrClient.class})
@ConditionalOnBean(value={SolrClient.class})
@ConditionalOnEnabledHealthIndicator(value="solrPing")
@AutoConfigureBefore(value={HealthContributorAutoConfiguration.class})
@ParametersAreNonnullByDefault
public class SolrPingHealthIndicatorAutoConfiguration
extends CompositeHealthContributorConfiguration<SolrPingHealthIndicator, SolrClient> {
    private final Map<String, SolrClient> _solrClients;

    public SolrPingHealthIndicatorAutoConfiguration(Map<String, SolrClient> solrClients) {
        super(SolrPingHealthIndicator::new);
        this._solrClients = solrClients;
    }

    @Bean
    @ConditionalOnMissingBean(name={"solrPingHealthIndicator"})
    @Nonnull
    public HealthContributor solrPingHealthIndicator() {
        return (HealthContributor)this.createContributor(this._solrClients);
    }
}

